/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.insert;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.BlockDataId;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.io.ObjectProtocol;
import com.simsilica.mworld.io.ProtocolSerializers;
import com.simsilica.mworld.tile.insert.BlockInsert;
import com.simsilica.mworld.tile.insert.InsertLayer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertLayerProtocol
implements ObjectProtocol<InsertLayer> {
    static Logger log = LoggerFactory.getLogger(InsertLayerProtocol.class);
    private int version = 43;
    private ProtocolSerializers protocols = new ProtocolSerializers();

    @Override
    public int getProtocolVersion() {
        return this.version;
    }

    @Override
    public void write(InsertLayer data, BitOutputStream out) throws IOException {
        out.writeBits(this.version, 16);
        TileId tileId = data.getTileId();
        Vec3i tileOrigin = tileId.getWorld(null);
        long id = tileId.getId();
        out.writeLongBits(id, 64);
        out.writeLongBits(data.getVersion().getVersion(), 64);
        out.writeBits(data.getGenerationLevel(), 8);
        List<BlockInsert> inserts = data.getInserts();
        int size = inserts.size();
        out.writeBits(size, 32);
        for (BlockInsert insert : inserts) {
            this.writeInsert(insert, tileOrigin, out);
        }
    }

    @Override
    public InsertLayer read(BitInputStream in) throws IOException {
        int version = in.readBits(16);
        TileId tileId = new TileId(in.readLongBits(64));
        Vec3i tileOrigin = tileId.getWorld(null);
        long dataVersion = in.readLongBits(64);
        int generationLevel = 0;
        if (version >= 43) {
            generationLevel = in.readBits(8);
        }
        int size = in.readBits(32);
        ArrayList<BlockInsert> inserts = new ArrayList<BlockInsert>(size);
        for (int i = 0; i < size; ++i) {
            BlockInsert insert = this.readInsert(tileOrigin, version, in);
            inserts.add(insert);
        }
        return new InsertLayer(tileId, new DataVersion(dataVersion), generationLevel, inserts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(InsertLayer morphs, OutputStream rawOut) throws IOException {
        try (BitOutputStream out = new BitOutputStream(rawOut);){
            this.write(morphs, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InsertLayer read(InputStream rawIn) throws IOException {
        try (BitInputStream in = new BitInputStream(rawIn);){
            InsertLayer insertLayer = this.read(in);
            return insertLayer;
        }
    }

    protected void writeInsert(BlockInsert insert, Vec3i tileOrigin, BitOutputStream out) throws IOException {
        int x = insert.world.x - tileOrigin.x;
        int y = insert.world.y;
        int z = insert.world.z - tileOrigin.z;
        out.writeBits(x, 10);
        out.writeBits(y, 10);
        out.writeBits(z, 10);
        out.writeLongBits(insert.blockDataId.getId(), 64);
        out.writeBits(insert.carveFlags, 8);
        out.writeBits((int)insert.xSize, 7);
        out.writeBits((int)insert.ySize, 7);
        out.writeBits((int)insert.zSize, 7);
        out.writeBits(insert.aboveGround ? 1 : 0, 1);
        out.writeBits((int)insert.groundLevel, 7);
        if (insert.objectId >= 0L) {
            out.writeBits(1, 1);
            out.writeLongBits(insert.objectId, 64);
        } else {
            out.writeBits(0, 1);
        }
    }

    protected BlockInsert readInsert(Vec3i tileOrigin, int version, BitInputStream in) throws IOException {
        int x = in.readBits(10) + tileOrigin.x;
        int y = in.readBits(10);
        int z = in.readBits(10) + tileOrigin.z;
        long id = in.readLongBits(64);
        BlockDataId blockDataId = new BlockDataId(id);
        int carveFlags = in.readBits(8);
        int xSize = in.readBits(7);
        int ySize = in.readBits(7);
        int zSize = in.readBits(7);
        boolean aboveGround = in.readBits(1) == 1;
        int groundLevel = in.readBits(7);
        BlockInsert result = new BlockInsert(new Vec3i(x, y, z), blockDataId, carveFlags, xSize, ySize, zSize, aboveGround, groundLevel, -1L);
        int hasObjectId = in.readBits(1);
        if (hasObjectId == 1) {
            result.objectId = in.readLongBits(64);
        }
        return result;
    }
}

