/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ext.mphys;

import com.google.common.base.Function;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.Gravity;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mphys.AbstractBody;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.DynArray;
import com.simsilica.mphys.Joint;
import com.simsilica.mphys.PhysicsFactory;
import com.simsilica.mphys.RigidBody;
import com.simsilica.mphys.StaticBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityBodyFactory<S extends AbstractShape>
implements PhysicsFactory<EntityId, S> {
    static Logger log = LoggerFactory.getLogger(EntityBodyFactory.class);
    private EntityData ed;
    private Vec3d defaultGravity;
    private ShapeFactory<S> shapeFactory;
    private DynArray<Function> dynamicInitializers = new DynArray(Function.class);
    private ShapeFactory<S> errorFactory;

    public EntityBodyFactory(EntityData ed, Vec3d defaultGravity, ShapeFactory<S> shapeFactory) {
        this.ed = ed;
        this.defaultGravity = defaultGravity;
        this.shapeFactory = shapeFactory;
    }

    public void setDefaultGravity(Vec3d defaultGravity) {
        this.defaultGravity = defaultGravity;
    }

    public Vec3d getDefaultGravity() {
        return this.defaultGravity;
    }

    public void setShapeFactory(ShapeFactory<S> shapeFactory) {
        this.shapeFactory = shapeFactory;
    }

    public ShapeFactory getShapeFactory() {
        return this.shapeFactory;
    }

    public void setErrorFactory(ShapeFactory<S> errorFactory) {
        this.errorFactory = errorFactory;
    }

    public ShapeFactory<S> getErrorFactory() {
        return this.errorFactory;
    }

    public void addDynamicInitializer(Function<RigidBody<EntityId, S>, ?> i) {
        if (i == null) {
            throw new IllegalArgumentException("Initializer cannot be null");
        }
        this.dynamicInitializers.add(i);
    }

    public void removeDynamicInitializer(Function<RigidBody<EntityId, S>, ?> i) {
        this.dynamicInitializers.remove(i);
    }

    protected <T extends EntityComponent> T getComponent(EntityId id, Class<T> type) {
        return (T)this.ed.getComponent(id, type);
    }

    protected S createShape(ShapeInfo info, Mass mass) {
        try {
            return this.shapeFactory.createShape(info, mass);
        }
        catch (Exception e) {
            log.error("Error creating shape for:" + info.toString(this.ed));
            return this.errorFactory.createShape(info, mass);
        }
    }

    protected RigidBody<EntityId, S> createRigidBody(EntityId id, SpawnPosition pos, ShapeInfo info, Mass mass, Gravity gravity) {
        log.debug("createRigidBody(" + id + ")");
        S shape = this.createShape(info, mass);
        RigidBody body = new RigidBody((Object)id, shape);
        shape.setWorldShapeOrigin((AbstractBody)body, pos.getLocation(), pos.getOrientation());
        if (gravity == null) {
            body.setLinearAcceleration(this.defaultGravity);
        } else {
            body.setLinearAcceleration(gravity.getLinearAcceleration());
        }
        return body;
    }

    protected StaticBody<EntityId, S> createStaticBody(EntityId id, SpawnPosition pos, ShapeInfo info, Mass mass) {
        log.debug("createStaticBody(" + id + ")");
        S shape = this.createShape(info, mass);
        StaticBody body = new StaticBody((Object)id, shape);
        shape.setWorldShapeOrigin((AbstractBody)body, pos.getLocation(), pos.getOrientation());
        return body;
    }

    public RigidBody<EntityId, S> createRigidBody(EntityId id) {
        RigidBody<EntityId, S> body = this.createRigidBody(id, this.getComponent(id, SpawnPosition.class), this.getComponent(id, ShapeInfo.class), this.getComponent(id, Mass.class), this.getComponent(id, Gravity.class));
        for (Function i : (Function[])this.dynamicInitializers.getArray()) {
            i.apply(body);
        }
        return body;
    }

    public StaticBody<EntityId, S> createStaticBody(EntityId id) {
        return this.createStaticBody(id, this.getComponent(id, SpawnPosition.class), this.getComponent(id, ShapeInfo.class), this.getComponent(id, Mass.class));
    }

    public Joint<EntityId, S> createJoint(EntityId key, RigidBody<EntityId, S> end1, RigidBody<EntityId, S> end2) {
        throw new UnsupportedOperationException();
    }
}

