/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.db;

import com.simsilica.mblock.CellData;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.db.ColumnDb;
import com.simsilica.mworld.db.ColumnNeighborhood;
import com.simsilica.mworld.db.ColumnPostProcessor;
import com.simsilica.mworld.db.PostProcColumnDb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightingPostProcessor
implements ColumnPostProcessor {
    static Logger log = LoggerFactory.getLogger(LightingPostProcessor.class);
    private PostProcColumnDb parent;
    private ColumnDb delegate;

    @Override
    public void initialize(PostProcColumnDb parent) {
        this.parent = parent;
        this.delegate = parent.getDelegate();
    }

    @Override
    public void terminate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean postProcess(ColumnData col) {
        if (col.hasGenerationFlag(8)) {
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace("postProcess(" + col + ")");
        }
        ColumnNeighborhood cellData = new ColumnNeighborhood(this.delegate, col);
        CellData lightData = cellData.getLightingCellData();
        ColumnData columnData = col;
        synchronized (columnData) {
            int count = LightUtils.propagateBorders((CellData)cellData, (CellData)lightData, (int)0, (int)0, (int)0, (int)32, (int)col.getCeiling(), (int)32);
            if (count > 500000 && log.isTraceEnabled()) {
                log.trace(col + " iteration overrun");
            }
        }
        col.setGenerationFlag(8);
        return true;
    }
}

