/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.db;

import com.simsilica.mblock.CellData;
import com.simsilica.mblock.FluidUtils;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.db.ColumnDb;
import com.simsilica.mworld.db.ColumnNeighborhood;
import com.simsilica.mworld.db.ColumnPostProcessor;
import com.simsilica.mworld.db.PostProcColumnDb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaskPostProcessor
implements ColumnPostProcessor {
    static Logger log = LoggerFactory.getLogger(MaskPostProcessor.class);
    private PostProcColumnDb parent;
    private ColumnDb delegate;

    @Override
    public void initialize(PostProcColumnDb parent) {
        this.parent = parent;
        this.delegate = parent.getDelegate();
    }

    @Override
    public void terminate() {
    }

    @Override
    public boolean postProcess(ColumnData col) {
        if (col.hasGenerationFlag(1)) {
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace("postProcess(" + col + ")  flags:" + Long.toBinaryString(col.getGenerationFlags()));
        }
        ColumnNeighborhood cellData = new ColumnNeighborhood(this.delegate, col);
        LeafData[] leafs = col.getLeafs();
        int size = 32;
        int zSize = 32;
        for (int i = 0; i < leafs.length; ++i) {
            LeafData leaf = leafs[i];
            if (leaf == null || leaf.isEmpty()) continue;
            int k = 32 * i;
            int n = MaskUtils.calculateSideMasks((CellData)cellData, (int)0, (int)k, (int)0, (int)32, (int)(k + 32), (int)32, (int)-1);
        }
        FluidData[] fluids = col.getFluid();
        for (int i = 0; i < fluids.length; ++i) {
            FluidData fluid = fluids[i];
            if (fluid == null || fluid.isEmpty()) continue;
            int k = 32 * i;
            FluidUtils.calculateSideMasks((CellData)cellData.getFluidCellData(), (CellData)cellData, (int)0, (int)k, (int)0, (int)32, (int)(k + 32), (int)32);
            FluidUtils.calculateFluidSlopes((CellData)cellData.getFluidCellData(), (CellData)cellData, (int)0, (int)k, (int)0, (int)32, (int)(k + 32), (int)32);
        }
        col.setGenerationFlag(1);
        return true;
    }
}

