/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.config;

import com.jme3.asset.AssetManager;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.FluidName;
import com.simsilica.mblock.FluidType;
import com.simsilica.mblock.FluidTypeIndex;
import com.simsilica.mblock.config.MaterialConfig;
import com.simsilica.mblock.config.MaterialRegistry;
import com.simsilica.mblock.config.TextureConfig;
import com.simsilica.mblock.geom.BlockFactory;
import com.simsilica.mblock.geom.DefaultBlockFactory;
import com.simsilica.mblock.geom.DefaultPartFactory;
import com.simsilica.mblock.geom.GeomPart;
import com.simsilica.mblock.geom.GeomReq;
import com.simsilica.mblock.geom.GeometryFactory;
import com.simsilica.mblock.geom.LiquidFactory;
import com.simsilica.mblock.geom.MaterialType;
import com.simsilica.mblock.geom.PartFactory;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBlockSet {
    public static final String MAT_BASE = "base";
    public static final String MAT_SPECIAL = "special";
    public static final String MAT_WATER = "water";
    public static final String MAT_LAVA = "lava";
    public static final String MAT_BAD = "bad";
    static Logger log = LoggerFactory.getLogger(DefaultBlockSet.class);
    private MaterialRegistry materials = new MaterialRegistry();

    public DefaultBlockSet(AssetManager assets, String baseTexture, String specialTexture, String badTexture) {
        if (!BlockTypeIndex.isInitialized()) {
            DefaultBlockSet.initializeBlockTypes();
        }
        this.materials = DefaultBlockSet.createDefaultMaterials(baseTexture, specialTexture, badTexture);
        this.initializeMaterials(assets);
    }

    protected void initializeMaterials(AssetManager assets) {
        this.materials.initialize(assets);
    }

    public static MaterialRegistry createDefaultMaterials(String baseTexture, String specialTexture, String badTexture) {
        MaterialRegistry materials = new MaterialRegistry();
        TextureConfig texture1 = new TextureConfig(baseTexture, true, true, true);
        TextureConfig texture2 = new TextureConfig(specialTexture, true, true, true);
        TextureConfig texture3 = new TextureConfig(badTexture, true, true, true);
        MaterialConfig config = new MaterialConfig(MAT_BASE, "MatDefs/MBlockLighting.j3md");
        config.addGeomReq(GeomReq.Normals);
        config.put("DiffuseMap", texture1);
        config.put("Diffuse", ColorRGBA.White);
        config.put("Ambient", ColorRGBA.White);
        config.put("UseMaterialColors", true);
        config.put("UseFog", true);
        config.put("FogColor", new ColorRGBA(0.7f, 0.7f, 0.9f, 1.0f));
        config.put("ExpFog", Float.valueOf(1.6666666E-4f));
        materials.addConfig(config);
        config = new MaterialConfig(MAT_BAD, config);
        config.put("DiffuseMap", texture3);
        materials.addConfig(config);
        config = new MaterialConfig(MAT_SPECIAL, config);
        config.put("DiffuseMap", texture2);
        config.put("Diffuse", new ColorRGBA(1.0f, 1.0f, 1.0f, 0.75f));
        config.getRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        materials.addConfig(config);
        config = new MaterialConfig(MAT_BASE, "MatDefs/MBlockLighting.j3md");
        config.addGeomReq(GeomReq.IndexedNormals);
        config.put("NormalLookup", true);
        materials.addConfig(config);
        config = new MaterialConfig(MAT_SPECIAL, "MatDefs/MBlockLighting.j3md");
        config.addGeomReq(GeomReq.IndexedNormals);
        config.put("NormalLookup", true);
        materials.addConfig(config);
        config = new MaterialConfig(MAT_BAD, "MatDefs/MBlockLighting.j3md");
        config.addGeomReq(GeomReq.IndexedNormals);
        config.put("NormalLookup", true);
        materials.addConfig(config);
        config = new MaterialConfig(MAT_BAD, "MatDefs/MBlockLighting.j3md");
        config.addGeomReq(GeomReq.Normals);
        materials.addConfig(config);
        config = new MaterialConfig(MAT_WATER, "MatDefs/MBlockLighting.j3md");
        config.addGeomReq(GeomReq.IndexedNormals);
        config.put("NormalLookup", true);
        config.put("Diffuse", new ColorRGBA(0.1f, 0.5f, 0.7f, 0.5f));
        config.put("Ambient", new ColorRGBA(0.1f, 0.5f, 0.7f, 0.5f));
        config.put("UseMaterialColors", true);
        config.put("UseFog", true);
        config.put("FogColor", new ColorRGBA(0.7f, 0.7f, 0.9f, 1.0f));
        config.put("ExpFog", Float.valueOf(1.6666666E-4f));
        config.getRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        materials.addConfig(config);
        config = new MaterialConfig(MAT_LAVA, "MatDefs/MBlockLighting.j3md");
        config.addGeomReq(GeomReq.IndexedNormals);
        config.put("NormalLookup", true);
        config.put("Diffuse", new ColorRGBA(0.7f, 0.5f, 0.1f, 0.95f));
        config.put("Ambient", new ColorRGBA(0.7f, 0.5f, 0.1f, 0.95f));
        config.put("UseMaterialColors", true);
        config.put("UseFog", true);
        config.put("FogColor", new ColorRGBA(0.7f, 0.7f, 0.9f, 1.0f));
        config.put("ExpFog", Float.valueOf(1.6666666E-4f));
        config.getRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        materials.addConfig(config);
        return materials;
    }

    public static final BlockType[] createBlockTypes() {
        MaterialType base = new MaterialType(MAT_BASE, true, true, false);
        MaterialType special = new MaterialType(MAT_SPECIAL, true, true, false);
        MaterialType bad = new MaterialType(MAT_BAD, true, true, false);
        int specialTypeCount = 17;
        BlockType[] types = new BlockType[65 + specialTypeCount];
        for (int i = 0; i < 64; ++i) {
            types[i + 1] = new BlockType(new BlockName(MAT_BASE + i, "cube"), DefaultBlockSet.createFactory(base, i));
        }
        int group = 0;
        short light = 2711;
        types[65] = new BlockType(new BlockName("light", "flame"), group, light, DefaultBlockSet.createSpecialFactory(special, 0, new Vec3d(0.25, 0.0, 0.25), new Vec3d(0.75, 0.75, 0.75)), null);
        light = 4095;
        types[66] = new BlockType(new BlockName("sm_light", "cube", 0), group, light, DefaultBlockSet.createSpecialFactory(special, 1, new Vec3d(0.4, 0.4, 0.0), new Vec3d(0.6, 0.6, 0.2)));
        types[67] = new BlockType(new BlockName("sm_light", "cube", 1), group, light, DefaultBlockSet.createSpecialFactory(special, 2, new Vec3d(0.4, 0.4, 0.8), new Vec3d(0.6, 0.6, 1.0)));
        types[68] = new BlockType(new BlockName("sm_light", "cube", 2), group, light, DefaultBlockSet.createSpecialFactory(special, 3, new Vec3d(0.8, 0.4, 0.4), new Vec3d(1.0, 0.6, 0.6)));
        types[69] = new BlockType(new BlockName("sm_light", "cube", 3), group, light, DefaultBlockSet.createSpecialFactory(special, 4, new Vec3d(0.0, 0.4, 0.4), new Vec3d(0.2, 0.6, 0.6)));
        types[70] = new BlockType(new BlockName("unknown", "cube"), group, light, DefaultBlockSet.createSpecialFactory(special, 5, new Vec3d(0.25, 0.25, 0.25), new Vec3d(0.75, 0.75, 0.75)));
        types[71] = new BlockType(new BlockName("unknown", "cube"), group, light, DefaultBlockSet.createSpecialFactory(special, 6, new Vec3d(0.25, 0.25, 0.25), new Vec3d(0.75, 0.75, 0.75)));
        types[72] = new BlockType(new BlockName("unknown", "cube"), group, light, DefaultBlockSet.createSpecialFactory(special, 7, new Vec3d(0.25, 0.25, 0.25), new Vec3d(0.75, 0.75, 0.75)));
        for (int i = 0; i < 8; ++i) {
            types[73 + i] = new BlockType(new BlockName(MAT_WATER, "cube" + i), 1, DefaultBlockSet.createFactory(special, 0.9, i + 8), null);
        }
        types[81] = new BlockType(new BlockName(MAT_BAD, "cube"), DefaultBlockFactory.createCube(0.0, bad), null);
        return types;
    }

    public static final void initializeBlockTypes() {
        BlockType[] types = DefaultBlockSet.createBlockTypes();
        BlockTypeIndex.initialize(types, 81);
    }

    public static final FluidType[] createFluidTypes() {
        EnumSet<GeomReq> geomReqs = EnumSet.of(GeomReq.IndexedNormals);
        MaterialType mWater = new MaterialType(MAT_WATER, geomReqs);
        MaterialType mLava = new MaterialType(MAT_LAVA, geomReqs);
        FluidType[] fluidTypes = new FluidType[]{null, new FluidType(new FluidName(MAT_WATER), new LiquidFactory(mWater)), new FluidType(new FluidName(MAT_LAVA), new LiquidFactory(mLava))};
        return fluidTypes;
    }

    public static final void initializeFluidTypes() {
        FluidType[] types = DefaultBlockSet.createFluidTypes();
        FluidTypeIndex.initialize(types);
    }

    public GeometryFactory createGeometryFactory(boolean allowCollisions) {
        return new GeometryFactory(allowCollisions, this.materials.getMaterials());
    }

    public MaterialRegistry getMaterials() {
        return this.materials;
    }

    private static BlockFactory createFactory(MaterialType mt, int color) {
        return DefaultBlockSet.createFactory(mt, 0.0, color);
    }

    private static BlockFactory createFactory(MaterialType mt, double transparency, int color) {
        int x = color & 7;
        int y = (color & 0x38) >> 3;
        float textureScale = 0.125f;
        float halfScale = textureScale * 0.5f;
        float s = (float)x * textureScale + halfScale;
        float t = 1.0f - ((float)y * textureScale + halfScale);
        DefaultBlockFactory result = DefaultBlockFactory.createCube(transparency, mt);
        for (PartFactory partFactory : result.getDirParts()) {
            for (GeomPart part : ((DefaultPartFactory)partFactory).getTemplates()) {
                float[] texes = part.getTexCoords();
                for (int i = 0; i < texes.length; i += 2) {
                    texes[i] = s;
                    texes[i + 1] = t;
                }
            }
        }
        return result;
    }

    private static BlockFactory createSpecialFactory(MaterialType mt, int color, Vec3d min, Vec3d max) {
        int x = color & 7;
        int y = (color & 0x38) >> 3;
        float textureScale = 0.125f;
        float halfScale = textureScale * 0.5f;
        float s = (float)x * textureScale + halfScale;
        float t = 1.0f - ((float)y * textureScale + halfScale);
        DefaultPartFactory partFactory = DefaultPartFactory.create(GeomPart.createQuad(min, max, mt, Direction.North), GeomPart.createQuad(min, max, mt, Direction.South), GeomPart.createQuad(min, max, mt, Direction.East), GeomPart.createQuad(min, max, mt, Direction.West), GeomPart.createQuad(min, max, mt, Direction.Up), GeomPart.createQuad(min, max, mt, Direction.Down));
        for (GeomPart part : partFactory.getTemplates()) {
            float[] texes = part.getTexCoords();
            for (int i = 0; i < texes.length; i += 2) {
                texes[i] = s;
                texes[i + 1] = t;
            }
        }
        DefaultBlockFactory result = DefaultBlockFactory.create(null, partFactory);
        return result;
    }
}

