/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mod;

import com.google.common.base.MoreObjects;
import com.simsilica.mod.ModInfo;
import com.simsilica.mod.ModManager;
import groovy.lang.Binding;
import groovy.util.GroovyScriptEngine;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModPack {
    static Logger log = LoggerFactory.getLogger(ModPack.class);
    private URI root;
    private ModInfo info;
    private GroovyScriptEngine scriptEngine;
    private ModManager manager;
    private List<Runnable> terminateCallbacks = new ArrayList<Runnable>();

    public ModPack(URI root, ModInfo info) {
        this.root = root;
        this.info = info;
    }

    protected ModManager getModManager() {
        return this.manager;
    }

    public void initialize(ModManager manager) {
        this.manager = manager;
        try {
            CompilerConfiguration config = new CompilerConfiguration();
            ImportCustomizer imports = new ImportCustomizer();
            for (String s : manager.getGlobalImports()) {
                log.info("Adding import:" + s);
                if (s.endsWith(".*")) {
                    imports.addStarImports(new String[]{s.substring(0, s.length() - 2)});
                    continue;
                }
                imports.addImports(new String[]{s});
            }
            for (String s : manager.getGlobalStaticImports()) {
                log.info("Adding static import:" + s);
                if (s.endsWith(".*")) {
                    imports.addStaticStars(new String[]{s.substring(0, s.length() - 2)});
                    continue;
                }
                int split = s.lastIndexOf(46);
                if (split < 0) {
                    throw new RuntimeException("Invalid static import format:" + s);
                }
                String c = s.substring(0, split);
                String n = s.substring(split + 1);
                imports.addStaticImport(c, n);
            }
            config.addCompilationCustomizers(new CompilationCustomizer[]{imports});
            this.scriptEngine = new GroovyScriptEngine(new URL[]{this.root.toURL()});
            this.scriptEngine.setConfig(config);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error resolving root to URL:" + this.root, e);
        }
        LocalBinding binding = new LocalBinding(this.info.getGroupId() + "." + this.info.getName(), manager.getGlobalBindings());
        for (String s : this.info.getInitScripts()) {
            log.info("Running:" + s);
            try {
                this.scriptEngine.run(s, (Binding)binding);
            }
            catch (Exception e) {
                throw new RuntimeException("Error running:" + s, e);
            }
        }
        log.info("post bindings:" + manager.getGlobalBindings());
    }

    public void terminate() {
        for (Runnable callback : this.terminateCallbacks) {
            try {
                log.info("Running terminate callback:" + callback);
                callback.run();
            }
            catch (Exception e) {
                throw new RuntimeException("Error running termination callback:" + callback, e);
            }
        }
        this.terminateCallbacks.clear();
        LocalBinding binding = new LocalBinding(this.info.getGroupId() + "." + this.info.getName(), this.manager.getGlobalBindings());
        for (String s : this.info.getTerminateScripts()) {
            log.info("Running:" + s);
            try {
                this.scriptEngine.run(s, (Binding)binding);
            }
            catch (Exception e) {
                throw new RuntimeException("Error running:" + s, e);
            }
        }
    }

    public String getId() {
        return this.info.getId();
    }

    public URI getRoot() {
        return this.root;
    }

    public List<String> getDependencies() {
        return this.info.getDependencies();
    }

    public ModInfo getInfo() {
        return this.info;
    }

    public Map<String, Object> getConfig() {
        return this.info.getConfig();
    }

    public void onTerminate(Runnable callback) {
        this.terminateCallbacks.add(callback);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("root", (Object)this.root).add("info", (Object)this.info).toString();
    }

    private class LocalBinding
    extends Binding {
        private Logger log;

        public LocalBinding(String context, Map<String, Object> map) {
            super(map);
            this.log = LoggerFactory.getLogger((String)context);
        }

        public ModPack getMod() {
            return ModPack.this;
        }

        public void setVariable(String name, Object value) {
            if ("mod".equals(name)) {
                throw new IllegalArgumentException("The 'mod' binding is hard-wired.");
            }
            if ("log".equals(name)) {
                throw new IllegalArgumentException("The 'log' binding is hard-wired.");
            }
            super.setVariable(name, value);
        }

        public Object getProperty(String property) {
            if ("mod".equals(property)) {
                return this.getMod();
            }
            if ("log".equals(property)) {
                return this.log;
            }
            return super.getProperty(property);
        }

        public Object getVariable(String name) {
            if ("mod".equals(name)) {
                return this.getMod();
            }
            if ("log".equals(name)) {
                return this.log;
            }
            return super.getVariable(name);
        }

        public boolean hasVariable(String name) {
            if ("mod".equals(name)) {
                return true;
            }
            if ("log".equals(name)) {
                return true;
            }
            return super.hasVariable(name);
        }
    }
}

