/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld;

import com.simsilica.mathd.Grid;
import com.simsilica.mathd.GridCell;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.GridBasedId;
import com.simsilica.mworld.WorldGrids;
import java.util.Objects;

public class SedectileId
implements GridBasedId {
    public static final int SIZE = 1024;
    public static final Grid GRID = WorldGrids.SEDECTILE_GRID;
    private long id;

    public SedectileId(long id) {
        this.id = id;
    }

    public static SedectileId fromWorld(Vec3i world) {
        return SedectileId.fromWorld(world.x, world.y, world.z);
    }

    public static SedectileId fromWorld(Vec3d world) {
        return SedectileId.fromWorld(world.x, world.y, world.z);
    }

    public static SedectileId fromWorld(double x, double y, double z) {
        long id = GRID.worldToId(x, y, z);
        return new SedectileId(id);
    }

    public static SedectileId fromWorld(int x, int y, int z) {
        long id = GRID.worldToId((double)x, (double)y, (double)z);
        return new SedectileId(id);
    }

    public static SedectileId fromCell(int xCell, int zCell) {
        long id = GRID.cellToId(xCell, 0, zCell);
        return new SedectileId(id);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Vec3i getWorld(Vec3i store) {
        Vec3i loc = GRID.idToCell(this.id, store);
        loc = GRID.cellToWorld(loc, loc);
        return loc;
    }

    public Vec3i getCell(Vec3i store) {
        return GRID.idToCell(this.id, store);
    }

    @Override
    public GridCell getGridCell() {
        return this.getGrid().getContainingCell(this.getWorld(null));
    }

    @Override
    public Grid getGrid() {
        return GRID;
    }

    @Override
    public Grid getParentGrid() {
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SedectileId other = (SedectileId)o;
        return other.id == this.id;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.id + "]";
    }
}

