/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.db.SpoolingObjectDb;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageId;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import com.simsilica.mworld.tile.io.TerrainImageProtocol;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerrainImageDb
extends SpoolingObjectDb<TerrainImageId, TerrainImage> {
    static Logger log = LoggerFactory.getLogger(TerrainImageDb.class);
    private File root;
    private TerrainImageProtocol protocol = new TerrainImageProtocol();

    public TerrainImageDb(File root) {
        this.root = root;
    }

    public TileFunction getTileFunction(final TerrainImageType type) {
        return new TileFunction(){

            @Override
            public void accept(Tile tile) {
                TerrainImage image = tile.get((Object)type, TerrainImage.class);
                if (image != null) {
                    throw new IllegalStateException("Tile:" + tile.getTileId() + " already has terrain image for:" + (Object)((Object)type));
                }
                image = (TerrainImage)TerrainImageDb.this.get(new TerrainImageId(tile.getTileId(), type, tile.getResolution()));
                tile.put((Object)type, image);
            }
        };
    }

    public TileFunction getLoadFunction() {
        return new TileFunction(){

            @Override
            public void accept(Tile tile) {
                for (TerrainImageType type : TerrainImageType.values()) {
                    TerrainImage image = tile.get((Object)type, TerrainImage.class);
                    if (image != null) {
                        throw new IllegalStateException("Tile:" + tile.getTileId() + " already has terrain image for:" + (Object)((Object)type));
                    }
                    image = (TerrainImage)TerrainImageDb.this.get(new TerrainImageId(tile.getTileId(), type, tile.getResolution()));
                    tile.put((Object)type, image);
                }
            }
        };
    }

    public TileFunction getSaveFunction() {
        return new TileFunction(){

            @Override
            public void accept(Tile tile) {
                for (TerrainImageType type : TerrainImageType.values()) {
                    TerrainImage image = tile.get((Object)type, TerrainImage.class);
                    if (!image.getVersion().isChanged()) continue;
                    log.info("Storing:" + image);
                    TerrainImageDb.this.update(image.getId(), image);
                }
            }
        };
    }

    @Override
    public void update(TerrainImageId id, TerrainImage image) {
        if (log.isTraceEnabled()) {
            log.trace("update(" + id + ", " + image + ")");
        }
        super.update(id, image);
        TerrainImageId lower = id.getLowerResolution();
        if (lower != null) {
            TerrainImage target = (TerrainImage)this.get(lower);
            target.write(image);
            target.getVersion().markChanged();
            this.update(lower, target);
        }
    }

    protected File toFile(TerrainImageId id) {
        Vec3i sedectile = id.getParentId().getCell(null);
        String path = sedectile.y + "/" + sedectile.x + "/" + sedectile.z;
        File dir = new File(this.root, path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String name = id.getTileId().getId() + "-" + (Object)((Object)id.getResolution()) + "." + (Object)((Object)id.getType());
        return new File(dir, name);
    }

    @Override
    protected TerrainImage loadObject(TerrainImageId id) {
        File file;
        if (log.isTraceEnabled()) {
            log.trace("loadObject(" + id + ")");
        }
        if ((file = this.toFile(id)).exists()) {
            TerrainImage result = this.readObjectFile(id, file);
            return result;
        }
        return new TerrainImage(id, new DataVersion(-1L));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected TerrainImage readObjectFile(TerrainImageId id, File file) {
        try (BufferedInputStream in = new BufferedInputStream(new GZIPInputStream(new FileInputStream(file)));){
            TerrainImage result = this.protocol.read(in);
            assert (id.equals(result.getId()));
            if (log.isTraceEnabled()) {
                log.trace("Loaded terrain image for:" + id);
            }
            TerrainImage terrainImage = result;
            return terrainImage;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading object:" + id + " from:" + file, e);
        }
    }

    @Override
    protected void storeObject(TerrainImageId id, TerrainImage value) {
        File file = this.toFile(id);
        this.writeObjectFile(id, file, value);
        value.getVersion().resetChanged(System.currentTimeMillis());
    }

    protected void writeObjectFile(TerrainImageId id, File file, TerrainImage value) {
        if (log.isTraceEnabled()) {
            log.trace("writeObjectFile(" + id + ", " + file + ")");
        }
        long start = System.nanoTime();
        try (BufferedOutputStream out = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file)));){
            this.protocol.write(value, out);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing object:" + id + " to:" + file, e);
        }
        long end = System.nanoTime();
        log.info("Wrote [" + id + "] in " + (double)(end - start) / 1000000.0 + " ms");
    }
}

