/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.view;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.material.Material;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.SafeArrayList;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.geom.ColliderlessMesh;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.World;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.tree.Tree;
import com.simsilica.mworld.tile.tree.TreeLayer;
import com.simsilica.mworld.view.FogSettings;
import com.simsilica.mworld.view.MaterialFactories;
import com.simsilica.mworld.view.TerrainState;
import com.simsilica.mworld.view.ViewMask;
import com.simsilica.state.BlackboardState;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(TreeState.class);
    private Node treeRoot;
    private World world;
    private JobState workers;
    private int basePriority = 500;
    private VersionedReference<Vec3d> posRef;
    private Function<String, Material> materialFactory;
    private int treeRadius = 2;
    private int conveyorSize = this.treeRadius * 2 + 1;
    private TileGeometry[][] tiles = new TileGeometry[this.conveyorSize][this.conveyorSize];
    private Vec3i center = new Vec3i(0, 100, 0);
    private Vec3i centerWorld = new Vec3i();
    private FogSettings fogSettings;
    private VersionedReference<FogSettings> fogSettingsRef;
    private float clipDistance = 6000.0f;
    private SafeArrayList<TileGeometry> fadingTiles = new SafeArrayList(TileGeometry.class);
    private boolean xzLockedCamera = false;
    private ViewMask viewMask;
    private VersionedReference<Vec3i> maskCenter;

    public TreeState() {
        this(false);
    }

    public TreeState(boolean xzLockedCamera) {
        this.xzLockedCamera = xzLockedCamera;
    }

    public void setXzLockedCamera(boolean f) {
        this.xzLockedCamera = f;
    }

    public boolean isXzLockedCamera() {
        return this.xzLockedCamera;
    }

    public void setMaterialFactory(Function<String, Material> materialFactory) {
        if (this.materialFactory == materialFactory) {
            return;
        }
        this.materialFactory = materialFactory;
        if (this.tiles != null) {
            for (int i = 0; i < this.conveyorSize; ++i) {
                for (int j = 0; j < this.conveyorSize; ++j) {
                    TileGeometry tile = this.tiles[i][j];
                    if (tile == null) continue;
                    tile.updateMaterial(materialFactory);
                }
            }
        }
    }

    public Function<String, Material> getMaterialFactory() {
        return this.materialFactory;
    }

    public void setClipDistance(float distance) {
        if (this.clipDistance == distance) {
            return;
        }
        this.clipDistance = distance;
        this.resetFog();
    }

    public float getClipDistance() {
        return this.clipDistance;
    }

    public void setFogSettings(FogSettings fogSettings) {
        this.fogSettings = fogSettings;
        this.fogSettingsRef = fogSettings == null ? null : fogSettings.createReference();
        this.resetFog();
    }

    public FogSettings getFogSettings() {
        return this.fogSettings;
    }

    protected int getFogDistance() {
        return this.fogSettings == null ? 0 : this.fogSettings.getFogDistance();
    }

    protected void resetFog() {
        if (this.treeRoot != null) {
            TerrainState.updateFogDistance((Spatial)this.treeRoot, this.getFogDistance(), this.clipDistance);
        }
    }

    protected void setViewMask(ViewMask viewMask) {
        this.viewMask = viewMask;
        this.maskCenter = viewMask.createReference();
        if (this.tiles != null) {
            for (int i = 0; i < this.conveyorSize; ++i) {
                for (int j = 0; j < this.conveyorSize; ++j) {
                    TileGeometry tile = this.tiles[i][j];
                    if (tile == null) continue;
                    tile.updateViewMask();
                }
            }
        }
    }

    protected void initialize(Application app) {
        this.treeRoot = new Node("TreesRoot");
        if (this.getMaterialFactory() == null) {
            log.warn("No material factory configured.  Using a default treeBuildboardMaterial()");
            this.setMaterialFactory(MaterialFactories.treeBillboardMaterial(this.getApplication()));
        }
        BlackboardState blackboard = (BlackboardState)this.getState(BlackboardState.class, true);
        this.world = (World)blackboard.get(World.class);
        blackboard.onInitialize(ViewMask.class, mask -> this.setViewMask((ViewMask)mask));
        blackboard.onInitialize(FogSettings.class, fogSettings -> this.setFogSettings((FogSettings)fogSettings));
        this.workers = (JobState)this.getState("regularWorkers", JobState.class);
        this.posRef = ((VersionedObject)blackboard.get("position")).createReference();
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        ((SimpleApplication)this.getApplication()).getRootNode().attachChild((Spatial)this.treeRoot);
    }

    protected void onDisable() {
        this.treeRoot.removeFromParent();
    }

    public void update(float tpf) {
        if (this.posRef.update()) {
            Vec3d pos = (Vec3d)this.posRef.get();
            this.updateTiles(pos);
            if (this.xzLockedCamera) {
                this.treeRoot.setLocalTranslation(-((float)(pos.x - (double)this.centerWorld.x)), 0.0f, -((float)(pos.z - (double)this.centerWorld.z)));
            } else {
                Vec3d columnPos = ColumnId.fromWorld(pos).getWorld(null).toVec3d();
                this.treeRoot.setLocalTranslation(-((float)(columnPos.x - (double)this.centerWorld.x)), 0.0f, -((float)(columnPos.z - (double)this.centerWorld.z)));
            }
        }
        if (this.fogSettingsRef != null && this.fogSettingsRef.update()) {
            this.resetFog();
        }
        if (this.maskCenter.update()) {
            Vec3i columnPos = ColumnId.fromWorld((Vec3d)this.posRef.get()).getWorld(null);
            for (int i = 0; i < this.conveyorSize; ++i) {
                for (int j = 0; j < this.conveyorSize; ++j) {
                    TileGeometry tile = this.tiles[i][j];
                    if (tile == null) continue;
                    tile.setMaskCenter(columnPos, (Vec3i)this.maskCenter.get());
                }
            }
        }
        for (TileGeometry tg : (TileGeometry[])this.fadingTiles.getArray()) {
            tg.update(tpf);
        }
    }

    protected void updateTiles(Vec3d pos) {
        int y;
        int x;
        Vec3i newCenter = TileId.GRID.worldToCell(pos);
        Vec3i columnPos = ColumnId.fromWorld(pos).getWorld(null);
        if (newCenter.equals((Object)this.center)) {
            return;
        }
        this.center.set(newCenter);
        this.centerWorld = TileId.GRID.cellToWorld(this.center);
        System.out.println("Need to refresh tree tiles.... tile Center:" + this.center + "  world center:" + this.centerWorld);
        int radius = this.treeRadius;
        HashMap<Long, TileGeometry> tileMap = new HashMap<Long, TileGeometry>();
        for (x = -radius; x <= radius; ++x) {
            for (y = -radius; y <= radius; ++y) {
                TileGeometry tile = this.tiles[x + radius][y + radius];
                if (tile == null) continue;
                tileMap.put(tile.id, tile);
            }
        }
        for (x = -radius; x <= radius; ++x) {
            for (y = -radius; y <= radius; ++y) {
                int xTile = this.centerWorld.x + x * 1024;
                int zTile = this.centerWorld.z + y * 1024;
                long id = this.calculateTileId(xTile, this.centerWorld.y, zTile);
                TileGeometry tile = (TileGeometry)tileMap.remove(id);
                if (tile == null) {
                    tile = new TileGeometry(id, xTile, this.centerWorld.y, zTile);
                    tile.setMaskCenter(columnPos, (Vec3i)this.maskCenter.get());
                    int priority = this.basePriority + x * x + y * y;
                    this.workers.execute((Job)tile, priority);
                }
                tile.setPosition(x * 1024, 0.0f, y * 1024);
                this.tiles[x + radius][y + radius] = tile;
            }
        }
        for (TileGeometry tile : tileMap.values()) {
            tile.release();
        }
    }

    protected Geometry createGeometry(TreeLayer layer) {
        List<Tree> trees = layer.getTrees();
        String atlasName = null;
        for (Tree tree : trees) {
            String name = tree.type.getAtlasCell(tree).getAtlasName();
            if (atlasName == null) {
                atlasName = name;
                continue;
            }
            if (atlasName.equals(name)) continue;
            throw new UnsupportedOperationException("Multiple atlases not yet supported.");
        }
        ColliderlessMesh mesh = new ColliderlessMesh();
        mesh.setMode(Mesh.Mode.Triangles);
        int verts = trees.size() * 4;
        int triangles = trees.size() * 2;
        float[] fv = new float[verts * 3];
        float[] ft = new float[verts * 2];
        float[] sizeb = new float[verts];
        int[] ib = new int[triangles * 3 * 2];
        int fp = 0;
        int ti = 0;
        int si = 0;
        int index = 0;
        int baseIndex = 0;
        for (Tree tree : trees) {
            float radius = tree.radius + 1;
            float height = tree.height;
            float x = (float)((double)tree.x + 0.5);
            float y = tree.y;
            float z = (float)((double)tree.z + 0.5);
            int cell = tree.type.getAtlasCell(tree).getIndex();
            fv[fp++] = x;
            fv[fp++] = y;
            fv[fp++] = z;
            ft[ti++] = -radius;
            ft[ti++] = 0.0f;
            sizeb[si++] = (byte)cell;
            fv[fp++] = x;
            fv[fp++] = y;
            fv[fp++] = z;
            ft[ti++] = radius;
            ft[ti++] = 0.0f;
            sizeb[si++] = (byte)cell;
            fv[fp++] = x;
            fv[fp++] = y;
            fv[fp++] = z;
            ft[ti++] = radius;
            ft[ti++] = height;
            sizeb[si++] = (byte)cell;
            fv[fp++] = x;
            fv[fp++] = y;
            fv[fp++] = z;
            ft[ti++] = -radius;
            ft[ti++] = height;
            sizeb[si++] = (byte)cell;
            ib[index++] = baseIndex + 0;
            ib[index++] = baseIndex + 1;
            ib[index++] = baseIndex + 2;
            ib[index++] = baseIndex + 0;
            ib[index++] = baseIndex + 2;
            ib[index++] = baseIndex + 3;
            baseIndex += 4;
        }
        mesh.setBuffer(VertexBuffer.Type.Position, 3, fv);
        mesh.setBuffer(VertexBuffer.Type.Index, 3, ib);
        mesh.setBuffer(VertexBuffer.Type.TexCoord, 2, ft);
        mesh.setBuffer(VertexBuffer.Type.Size, 1, sizeb);
        mesh.updateBound();
        mesh.setStatic();
        Vec3i worldPos = layer.getTileId().getWorld(null);
        Geometry geom = new Geometry(worldPos.x + "x" + worldPos.y, (Mesh)mesh);
        geom.setUserData("atlasName", (Object)atlasName);
        Material mat = this.materialFactory.apply((String)geom.getUserData("atlasName"));
        if (this.fogSettings != null) {
            this.fogSettings.apply(mat);
        }
        geom.setMaterial(mat);
        geom.setQueueBucket(RenderQueue.Bucket.Transparent);
        TerrainState.updateFogDistance((Spatial)geom, this.getFogDistance(), this.clipDistance);
        return geom;
    }

    protected long calculateTileId(int xCorner, int yCorner, int zCorner) {
        Vec3i cell = TileId.GRID.worldToCell((double)xCorner, (double)yCorner, (double)zCorner);
        return TileId.GRID.cellToId(cell.x, cell.y, cell.z);
    }

    private class TileGeometry
    implements Job {
        long id;
        int xCorner;
        int yCorner;
        int zCorner;
        TreeLayer treeLayer;
        Geometry geom;
        Vector3f position = new Vector3f();
        volatile Geometry viewGeom;
        Vector3f maskOffset = new Vector3f();
        volatile boolean visible;
        boolean firstTime = true;
        float alpha;

        public TileGeometry(long id, int xCorner, int yCorner, int zCorner) {
            this.id = id;
            this.xCorner = xCorner;
            this.yCorner = yCorner;
            this.zCorner = zCorner;
            this.visible = true;
        }

        public void updateMaterial(Function<String, Material> materialFactory) {
            if (this.viewGeom != null) {
                Material material = materialFactory.apply((String)this.viewGeom.getUserData("atlasName"));
                if (TreeState.this.fogSettings != null) {
                    TreeState.this.fogSettings.apply(material);
                }
                this.viewGeom.setMaterial(material);
            }
        }

        public void updateViewMask() {
            Material material = this.viewGeom.getMaterial();
            if (log.isTraceEnabled()) {
                log.trace(this.id + ".updateViewMask() viewMask:" + TreeState.this.viewMask + "  material:" + material);
            }
            if (TreeState.this.viewMask != null && material != null) {
                material.setTexture("MaskArray", TreeState.this.viewMask.getMaskTextures());
                material.setVector3("MaskOffset", this.maskOffset);
                material.setFloat("ViewMaskRadiusXZ", (float)((TreeState)TreeState.this).viewMask.getViewRadius().x);
                material.setFloat("ViewMaskRadiusY", (float)((TreeState)TreeState.this).viewMask.getViewRadius().y);
            }
        }

        public void setMaskCenter(Vec3i colPos, Vec3i viewCenter) {
            if (log.isTraceEnabled()) {
                log.trace(this.id + ".setMaskCenter(" + TreeState.this.center + ") world:" + this.xCorner + ", " + this.zCorner);
            }
            this.maskOffset.x = viewCenter.x - this.xCorner;
            this.maskOffset.y = viewCenter.y;
            this.maskOffset.z = viewCenter.z - this.zCorner;
        }

        public void update(float tpf) {
            this.alpha += tpf;
            if (this.alpha >= 1.0f) {
                TreeState.this.fadingTiles.remove((Object)this);
                this.alpha = 1.0f;
            }
            this.geom.getMaterial().setFloat("Alpha", this.alpha);
        }

        public void setPosition(float x, float y, float z) {
            this.position.set(x, y, z);
            if (this.geom != null) {
                this.geom.setLocalTranslation(x, y, z);
            }
        }

        public void release() {
            this.visible = false;
            if (this.geom != null) {
                this.geom.removeFromParent();
            }
        }

        public void runOnWorker() {
            if (!this.visible) {
                return;
            }
            this.treeLayer = TreeState.this.world.getTrees(TileId.fromWorld(this.xCorner, this.yCorner, this.zCorner), Resolution.High);
            this.geom = TreeState.this.createGeometry(this.treeLayer);
        }

        public double runOnUpdate() {
            if (this.visible) {
                this.viewGeom = this.geom;
                this.updateViewMask();
                TreeState.this.treeRoot.attachChild((Spatial)this.geom);
                this.geom.setLocalTranslation(this.position);
                if (this.firstTime) {
                    this.firstTime = false;
                    this.alpha = 0.0f;
                    TreeState.this.fadingTiles.add((Object)this);
                } else {
                    this.alpha = 1.0f;
                }
                this.geom.getMaterial().setFloat("Alpha", this.alpha);
                return 1.0;
            }
            return 0.0;
        }

        public String toString() {
            return "Trees[" + this.xCorner + ", " + this.zCorner + "]";
        }
    }
}

