/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityId;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectFocus
implements EntityComponent {
    static Logger log = LoggerFactory.getLogger(ObjectFocus.class);
    public static final byte TYPE_ENTITY = 0;
    public static final byte TYPE_BLOCK = 1;
    private byte type;
    private long id;

    private ObjectFocus() {
    }

    public ObjectFocus(byte type, long id) {
        this.type = type;
        this.id = id;
    }

    public static ObjectFocus entity(EntityId target) {
        return new ObjectFocus(0, target.getId());
    }

    public static ObjectFocus blockType(int blockType) {
        return new ObjectFocus(1, blockType);
    }

    public int getType() {
        return this.type;
    }

    public long getId() {
        return this.id;
    }

    public boolean isEntity() {
        return 0 == this.type;
    }

    public boolean isBlockType() {
        return 1 == this.type;
    }

    public EntityId getEntityId() {
        return this.isEntity() ? new EntityId(this.id) : null;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ObjectFocus other = (ObjectFocus)o;
        if (other.type != this.type) {
            return false;
        }
        return other.id == this.id;
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                return this.getClass().getSimpleName() + "[" + new EntityId(this.id) + "]";
            }
            case 1: {
                return this.getClass().getSimpleName() + "[blockType:" + this.id + "]";
            }
        }
        return this.getClass().getSimpleName() + "[type:" + this.type + ", id:" + this.id + "]";
    }
}

