/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.simsilica.lemur.Action;
import com.simsilica.lemur.Button;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallMethodAction
extends Action {
    static Logger log = LoggerFactory.getLogger(CallMethodAction.class);
    private String methodName;
    private Object object;
    private Method method;

    public CallMethodAction() {
    }

    public CallMethodAction(String name, Object delegate, String methodName) {
        super(name);
        this.setMethod(delegate, methodName);
    }

    public CallMethodAction(Object delegate, String methodName) {
        this(CallMethodAction.methodToName(methodName), delegate, methodName);
    }

    protected static String methodToName(String m) {
        StringBuilder sb = new StringBuilder();
        sb.append(Character.toUpperCase(m.charAt(0)));
        boolean last = true;
        for (int i = 1; i < m.length(); ++i) {
            char c = m.charAt(i);
            boolean upper = Character.isUpperCase(c);
            if (upper && !last) {
                sb.append(' ');
            }
            sb.append(c);
            last = upper;
        }
        return sb.toString();
    }

    protected boolean isValidArgument(Class type) {
        return Button.class.isAssignableFrom(type) || Action.class.isAssignableFrom(type);
    }

    protected boolean isValidArgumentList(Class[] types) {
        if (log.isTraceEnabled()) {
            log.trace("isValidArgumentList(" + Arrays.asList(types) + ")");
        }
        for (Class c : types) {
            if (!this.isValidArgument(c)) {
                if (log.isTraceEnabled()) {
                    log.trace("isValidArgument(" + c + ") = false");
                }
                return false;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace("isValidArgument(" + c + ") = true");
        }
        return true;
    }

    protected Object toParm(Button source, Class type) {
        if (Button.class.isAssignableFrom(type)) {
            return source;
        }
        if (Action.class.isAssignableFrom(type)) {
            return this;
        }
        return null;
    }

    protected void findMethod() {
        if (this.object == null || this.methodName == null) {
            return;
        }
        Class<?> type = this.object.getClass();
        this.findMethod(type);
    }

    protected void findMethod(Class type) {
        log.trace("Finding method:" + this.methodName + " on:" + type);
        for (Method m : type.getDeclaredMethods()) {
            Class[] parms;
            log.trace("Checking method:" + m);
            if (!this.methodName.equals(m.getName()) || (parms = m.getParameterTypes()).length > 2 || !this.isValidArgumentList(parms)) continue;
            this.method = m;
            if (m.isAccessible()) break;
            m.setAccessible(true);
            break;
        }
        if (this.method == null && type != Object.class) {
            this.findMethod(type.getSuperclass());
        }
        log.trace("Found:" + this.method);
        if (this.method == null) {
            throw new RuntimeException("Method not found for:" + this.methodName + " on type:" + type);
        }
    }

    public void setMethod(Object object, String methodName) {
        if (Objects.equals(this.object, object) && Objects.equals(this.methodName, methodName)) {
            return;
        }
        this.object = object;
        this.methodName = methodName;
        this.findMethod();
        this.incrementVersion();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Object getDelegate() {
        return this.object;
    }

    @Override
    public void execute(Button source) {
        if (this.method == null) {
            throw new RuntimeException("No method specified.");
        }
        Class<?>[] parmTypes = this.method.getParameterTypes();
        Object[] args = new Object[parmTypes.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.toParm(source, parmTypes[i]);
        }
        try {
            this.method.invoke(this.object, args);
        }
        catch (IllegalArgumentException e) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("(" + parmTypes[i] + ")");
                sb.append(args[i]);
            }
            throw new RuntimeException("Error calling:" + this.method + " with parameters [" + sb + "]", e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Error invoking action method:" + this.methodName, e);
        }
    }

    @Override
    protected void appendFields(StringBuilder sb) {
        super.appendFields(sb);
        sb.append(", methodName=").append(this.methodName);
        sb.append(", object=").append(this.object);
    }
}

