/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.network.ClientStateListener;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityId;
import com.simsilica.es.Name;
import com.simsilica.event.EventBus;
import com.simsilica.event.EventType;
import com.simsilica.fsm.StateMachine;
import com.simsilica.fsm.TransitionEvent;
import com.simsilica.fsm.TransitionListener;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.sim.SimEvent;
import com.simsilica.state.CompositeAppState;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mythruna.client.ConfigurationState;
import mythruna.client.GameInfo;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.MainMenuState;
import mythruna.client.ProgressState;
import mythruna.client.net.ConnectionState;
import mythruna.client.net.CreateAccountState;
import mythruna.client.net.HostManagementState;
import mythruna.client.net.HostedGameState;
import mythruna.client.net.LobbyState;
import mythruna.client.net.LoginState;
import mythruna.client.net.TimeState;
import mythruna.net.AccountListener;
import mythruna.net.AccountSession;
import mythruna.net.client.AccountClientService;
import mythruna.world.WorldInfo;
import mythruna.world.WorldManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkState
extends CompositeAppState {
    public static final String STATE_CONNECTING = "Connecting";
    public static final String STATE_CONNECTED = "Connected";
    public static final String STATE_LOGGING_IN = "Logging In";
    public static final String STATE_LOGGED_IN = "Logged In";
    public static final String STATE_AUTHENTICATING = "Authenticating";
    public static final String STATE_CREATE_ACCOUNT = "Create Account";
    public static final String STATE_WAIT_FOR_ACCOUNT = "Wait for Account";
    public static final String STATE_ENTERING_WORLD = "Entering World";
    public static final String STATE_PLAYING = "Playing";
    public static final String T_DISCONNECT = "disconnect";
    public static final String T_SUCCESS = "success";
    public static final String T_FAILURE = "failure";
    public static final String T_BACK = "back";
    public static final String T_EXIT = "exit";
    public static final String T_LOGIN = "login";
    public static final String T_PLAY = "play";
    public static final String T_CHALLENGE = "challenge";
    public static final String T_CREATE = "create";
    private float nextTime = 5.0f;
    private int testIndex = 0;
    private String[][] testTriggers = new String[][]{{"success", null}, {"challenge", null}, {"create", null}, {"create", "MyUser"}, {"success", null}, {"play", "MyUser"}};
    static Logger log = LoggerFactory.getLogger(NetworkState.class);
    private ConfigurationState config;
    private StateMachine<String, String> fsm = this.configureRemotePlayerFsm();
    private static final Pattern ABORT_PATTERN = Pattern.compile("Caused by: com.simsilica.event.EventAbortedException:\\s*(.*)");
    private static final Pattern RPC_PATTERN = Pattern.compile("Error calling remote procedure:.*\\s.*?:\\s*(.*)");

    public NetworkState() {
        super(new AppState[0]);
    }

    protected String getHost() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            return address.getHostName();
        }
        catch (IOException e) {
            log.error("Error retriving local host information", (Throwable)e);
            return "unknown";
        }
    }

    protected void safeSleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("blah", e);
        }
    }

    public void trigger(String trigger) {
        this.fsm.trigger((Object)trigger);
    }

    public void startSinglePlayer(WorldManager world, GameInfo lastGame) {
        log.info("startSinglePlayer(" + world + ", " + lastGame + ")");
        try {
            this.start(world, lastGame);
        }
        catch (RuntimeException e) {
            log.error("Error starting single player game", (Throwable)e);
            this.stopHosting();
            this.stop();
            throw e;
        }
    }

    public void startHosting(WorldManager world, int port, String description) {
        EventBus.addListener((Object)((Object)this), (EventType[])new EventType[]{SimEvent.simFailed});
        this.getStateManager().attach((AppState)new HostedGameState(world, port, description, false, null));
        this.getStateManager().attach((AppState)new HostManagementState());
    }

    public void stopHosting() {
        HostManagementState admin;
        EventBus.removeListener((Object)((Object)this), (EventType[])new EventType[]{SimEvent.simFailed});
        HostedGameState host = (HostedGameState)this.getState(HostedGameState.class);
        if (host != null) {
            this.getStateManager().detach((AppState)host);
        }
        if ((admin = (HostManagementState)this.getState(HostManagementState.class)) != null) {
            this.getStateManager().detach((AppState)admin);
        }
    }

    public void connect(String ip, int port, final Consumer<Boolean> loginStatus) {
        this.addChild((AppState)new LoginState(this.fsm));
        this.addChild((AppState)new CreateAccountState(this.fsm));
        this.addChild((AppState)new LobbyState(false, this.fsm));
        this.addChild((AppState)new TimeState());
        ConnectionState connection = (ConnectionState)this.addChild((AppState)new ConnectionState(this.fsm, ip, port, null));
        final AccountClientService account = connection.getService(AccountClientService.class);
        account.addAccountListener(new AccountListener(){

            public void challenge(String randomSalt, List<String> caps) {
                log.info("challenge(" + randomSalt + ", " + caps + ")");
                NetworkState.this.getApplication().enqueue(() -> {
                    ((LoginState)NetworkState.this.getState(LoginState.class)).challenge(randomSalt, caps);
                    NetworkState.this.fsm.trigger((Object)NetworkState.T_CHALLENGE, (Object)caps);
                });
            }

            public void loginStatus(boolean loggedIn, String message) {
                log.info("loginStatus(" + loggedIn + ", " + message + ")");
                NetworkState.this.getApplication().enqueue(() -> {
                    loginStatus.accept(loggedIn);
                    if (loggedIn) {
                        ((LobbyState)NetworkState.this.getState(LobbyState.class)).setPlayer(account.getUserEntity());
                        NetworkState.this.fsm.trigger((Object)NetworkState.T_SUCCESS, (Object)message);
                    } else {
                        NetworkState.this.fsm.trigger((Object)NetworkState.T_FAILURE, (Object)message);
                    }
                });
            }

            public void accountStatus(boolean success, String message) {
                log.info("accountStatus(" + success + ", " + message + ")");
                NetworkState.this.getApplication().enqueue(() -> {
                    if (success) {
                        NetworkState.this.fsm.trigger((Object)NetworkState.T_SUCCESS, (Object)message);
                    } else {
                        NetworkState.this.fsm.trigger((Object)NetworkState.T_FAILURE, (Object)message);
                    }
                });
            }
        });
        this.fsm.start((Object)ip);
    }

    protected void start(WorldManager world, GameInfo lastGame) {
        EventBus.addListener((Object)((Object)this), (EventType[])new EventType[]{SimEvent.simFailed});
        String user = System.getProperty("user.name");
        String host = this.getHost();
        final String userId = user + "@" + host;
        EntityId player = world.findNamedEntity(userId);
        if (player == null) {
            log.info("World does not have a local player yet, creating one for:" + userId);
            player = world.getEntityData().createEntity();
            world.getEntityData().setComponents(player, new EntityComponent[]{new Name(userId)});
        } else {
            log.info("Using existing player:" + userId + "  entityId:" + player);
        }
        if (!(lastGame == null || Objects.equals(userId, lastGame.userId) && Objects.equals(player, lastGame.userEntity))) {
            log.warn("Last game's user does not match current user, user:" + userId + ", " + player + "  last user:" + lastGame.userId + ", " + lastGame.userEntity);
        }
        final Supplier tokenSupplier = Suppliers.ofInstance((Object)"for now");
        int port = 8969;
        this.getStateManager().attach((AppState)new HostedGameState(world, port, "single player", true, (Supplier<String>)tokenSupplier));
        this.addChild((AppState)new LobbyState(true, this.fsm));
        this.addChild((AppState)new TimeState());
        ConnectionState connection = (ConnectionState)this.addChild((AppState)new ConnectionState(this.fsm, "127.0.0.1", port, (Supplier<String>)tokenSupplier));
        final AccountClientService account = connection.getService(AccountClientService.class);
        account.addAccountListener(new AccountListener(){

            public void challenge(String randomSalt, List<String> caps) {
                log.info("challenge(" + randomSalt + ", " + caps + ")");
                NetworkState.this.getApplication().enqueue(() -> {
                    NetworkState.this.fsm.trigger((Object)NetworkState.T_LOGIN, (Object)userId);
                    HashMap<String, Object> creds = new HashMap<String, Object>();
                    creds.put("token", tokenSupplier.get());
                    account.login(userId, creds);
                });
            }

            public void loginStatus(boolean loggedIn, String message) {
                log.info("loginStatus(" + loggedIn + ", " + message + ")");
                NetworkState.this.getApplication().enqueue(() -> {
                    if (loggedIn) {
                        ((LobbyState)NetworkState.this.getState(LobbyState.class)).setPlayer(account.getUserEntity());
                        NetworkState.this.fsm.trigger((Object)NetworkState.T_SUCCESS, (Object)message);
                    } else {
                        NetworkState.this.fsm.trigger((Object)NetworkState.T_FAILURE, (Object)message);
                    }
                });
            }

            public void accountStatus(boolean success, String message) {
                log.info("accountStatus(" + success + ", " + message + ")");
                throw new UnsupportedOperationException("Account operations not supported in single player");
            }
        });
        this.fsm.start((Object)"localhost");
    }

    protected void stop() {
        log.info("stop()");
        ConnectionState connection = (ConnectionState)this.getChild(ConnectionState.class);
        if (connection != null) {
            connection.close();
            this.removeChild((AppState)connection);
        }
        HostedGameState hostedGame = (HostedGameState)this.getState(HostedGameState.class);
        log.info("hosted game:" + (Object)((Object)hostedGame));
        if (hostedGame != null) {
            if (hostedGame.isSinglePlayer()) {
                this.stopHosting();
                ((MainMenuState)this.getState(MainMenuState.class)).setEnabled(true);
            } else {
                ((HostManagementState)this.getState(HostManagementState.class)).setConnected(false);
                ((HostManagementState)this.getState(HostManagementState.class)).setEnabled(true);
            }
        } else {
            GameSessionState gst = (GameSessionState)this.getState(GameSessionState.class);
            if (gst != null) {
                gst.setEnabled(false);
                this.getApplication().getStateManager().detach((AppState)gst);
            }
            ((MainMenuState)this.getState(MainMenuState.class)).setEnabled(true);
        }
        this.clearChildren();
    }

    protected void saveGameInfo() {
        HostedGameState host = (HostedGameState)this.getState(HostedGameState.class);
        if (host == null || !host.isSinglePlayer()) {
            return;
        }
        WorldManager world = host.getWorldManager();
        WorldInfo info = world.getInfo();
        AccountSession account = ((ConnectionState)this.getState(ConnectionState.class, true)).getService(AccountSession.class);
        EntityId user = account.getUserEntity();
        String userId = world.getName(user);
        GameInfo game = new GameInfo(info.getDirectory(), userId, user, null);
        log.info("gameInfo:");
        log.info("  world:" + info);
        log.info("  userId:" + userId + "  user entity:" + user);
        this.config.set("lastGame", game);
    }

    protected StateMachine<String, String> configureRemotePlayerFsm() {
        StateMachine fsm = new StateMachine();
        fsm.addDefaultTermination((Object)T_DISCONNECT);
        fsm.addDefaultTermination((Object)T_EXIT);
        fsm.setStart((Object)STATE_CONNECTING).addTransition((Object)T_SUCCESS, (Object)STATE_CONNECTED);
        fsm.getState((Object)STATE_CONNECTED).addTransition((Object)T_CHALLENGE, (Object)STATE_LOGGING_IN).addTransition((Object)T_LOGIN, (Object)STATE_AUTHENTICATING);
        fsm.getState((Object)STATE_LOGGING_IN).addTermination((Object)T_BACK).addTransition((Object)T_LOGIN, (Object)STATE_AUTHENTICATING).addTransition((Object)T_CREATE, (Object)STATE_CREATE_ACCOUNT);
        fsm.getState((Object)STATE_AUTHENTICATING).addTermination((Object)T_BACK).addTransition((Object)T_FAILURE, (Object)STATE_LOGGING_IN).addTransition((Object)T_SUCCESS, (Object)STATE_LOGGED_IN);
        fsm.getState((Object)STATE_CREATE_ACCOUNT).addTransition((Object)T_BACK, (Object)STATE_LOGGING_IN).addTransition((Object)T_CREATE, (Object)STATE_WAIT_FOR_ACCOUNT);
        fsm.getState((Object)STATE_WAIT_FOR_ACCOUNT).addTransition((Object)T_BACK, (Object)STATE_LOGGING_IN).addTransition((Object)T_FAILURE, (Object)STATE_CREATE_ACCOUNT).addTransition((Object)T_SUCCESS, (Object)STATE_LOGGING_IN);
        fsm.getState((Object)STATE_LOGGED_IN).addTransition((Object)T_PLAY, (Object)STATE_ENTERING_WORLD);
        fsm.getState((Object)STATE_ENTERING_WORLD).addTransition((Object)T_BACK, (Object)STATE_LOGGED_IN).addTransition((Object)T_FAILURE, (Object)STATE_LOGGED_IN).addTransition((Object)T_SUCCESS, (Object)STATE_PLAYING);
        fsm.getState((Object)STATE_PLAYING).addTransition((Object)T_BACK, (Object)STATE_LOGGED_IN);
        return fsm;
    }

    protected void initialize(Application app) {
        this.config = (ConfigurationState)this.getState(ConfigurationState.class, true);
        this.fsm.addTransitionListener(null, null, (Object)T_FAILURE, String.class, e -> this.getApplication().enqueue(() -> ((GuiState)this.getState(GuiState.class)).showError(String.valueOf(e.getFrom()), String.valueOf(e.getPayload()))));
        this.fsm.addTransitionListener(null, null, (Object)T_FAILURE, Throwable.class, e -> this.getApplication().enqueue(() -> {
            String msg = NetworkState.cleanupThrowableMessage(((Throwable)e.getPayload(Throwable.class)).getMessage());
            if (msg == null) {
                msg = String.valueOf(e.getPayload());
            }
            ((GuiState)this.getState(GuiState.class)).showError(String.valueOf(e.getFrom()), msg);
        }));
        this.fsm.addTransitionListener(null, null, (Object)T_DISCONNECT, String.class, e -> this.getApplication().enqueue(() -> ((GuiState)this.getState(GuiState.class)).showError("Disconnected", String.valueOf(e.getPayload()))));
        this.fsm.addTransitionListener(null, null, (Object)T_DISCONNECT, Throwable.class, e -> this.getApplication().enqueue(() -> {
            String msg = NetworkState.cleanupThrowableMessage(((Throwable)e.getPayload(Throwable.class)).getMessage());
            if (msg == null) {
                msg = String.valueOf(e.getPayload());
            }
            ((GuiState)this.getState(GuiState.class)).showError("Disconnected", msg);
        }));
        this.fsm.addTransitionListener(null, null, (Object)T_DISCONNECT, ClientStateListener.DisconnectInfo.class, e -> {
            log.info("Disconnect:" + e.getPayload());
            this.getApplication().enqueue(() -> {
                String msg = ((ClientStateListener.DisconnectInfo)e.getPayload(ClientStateListener.DisconnectInfo.class)).reason;
                if (msg == null) {
                    msg = String.valueOf(e.getPayload());
                }
                ((GuiState)this.getState(GuiState.class)).showError("Disconnected", msg);
            });
        });
        this.fsm.setStart((Object)STATE_CONNECTING).onEnter((TransitionListener)new UpdateProgress("Connecting:")).onExit((TransitionListener)new UpdateProgress(null));
        this.fsm.getState((Object)STATE_CONNECTED).onEnter((TransitionListener)new UpdateProgress("Waiting for server...")).onExit((TransitionListener)new UpdateProgress(null));
        this.fsm.getState((Object)STATE_AUTHENTICATING).onEnter((TransitionListener)new UpdateProgress("Authenticating:")).onExit((TransitionListener)new UpdateProgress(null));
        this.fsm.getState((Object)STATE_WAIT_FOR_ACCOUNT).onEnter((TransitionListener)new UpdateProgress("Creating account:")).onExit((TransitionListener)new UpdateProgress(null));
        this.fsm.getState((Object)STATE_ENTERING_WORLD).onEnter(this::saveGameInfo);
        this.fsm.getState((Object)STATE_LOGGING_IN).onEnter(() -> ((LoginState)this.getState(LoginState.class)).setEnabled(true)).onExit(() -> ((LoginState)this.getState(LoginState.class)).setEnabled(false));
        this.fsm.getState((Object)STATE_CREATE_ACCOUNT).onEnter(() -> ((CreateAccountState)this.getState(CreateAccountState.class)).setEnabled(true)).onExit(() -> ((CreateAccountState)this.getState(CreateAccountState.class)).setEnabled(false));
        this.fsm.getState((Object)STATE_LOGGED_IN).onEnter(() -> ((LobbyState)this.getState(LobbyState.class)).setEnabled(true)).onExit(() -> ((LobbyState)this.getState(LobbyState.class)).setEnabled(false));
        this.fsm.onStop(this::stop);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
    }

    public void update(float tpf) {
    }

    protected void onDisable() {
    }

    protected void simFailed(SimEvent event) {
        log.info("simulation failed to start");
        this.getApplication().enqueue(() -> {});
    }

    private static String cleanupThrowableMessage(String message) {
        if (message == null) {
            return message;
        }
        Matcher m = ABORT_PATTERN.matcher(message);
        if (m.find()) {
            log.info("group1:" + m.group(1));
            return m.group(1);
        }
        m = RPC_PATTERN.matcher(message);
        if (m.find()) {
            log.info("group1:" + m.group(1));
            return m.group(1);
        }
        return message;
    }

    protected class UpdateProgress
    implements TransitionListener<String> {
        private String text;
        private RangedValueModel progressValue;

        public UpdateProgress(String text) {
            this(text, null);
        }

        public UpdateProgress(String text, RangedValueModel progressValue) {
            this.text = text;
            this.progressValue = progressValue;
        }

        public void transition(TransitionEvent<String> t) {
            Object payload;
            log.info("Update progress:" + t);
            ProgressState.ProgressTracker tracker = ((ProgressState)NetworkState.this.getState(ProgressState.class)).getTracker("network", true);
            if (this.text == null) {
                tracker.setText(null);
                return;
            }
            if (this.progressValue != null) {
                tracker.setValue(this.progressValue);
            }
            if ((payload = t.getPayload()) != null) {
                tracker.setText(this.text + t.getPayload());
            } else {
                tracker.setText(this.text);
            }
        }
    }
}

