/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.cave;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Vec3i;
import java.io.Serializable;
import java.util.Objects;
import mythruna.world.cave.CaveEdge;
import mythruna.world.cave.PointInfluencer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaveNode
implements Serializable {
    static Logger log = LoggerFactory.getLogger(CaveNode.class);
    private static final long serialVersionUID = 42L;
    private long caveSystemId;
    private Vec3i point;
    private double radius;
    private int depth;
    private PointInfluencer influencer;

    public CaveNode(long caveSystemId, Vec3i point, double radius, int depth) {
        this.caveSystemId = caveSystemId;
        this.point = point;
        this.radius = radius;
        this.depth = depth;
    }

    public long getCaveSystemId() {
        return this.caveSystemId;
    }

    public Vec3i getPoint() {
        return this.point;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double getRadius() {
        return this.radius;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setInfluencer(PointInfluencer influencer) {
        this.influencer = influencer;
    }

    public PointInfluencer getInfluencer() {
        return this.influencer;
    }

    public CaveEdge extend(Vec3i end, double radius) {
        CaveNode other = new CaveNode(this.caveSystemId, end, radius, this.depth + 1);
        CaveEdge edge = new CaveEdge(this, other, radius);
        return edge;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        CaveNode other = (CaveNode)o;
        if (other.caveSystemId != this.caveSystemId) {
            return false;
        }
        if (other.radius != this.radius) {
            return false;
        }
        if (other.depth != this.depth) {
            return false;
        }
        return Objects.equals(other.point, this.point);
    }

    public int hashCode() {
        return Objects.hash(this.point, this.caveSystemId, this.radius, this.depth);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("caveSystemId", this.caveSystemId).add("point", (Object)this.point).add("radius", this.radius).add("depth", this.depth).add("influencer", (Object)this.influencer).toString();
    }
}

