/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.state;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.util.SafeArrayList;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.style.ElementId;
import java.util.concurrent.ConcurrentLinkedQueue;

public class MessageState
extends BaseAppState {
    public static final ElementId MESSAGE_LABEL_ID = new ElementId("console.message.label");
    private Node messageRoot;
    private Vector3f offset = new Vector3f();
    private ConcurrentLinkedQueue<Message> pendingMessages = new ConcurrentLinkedQueue();
    private SafeArrayList<Message> messages = new SafeArrayList(Message.class);
    private float fadeRate = 0.06666667f;
    private float alphaOverride = 0.0f;
    float nextTime = 1.0f;

    public void setFadeTime(float seconds) {
        if (seconds == 0.0f) {
            this.fadeRate = 0.0f;
        }
        this.fadeRate = 1.0f / seconds;
    }

    public float getFadeTime() {
        return this.fadeRate == 0.0f ? 0.0f : 1.0f / this.fadeRate;
    }

    public void setAlphaOverride(float alphaOverride) {
        this.alphaOverride = alphaOverride;
    }

    public float getAlphaOverride() {
        return this.alphaOverride;
    }

    public Label addMessage(String message) {
        return this.addMessage(new Label(message, MESSAGE_LABEL_ID));
    }

    public Label addMessage(String message, ColorRGBA color) {
        Label result = new Label(message, MESSAGE_LABEL_ID);
        result.setColor(color);
        this.addMessage(result);
        return result;
    }

    public <T extends Panel> T addMessage(T label) {
        Message msg = new Message(label);
        this.pendingMessages.add(msg);
        return label;
    }

    protected void displayMessage(Message msg) {
        this.messages.add(0, (Object)msg);
        this.messageRoot.attachChild((Spatial)msg.label);
        this.refreshLayout();
    }

    public void setMessageRootOffset(Vector3f offset) {
        this.offset.set(offset);
        this.resetMessageRootLocation();
    }

    public Vector3f getMessageRootOffset() {
        return this.offset;
    }

    protected void initialize(Application app) {
        this.messageRoot = new Node("MessageRoot");
    }

    protected void cleanup(Application app) {
    }

    protected void addTestMessages(float tpf) {
        this.nextTime -= tpf;
        if (this.nextTime < 0.0f) {
            this.nextTime = (float)(Math.random() * 1.9) + 0.1f;
            int count = (int)(Math.random() * 4.0) + 1;
            for (int i = 0; i < count; ++i) {
                if (i % 2 == 0) {
                    this.addMessage("> Tick " + System.currentTimeMillis());
                    continue;
                }
                this.addMessage("> Tock " + System.currentTimeMillis());
            }
        }
    }

    public void update(float tpf) {
        Message msg = null;
        while ((msg = this.pendingMessages.poll()) != null) {
            this.displayMessage(msg);
        }
        for (Message m : (Message[])this.messages.getArray()) {
            m.update(tpf);
        }
    }

    protected void onEnable() {
        Node gui = ((SimpleApplication)this.getApplication()).getGuiNode();
        gui.attachChild((Spatial)this.messageRoot);
        this.resetMessageRootLocation();
    }

    protected void onDisable() {
        this.messageRoot.removeFromParent();
    }

    protected void resetMessageRootLocation() {
        this.messageRoot.setLocalTranslation(5.0f, 5.0f, 0.0f);
        this.messageRoot.move(this.offset);
    }

    protected void refreshLayout() {
        int height = this.getApplication().getCamera().getHeight();
        int width = this.getApplication().getCamera().getWidth();
        float y = 0.0f;
        for (Message m : (Message[])this.messages.getArray()) {
            Vector3f pref = m.label.getPreferredSize();
            m.label.setLocalTranslation(0.0f, y += pref.y, 0.0f);
            if (!(y > (float)height)) continue;
            m.label.removeFromParent();
            this.messages.remove((Object)m);
        }
    }

    private class Message {
        private float alpha;
        private Panel label;

        public Message(Panel label) {
            this(label, 1.0f);
        }

        public Message(Panel label, float initialAlpha) {
            this.alpha = initialAlpha;
            this.label = label;
        }

        public void update(float tpf) {
            this.alpha -= tpf * MessageState.this.fadeRate;
            if (this.alpha < 0.0f) {
                this.alpha = 0.0f;
            }
            this.label.setAlpha(Math.max(this.alpha, MessageState.this.alphaOverride));
        }
    }
}

