/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture.image;

import com.jme3.texture.image.ImageCodec;
import java.nio.ByteBuffer;

public class ByteOffsetImageCodec
extends ImageCodec {
    private final int redPos;
    private final int greenPos;
    private final int bluePos;
    private final int alphaPos;

    public ByteOffsetImageCodec(int bpp, int flags, int alphaPos, int redPos, int greenPos, int bluePos) {
        super(bpp, flags, alphaPos != -1 ? 255 : 0, redPos != -1 ? 255 : 0, greenPos != -1 ? 255 : 0, bluePos != -1 ? 255 : 0);
        this.alphaPos = alphaPos;
        this.redPos = redPos;
        this.greenPos = greenPos;
        this.bluePos = bluePos;
    }

    @Override
    public void readComponents(ByteBuffer buf, int x, int y, int width, int offset, int[] components, byte[] tmp) {
        int i = (y * width + x) * this.bpp + offset;
        buf.position(i);
        buf.get(tmp, 0, this.bpp);
        if (this.alphaPos != -1) {
            components[0] = tmp[this.alphaPos] & 0xFF;
        }
        if (this.redPos != -1) {
            components[1] = tmp[this.redPos] & 0xFF;
        }
        if (this.greenPos != -1) {
            components[2] = tmp[this.greenPos] & 0xFF;
        }
        if (this.bluePos != -1) {
            components[3] = tmp[this.bluePos] & 0xFF;
        }
    }

    @Override
    public void writeComponents(ByteBuffer buf, int x, int y, int width, int offset, int[] components, byte[] tmp) {
        int i = (y * width + x) * this.bpp + offset;
        if (this.alphaPos != -1) {
            tmp[this.alphaPos] = (byte)components[0];
        }
        if (this.redPos != -1) {
            tmp[this.redPos] = (byte)components[1];
        }
        if (this.greenPos != -1) {
            tmp[this.greenPos] = (byte)components[2];
        }
        if (this.bluePos != -1) {
            tmp[this.bluePos] = (byte)components[3];
        }
        buf.position(i);
        buf.put(tmp, 0, this.bpp);
    }
}

