/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.crig.jme;

import com.jme3.anim.AnimComposer;
import com.jme3.anim.SkinningControl;
import com.jme3.anim.tween.action.BlendAction;
import com.jme3.anim.tween.action.BlendSpace;
import com.jme3.anim.tween.action.LinearBlendSpace;
import com.jme3.export.Savable;
import com.jme3.export.binary.BinaryExporter;
import com.jme3.export.binary.BinaryImporter;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.SceneGraphVisitorAdapter;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.simsilica.crig.AttachmentInfo;
import com.simsilica.crig.BlendInfo;
import com.simsilica.crig.ColliderInfo;
import com.simsilica.crig.RigShape;
import com.simsilica.crig.RigType;
import com.simsilica.crig.jme.AnimComposerRig;
import com.simsilica.crig.jme.AnimComposerShape;
import com.simsilica.crig.jme.AttachmentPointImpl;
import com.simsilica.crig.jme.ColliderShape;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.phys.CellArrayPart;
import com.simsilica.mblock.phys.Group;
import com.simsilica.mblock.phys.Part;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialRigType
implements RigType,
Serializable {
    static Logger log = LoggerFactory.getLogger(SpatialRigType.class);
    static final long serialVersionUID = 42L;
    private transient Spatial spatial;
    private List<ColliderInfo> colliders;
    private List<AttachmentInfo> attachments;
    private List<BlendInfo> blends;

    public SpatialRigType(Spatial spatial, List<ColliderInfo> colliders, List<AttachmentInfo> attachments, List<BlendInfo> blends) {
        this.spatial = spatial.clone();
        this.colliders = colliders;
        this.attachments = attachments;
        this.blends = blends;
        this.spatial.depthFirstTraversal((SceneGraphVisitor)new SceneGraphVisitorAdapter(){

            public void visit(Geometry geom) {
                log.info("Clearing mesh from:" + geom);
                geom.setMaterial(null);
                geom.setMesh((Mesh)new Quad(1.0f, 1.0f));
            }
        });
    }

    @Override
    public RigShape createShape(ShapeInfo info, Mass mass) {
        Spatial view = this.spatial.clone();
        AnimComposer anim = AnimComposerRig.findControl(view, AnimComposer.class);
        SkinningControl skin = AnimComposerRig.findControl(view, SkinningControl.class);
        anim.setGlobalSpeed(0.0f);
        double m = mass == null ? 0.0 : mass.getMass();
        Group root = new Group("rig");
        boolean first = true;
        ArrayList<ColliderShape> shapes = new ArrayList<ColliderShape>();
        for (ColliderInfo c : this.colliders) {
            log.info("c:" + c);
            if (skin.getArmature().getJoint(c.getJoint()) == null) {
                log.warn("No joint found for:" + c.getJoint());
                continue;
            }
            Node att = skin.getAttachmentsNode(c.getJoint());
            double partMass = 0.01;
            if (first) {
                partMass = m;
                first = false;
            }
            CellArrayPart part = c.getShape() == null ? CellArrayPart.createSphere((String)c.getName(), (double)c.getScale(), (double)partMass) : CellArrayPart.createShape((String)c.getName(), (CellArray)c.getShape(), (double)c.getScale(), (double)partMass);
            ColliderShape shape = new ColliderShape(c, (Spatial)att, (Part)part);
            shape.update();
            root.addChild((Part)part);
            shapes.add(shape);
        }
        ColliderShape[] array = shapes.toArray(new ColliderShape[0]);
        ArrayList<AttachmentPointImpl> points = new ArrayList<AttachmentPointImpl>();
        for (AttachmentInfo a : this.attachments) {
            log.info("a:" + a);
            if (skin.getArmature().getJoint(a.getJoint()) == null) {
                log.warn("No joint found for:" + a.getJoint());
                continue;
            }
            Node node = skin.getAttachmentsNode(a.getJoint());
            AttachmentPointImpl point = new AttachmentPointImpl(a, (Spatial)node);
            point.update();
            points.add(point);
        }
        AttachmentPointImpl[] pointArray = points.toArray(new AttachmentPointImpl[0]);
        AnimComposerRig delegate = new AnimComposerRig(anim);
        if (this.blends != null) {
            for (BlendInfo blend : this.blends) {
                log.info("blend:" + blend);
                BlendAction ba = anim.actionBlended(blend.getName(), (BlendSpace)new LinearBlendSpace(0.0f, 1.0f), blend.getBlendedActions());
                ba.getBlendSpace().setValue((float)blend.getDefaultBlend());
            }
        } else {
            log.warn("BlendInfo list is null, this might be an older serialized version");
        }
        return new AnimComposerShape(this, root, delegate, () -> {
            anim.update(0.1f);
            skin.update(0.1f);
        }, array, pointArray);
    }

    public void configureSpatial(Spatial view) {
        AnimComposer anim = AnimComposerRig.findControl(view, AnimComposer.class);
        anim.setGlobalSpeed(0.0f);
        if (this.blends != null) {
            for (BlendInfo blend : this.blends) {
                log.info("blend:" + blend);
                BlendAction ba = anim.actionBlended(blend.getName(), (BlendSpace)new LinearBlendSpace(0.0f, 1.0f), blend.getBlendedActions());
                ba.getBlendSpace().setValue((float)blend.getDefaultBlend());
            }
        } else {
            log.warn("BlendInfo list is null, this might be an older serialized version");
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        byte[] array = (byte[])stream.readObject();
        this.spatial = (Spatial)BinaryImporter.getInstance().load(array);
        log.info("read spatial array size:" + array.length);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BinaryExporter.getInstance().save((Savable)this.spatial, (OutputStream)bos);
        byte[] array = bos.toByteArray();
        stream.writeObject(array);
        log.info("wrote spatial array size:" + array.length);
    }
}

