/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.town;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.BlockData;
import com.simsilica.mworld.BlockDataId;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import com.simsilica.mworld.tile.insert.BlockInsert;
import com.simsilica.mworld.tile.insert.InsertLayer;
import com.simsilica.mworld.tile.tree.Tree;
import com.simsilica.mworld.tile.tree.TreeLayer;
import java.util.List;
import java.util.Random;
import mythruna.world.BioInfo;
import mythruna.world.WorldFractal;
import mythruna.world.tile.FeatureId;
import mythruna.world.tile.Sedectile;
import mythruna.world.tile.SedectileManager;
import mythruna.world.town.InsertInfo;
import mythruna.world.town.PointOfInterest;
import mythruna.world.town.TestBlockRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPoiTileFunction
implements TileFunction {
    static Logger log = LoggerFactory.getLogger(TestPoiTileFunction.class);
    private static int TYPE_SNOW = 0;
    private static int TYPE_MODERATE = 1;
    private static int TYPE_DESERT = 2;
    private static int MAX_TYPE = 3;
    private static String DEFAULT_BLOCKS = "spawn-tower.blocks";
    private static BuildingTypeIndex[] typeIndexes = new BuildingTypeIndex[MAX_TYPE];
    private SedectileManager sedectileManager;
    private WorldFractal fractal;
    private Vec3d spawnLoc;
    private TileId spawnTileId;
    private TestBlockRegistry blocksRegistry;

    public TestPoiTileFunction(SedectileManager sedectileManager, TestBlockRegistry blocksRegistry, Vec3d spawnLoc, WorldFractal fractal) {
        this.sedectileManager = sedectileManager;
        this.blocksRegistry = blocksRegistry;
        this.spawnLoc = spawnLoc;
        this.spawnTileId = TileId.fromWorld((double)spawnLoc.x, (double)spawnLoc.y, (double)spawnLoc.z);
        this.fractal = fractal;
    }

    public void accept(Tile tile) {
        TileId tileId = tile.getTileId();
        if (tile.getResolution() != Resolution.High) {
            this.sedectileManager.getSedectile(tileId.getSedectileId());
            return;
        }
        InsertLayer inserts = (InsertLayer)tile.get(InsertLayer.class);
        if (inserts.getVersion().getLoadVersion() >= 0L) {
            return;
        }
        TreeLayer trees = (TreeLayer)tile.get(TreeLayer.class);
        if (trees == null) {
            log.warn("Trees have not been generated yet?");
        }
        Vec3i origin = tileId.getWorld(null);
        TerrainImage terrain = (TerrainImage)tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        TerrainImage fluid = (TerrainImage)tile.get((Object)TerrainImageType.Fluid, TerrainImage.class);
        Sedectile sedectile = this.sedectileManager.getSedectile(tileId.getSedectileId());
        for (FeatureId<PointOfInterest> id : sedectile.getFeatureIds(tileId, PointOfInterest.class)) {
            PointOfInterest poi = this.sedectileManager.getFeatures().getFeature(id, PointOfInterest.class);
            if (1295L == id.getId()) {
                log.info("Kilroy-rendering " + poi + "  from tile:" + tileId.getWorld(null) + "  sedectile:" + sedectile.getSedectileId().getWorld(null));
            }
            Random rand = new Random(id.getId());
            if (trees != null) {
                Vec3i min = new Vec3i();
                Vec3i max = new Vec3i();
                Vec3i size = PointOfInterest.calculateRange(poi.getChildren(), min, max);
                min.subtractLocal(origin);
                max.subtractLocal(origin);
                List list = trees.getTrees();
                for (int i = 0; i < list.size(); ++i) {
                    Tree tree = (Tree)list.get(i);
                    if (tree.x < min.x || tree.z < min.z || tree.x > max.x || tree.z > max.z || !trees.removeTree(tree)) continue;
                    --i;
                }
            }
            BioInfo bio = new BioInfo();
            for (InsertInfo info : poi.getChildren()) {
                String type = info.getType();
                TestBlockRegistry.BuildingFactory factory = null;
                if ("spawn".equals(type)) {
                    factory = this.blocksRegistry.getSpawnTower();
                } else {
                    Vec3i loc = info.getLocation();
                    bio = this.fractal.getBioInfo(loc.x, loc.y, loc.z, bio);
                    int indexType = TYPE_MODERATE;
                    if (bio.vegetationLevel <= 0.1 && bio.temperature > 0.5) {
                        indexType = TYPE_DESERT;
                    } else if (bio.temperature <= 0.2857 && bio.precipitation > 0.167) {
                        indexType = TYPE_SNOW;
                    }
                    BuildingTypeIndex types = typeIndexes[indexType];
                    String factoryId = types.getRandom(type, rand);
                    factory = this.blocksRegistry.getFactory(factoryId);
                    if (factory == null) {
                        log.error("No factory defined for:" + factoryId + " from:" + type);
                        factory = this.blocksRegistry.getFactory(DEFAULT_BLOCKS);
                    }
                }
                BlockDataId blockDataId = info.getFacing() != -1 ? this.blocksRegistry.getRandomFixedFacing(factory.name, info.getFacing(), rand) : this.blocksRegistry.getRandomOrientation(factory.name, rand);
                int carveFlags = 2;
                BlockData data = this.blocksRegistry.apply(blockDataId);
                Vec3i loc = null;
                int xSize = data.getCells().getSizeX();
                int ySize = data.getCells().getSizeY();
                int zSize = data.getCells().getSizeZ();
                log.info("size:" + xSize + ", " + ySize + ", " + zSize);
                loc = "spawn".equals(type) ? info.getLocation() : info.getLocation();
                loc = loc.add(0, -factory.yOffset, 0);
                log.info("Create BlockInsert at:" + loc);
                inserts.addInsert(new BlockInsert(loc, blockDataId, carveFlags, xSize, ySize, zSize, factory.aboveGround, factory.groundLevel, -1L));
            }
        }
    }

    static {
        BuildingTypeIndex index = TestPoiTileFunction.typeIndexes[TestPoiTileFunction.TYPE_SNOW] = new BuildingTypeIndex();
        index.map("cliff1", "ruined-cobble-hut.blocks", "small-stone-ruin.blocks", "stone-cairn.blocks");
        index.map("cliff2", "ruined-altar.blocks", "ruined-altar2.blocks", "ruined-altar.blocks", "ruined-altar2.blocks", "ruined-altar.blocks", "ruined-altar2.blocks", "ruined-altar.blocks", "ruined-altar2.blocks");
        index.map("cliff3", "domed-temple.blocks", "keep1.blocks", "single-tower.blocks", "tall-dungeon.blocks", "tower2.blocks", "giant-skull-insides.blocks");
        index.map("isolated1", "small-stone-ruin.blocks", "test-path1.blocks", "test-path2.blocks");
        index.map("isolated2", "stone-cairn.blocks", "ruined-altar.blocks", "ruined-altar2.blocks");
        index.map("isolated3", "domed-temple.blocks", "dungeon-stairs.blocks", "roman-temple2.blocks", "stone-canopy.blocks", "keep1.blocks", "single-tower.blocks", "tall-dungeon.blocks", "tower2.blocks");
        index.map("well", "sm-well1.blocks", "sm-well2.blocks");
        index.map("building1", "test-bldg8.blocks", "test-bldg8-b.blocks");
        index.map("building2", "a-frame-proto.blocks", "a-frame-proto.blocks", "a-frame-proto.blocks", "lg-farmhouse.blocks", "test-bldg1.blocks", "test-bldg2.blocks", "test-bldg7.blocks");
        index.map("building3", "test-bldg5.blocks", "test-bldg6.blocks");
        index.map("garden", "plowed-rows.blocks");
        index.map("corn", "plowed-rows.blocks");
        index.map("gallows", "gallows1.blocks");
        index.map("graves", "graves1.blocks", "graves2.blocks", "graves3.blocks", "graves4.blocks");
        index.map("tower1", "keep1.blocks", "single-tower.blocks", "tower2.blocks");
        index.map("airport1", "small-airport.blocks");
        index.map("temple1", "stone-canopy.blocks");
        index.map("temple2", "roman-temple2.blocks", "domed-temple.blocks");
        index.map("farm1", "thatch-cottage.blocks");
        index.map("farm2", "test-bldg3.blocks", "test-bldg4.blocks");
        index.map("farm3", "lg-farmhouse.blocks");
        index = TestPoiTileFunction.typeIndexes[TestPoiTileFunction.TYPE_MODERATE] = new BuildingTypeIndex();
        index.map("cliff1", "ruined-cobble-hut.blocks", "small-stone-ruin.blocks", "stone-cairn.blocks");
        index.map("cliff2", "ruined-altar.blocks", "ruined-altar2.blocks", "ruined-altar.blocks", "ruined-altar2.blocks", "ruined-altar.blocks", "ruined-altar2.blocks", "ruined-altar.blocks", "ruined-altar2.blocks", "graves1.blocks", "graves2.blocks", "graves3.blocks", "graves4.blocks");
        index.map("cliff3", "domed-temple.blocks", "keep1.blocks", "single-tower.blocks", "tall-dungeon.blocks", "tower2.blocks", "giant-skull-insides.blocks");
        index.map("isolated1", "fence-low.blocks", "fence-tall.blocks", "small-stone-ruin.blocks", "tree-stump.blocks", "tree-stump2.blocks", "sm-well1.blocks", "sm-well2.blocks", "test-path1.blocks", "test-path2.blocks");
        index.map("isolated2", "graves1.blocks", "graves2.blocks", "graves3.blocks", "graves4.blocks", "stone-cairn.blocks", "ruined-altar.blocks", "ruined-altar2.blocks");
        index.map("isolated3", "domed-temple.blocks", "dungeon-stairs.blocks", "roman-temple2.blocks", "stone-canopy.blocks", "keep1.blocks", "single-tower.blocks", "tall-dungeon.blocks", "tower2.blocks");
        index.map("well", "sm-well1.blocks", "sm-well2.blocks");
        index.map("building1", "test-bldg3.blocks", "test-bldg4.blocks", "test-bldg7.blocks", "lg-farmhouse.blocks");
        index.map("building2", "test-bldg1.blocks", "test-bldg2.blocks");
        index.map("building3", "test-bldg5.blocks", "test-bldg6.blocks");
        index.map("garden", "corn-rows.blocks");
        index.map("corn", "corn-rows.blocks");
        index.map("gallows", "gallows1.blocks");
        index.map("graves", "graves1.blocks", "graves2.blocks", "graves3.blocks", "graves4.blocks");
        index.map("tower1", "keep1.blocks", "single-tower.blocks", "tower2.blocks");
        index.map("airport1", "small-airport.blocks");
        index.map("temple1", "stone-canopy.blocks");
        index.map("temple2", "roman-temple2.blocks", "domed-temple.blocks");
        index.map("farm1", "thatch-cottage.blocks");
        index.map("farm2", "test-bldg3.blocks", "test-bldg4.blocks");
        index.map("farm3", "lg-farmhouse.blocks");
        index = TestPoiTileFunction.typeIndexes[TestPoiTileFunction.TYPE_DESERT] = new BuildingTypeIndex();
        index.map("cliff1", "ruined-cobble-hut.blocks", "small-stone-ruin.blocks", "stone-cairn.blocks");
        index.map("cliff2", "ruined-altar.blocks", "ruined-altar2.blocks", "ruined-altar.blocks", "ruined-altar2.blocks", "ruined-altar.blocks", "ruined-altar2.blocks", "ruined-altar.blocks", "ruined-altar2.blocks", "graves1.blocks", "graves2.blocks", "graves3.blocks", "graves4.blocks");
        index.map("cliff3", "domed-temple.blocks", "keep1.blocks", "single-tower.blocks", "tall-dungeon.blocks", "tower2.blocks", "giant-skull-insides.blocks");
        index.map("isolated1", "fence-low.blocks", "fence-tall.blocks", "small-stone-ruin.blocks", "sm-well1.blocks", "sm-well2.blocks", "test-path1.blocks", "test-path2.blocks");
        index.map("isolated2", "graves1.blocks", "graves2.blocks", "graves3.blocks", "graves4.blocks", "stone-cairn.blocks", "ruined-altar.blocks", "ruined-altar2.blocks");
        index.map("isolated3", "domed-temple.blocks", "dungeon-stairs.blocks", "roman-temple2.blocks", "stone-canopy.blocks", "keep1.blocks", "single-tower.blocks", "tall-dungeon.blocks", "tower2.blocks");
        index.map("well", "sm-well1.blocks", "sm-well2.blocks");
        index.map("building1", "test-bldg8.blocks", "test-bldg8-b.blocks");
        index.map("building2", "lg-farmhouse.blocks", "test-bldg1.blocks", "test-bldg2.blocks");
        index.map("building3", "test-bldg5.blocks", "test-bldg6.blocks");
        index.map("garden", "plowed-rows.blocks");
        index.map("corn", "plowed-rows.blocks");
        index.map("gallows", "gallows1.blocks");
        index.map("graves", "graves1.blocks", "graves2.blocks", "graves3.blocks", "graves4.blocks");
        index.map("tower1", "keep1.blocks", "single-tower.blocks", "tower2.blocks");
        index.map("airport1", "small-airport.blocks");
        index.map("temple1", "stone-canopy.blocks");
        index.map("temple2", "roman-temple2.blocks", "domed-temple.blocks");
        index.map("farm1", "test-bldg8.blocks", "test-bldg8-b.blocks");
        index.map("farm2", "test-bldg3.blocks", "test-bldg4.blocks");
        index.map("farm3", "lg-farmhouse.blocks");
    }

    private static class BuildingTypeIndex {
        private ListMultimap<String, String> index = MultimapBuilder.hashKeys().arrayListValues().build();

        private BuildingTypeIndex() {
        }

        public void map(String type, String ... blocks) {
            for (String b : blocks) {
                this.index.put((Object)type, (Object)b);
            }
        }

        public String getRandom(String type, Random rand) {
            List list = this.index.get((Object)type);
            if (list == null || list.isEmpty()) {
                log.error("Unmapped type:" + type);
                return DEFAULT_BLOCKS;
            }
            int i = rand.nextInt(list.size());
            return (String)list.get(i);
        }
    }
}

