/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.LightData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnData {
    static Logger log = LoggerFactory.getLogger(ColumnData.class);
    public static final int GEN_SIDE_MASKS = 1;
    public static final int GEN_INITIAL_SUNLIGHT = 2;
    public static final int GEN_LIGHT_INTERNAL = 4;
    public static final int GEN_LIGHT_EXTERNAL = 8;
    private ColumnId columnId;
    private Vec3i loc;
    private LeafData[] leafs;
    private FluidData[] fluid;
    private LightData[] lighting;
    private DataVersion version;
    private long generationFlags;

    public ColumnData(ColumnId columnId, int size) {
        this(columnId, ColumnData.createLeafData(columnId, size), ColumnData.createFluidData(columnId, size), ColumnData.createLightData(columnId, size), new DataVersion(), 0L);
    }

    public ColumnData(ColumnId columnId, LeafData[] leafs, DataVersion version, long generationFlags) {
        this(columnId, leafs, ColumnData.createFluidData(columnId, leafs.length), ColumnData.createLightData(columnId, leafs.length), version, generationFlags);
    }

    public ColumnData(ColumnId columnId, LeafData[] leafs, LightData[] lighting, DataVersion version, long generationFlags) {
        this(columnId, leafs, ColumnData.createFluidData(columnId, leafs.length), lighting, version, generationFlags);
    }

    public ColumnData(ColumnId columnId, LeafData[] leafs, FluidData[] fluid, LightData[] lighting, DataVersion version, long generationFlags) {
        this.columnId = columnId;
        this.leafs = leafs;
        this.fluid = fluid;
        this.lighting = lighting;
        this.loc = columnId.getWorld(null);
        this.version = version;
        this.generationFlags = generationFlags;
    }

    private static LeafData[] createLeafData(ColumnId columnId, int size) {
        LeafData[] result = new LeafData[size];
        Vec3i world = columnId.getWorld(null);
        for (int i = 0; i < result.length; ++i) {
            LeafId id = LeafId.fromWorld(world.x, i * 32, world.z);
            result[i] = new LeafData(id, -1L);
        }
        return result;
    }

    private static FluidData[] createFluidData(ColumnId columnId, int size) {
        FluidData[] result = new FluidData[size];
        Vec3i world = columnId.getWorld(null);
        for (int i = 0; i < result.length; ++i) {
            LeafId id = LeafId.fromWorld(world.x, i * 32, world.z);
            result[i] = new FluidData(id);
        }
        return result;
    }

    private static LightData[] createLightData(ColumnId columnId, int size) {
        LightData[] result = new LightData[size];
        Vec3i world = columnId.getWorld(null);
        for (int i = 0; i < result.length; ++i) {
            LeafId id = LeafId.fromWorld(world.x, i * 32, world.z);
            result[i] = new LightData(id);
        }
        return result;
    }

    public int getCeiling() {
        return this.leafs.length * 32;
    }

    public void setGenerationFlag(int flag) {
        this.generationFlags |= (long)flag;
    }

    public boolean hasGenerationFlag(int flag) {
        return (this.generationFlags & (long)flag) != 0L;
    }

    public void resetGenerationFlags(long generationFlags) {
        this.generationFlags = generationFlags;
    }

    public long getGenerationFlags() {
        return this.generationFlags;
    }

    public void resetChanged(long timestamp) {
        this.version.resetChanged(timestamp);
        if (this.leafs != null) {
            for (LeafData leaf : this.leafs) {
                if (leaf == null) continue;
                leaf.getInfo().version.resetChanged(timestamp);
            }
        }
    }

    public ColumnId getColumnId() {
        return this.columnId;
    }

    public DataVersion getVersion() {
        return this.version;
    }

    public LeafData getLeafData(int yWorld) {
        if (yWorld < 0) {
            return null;
        }
        int layer = yWorld / 32;
        if (layer >= this.leafs.length || layer < 0) {
            return null;
        }
        return this.leafs[layer];
    }

    public LeafData[] getLeafs() {
        return this.leafs;
    }

    public LightData getLightData(int yWorld) {
        if (yWorld < 0) {
            return null;
        }
        int layer = yWorld / 32;
        if (layer >= this.lighting.length || layer < 0) {
            return null;
        }
        return this.lighting[layer];
    }

    public LightData[] getLighting() {
        return this.lighting;
    }

    public FluidData getFluidData(int yWorld) {
        if (yWorld < 0) {
            return null;
        }
        int layer = yWorld / 32;
        if (layer >= this.fluid.length || layer < 0) {
            return null;
        }
        return this.fluid[layer];
    }

    public FluidData[] getFluid() {
        return this.fluid;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[loc:" + this.loc + ", id:" + this.columnId + "]";
    }
}

