/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.TerrainImageDb;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.TileFunction;
import com.simsilica.mworld.tile.TileResolutionId;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileManager {
    static Logger log = LoggerFactory.getLogger(TileManager.class);
    private File root;
    private boolean initialized;
    private TerrainImageDb terrainImageDb;
    private LoadingCache<TileResolutionId, Tile> cache;
    private ListMultimap<Resolution, TileFunction> tileFunctions = MultimapBuilder.hashKeys().arrayListValues().build();

    public TileManager(TerrainImageDb terrainImageDb) {
        this.cache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<TileResolutionId, Tile>(){

            public void onRemoval(RemovalNotification<TileResolutionId, Tile> notification) {
                log.info("cacheRemoval(" + notification + ") reason:" + notification.getCause());
            }
        }).weakValues().build((CacheLoader)new CacheLoader<TileResolutionId, Tile>(){

            public Tile load(TileResolutionId id) {
                return TileManager.this.loadTile(id.getTileId(), id.getResolution());
            }
        });
        this.terrainImageDb = terrainImageDb;
        this.addTileFunction(terrainImageDb.getLoadFunction());
    }

    public void addTileFunction(TileFunction ... functions) {
        for (Resolution res : Resolution.values()) {
            this.addTileFunction(res, functions);
        }
    }

    public void addTileFunction(Resolution res, TileFunction ... functions) {
        for (TileFunction f : functions) {
            this.tileFunctions.put((Object)res, (Object)f);
        }
    }

    public <T> T getTileFunction(Resolution res, Class<T> tileFunctionType) {
        for (TileFunction f : this.tileFunctions.get((Object)res)) {
            if (!tileFunctionType.isInstance(f)) continue;
            return tileFunctionType.cast(f);
        }
        return null;
    }

    protected Tile loadTile(TileId id, Resolution res) {
        Tile result = new Tile(this, id, res);
        for (TileFunction f : this.tileFunctions.get((Object)res)) {
            f.accept(result);
        }
        return result;
    }

    public void initialize() {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        log.info("initialize()");
        this.terrainImageDb.initialize();
        this.initialized = true;
    }

    public void terminate() {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
        log.info("terminate()");
        this.terrainImageDb.terminate();
        for (TileFunction f : this.tileFunctions.values()) {
            if (!(f instanceof AutoCloseable)) continue;
            try {
                ((AutoCloseable)((Object)f)).close();
            }
            catch (Exception e) {
                log.error("Error closing:" + f, (Throwable)e);
            }
        }
        this.initialized = false;
    }

    public Tile getTile(TileId id, Resolution res) {
        return (Tile)this.cache.getUnchecked((Object)new TileResolutionId(id, res));
    }
}

