/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.morph;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.io.ObjectProtocol;
import com.simsilica.mworld.io.ProtocolSerializers;
import com.simsilica.mworld.tile.morph.Morphology;
import com.simsilica.mworld.tile.morph.MorphologyLayer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphologyLayerProtocol
implements ObjectProtocol<MorphologyLayer> {
    static Logger log = LoggerFactory.getLogger(MorphologyLayerProtocol.class);
    private int version = 43;
    private ProtocolSerializers protocols = new ProtocolSerializers();
    private Map<Class, ClassInfo> registry = new HashMap<Class, ClassInfo>();
    private Map<Short, ClassInfo> idIndex = new HashMap<Short, ClassInfo>();
    private Map<String, Class> nameIndex = new HashMap<String, Class>();
    private int baseTypeBits;
    private byte[] registryBytes;
    private boolean initialized = false;

    @Override
    public int getProtocolVersion() {
        return this.version;
    }

    public <T> void registerProtocol(Class<T> type, ObjectProtocol<T> protocol) {
        if (this.initialized) {
            throw new IllegalStateException("Protocol already initialized");
        }
        this.protocols.registerProtocol(type, protocol);
        short id = (short)this.idIndex.size();
        ClassInfo info = new ClassInfo(type, id, protocol.getProtocolVersion());
        this.registry.put(type, info);
        this.idIndex.put(id, info);
        this.nameIndex.put(type.getName(), type);
    }

    public void initialize() {
        this.setupBaseBits();
        this.setupRegistryBytes();
        this.initialized = true;
    }

    private void confirmInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Protocol not initialized");
        }
    }

    private void setupBaseBits() {
        if (this.baseTypeBits == 0) {
            log.info("baseTypeBits is 0, checking index initialized state...");
            this.baseTypeBits = 32 - Integer.numberOfLeadingZeros(this.idIndex.size());
            log.info("baseTypeBits:" + this.baseTypeBits + "  index size:" + this.idIndex.size());
        }
    }

    private void setupRegistryBytes() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        try {
            out.writeShort(this.idIndex.size());
            for (ClassInfo info : this.idIndex.values()) {
                out.writeUTF(info.type.getName());
                out.writeShort(info.id);
                out.writeInt(info.version);
            }
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error building registry bytes", e);
        }
        this.registryBytes = bos.toByteArray();
        log.info("Registry bytes size:" + this.registryBytes.length);
    }

    protected void writeClassRegistry(BitOutputStream out) throws IOException {
        out.writeBits(this.registryBytes.length, 16);
        for (byte b : this.registryBytes) {
            out.writeBits((int)b, 8);
        }
    }

    protected Map<Short, ClassInfo> readClassRegistry(BitInputStream bitIn) throws IOException {
        int size = bitIn.readBits(16);
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            bytes[i] = (byte)bitIn.readBits(8);
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
        DataInputStream in = new DataInputStream(bin);
        size = in.readShort();
        HashMap<Short, ClassInfo> results = new HashMap<Short, ClassInfo>();
        for (int i = 0; i < size; ++i) {
            String name = in.readUTF();
            short id = in.readShort();
            int version = in.readInt();
            Class type = this.nameIndex.get(name);
            if (type == null) {
                throw new IOException("Stream references unknown type:" + name);
            }
            results.put(id, new ClassInfo(type, id, version));
        }
        return results;
    }

    @Override
    public void write(MorphologyLayer data, BitOutputStream out) throws IOException {
        this.confirmInitialized();
        out.writeBits(this.version, 16);
        TileId tileId = data.getTileId();
        long id = tileId.getId();
        out.writeLongBits(id, 64);
        out.writeLongBits(data.getVersion().getVersion(), 64);
        out.writeBits(data.getGenerationLevel(), 8);
        log.info("writeing layer for:" + tileId + "  size:" + data.getMorphology().size());
        out.writeBits(this.baseTypeBits, 8);
        this.writeClassRegistry(out);
        int size = data.getMorphology().size();
        out.writeBits(size, 32);
        for (Morphology m : data.getMorphology()) {
            ClassInfo info = this.registry.get(m.getClass());
            if (info == null) {
                throw new IOException("No protocol registered for class:" + m.getClass());
            }
            out.writeBits((int)info.id, this.baseTypeBits);
            this.protocols.write(m, out);
        }
    }

    @Override
    public MorphologyLayer read(BitInputStream in) throws IOException {
        this.confirmInitialized();
        int version = in.readBits(16);
        TileId tileId = new TileId(in.readLongBits(64));
        long dataVersion = in.readLongBits(64);
        int generationLevel = 0;
        if (version >= 43) {
            generationLevel = in.readBits(8);
        }
        log.info("reading layer for:" + tileId);
        int typeBits = in.readBits(8);
        Map<Short, ClassInfo> index = this.readClassRegistry(in);
        int size = in.readBits(32);
        ArrayList<Morphology> morphs = new ArrayList<Morphology>();
        for (int i = 0; i < size; ++i) {
            int typeId = in.readBits(typeBits);
            ClassInfo info = index.get((short)typeId);
            if (info == null) {
                throw new RuntimeException("No class registered for type ID:" + typeId);
            }
            Morphology m = (Morphology)this.protocols.read(info.type, in);
            morphs.add(m);
        }
        return new MorphologyLayer(tileId, new DataVersion(dataVersion), generationLevel, morphs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(MorphologyLayer morphs, OutputStream rawOut) throws IOException {
        try (BitOutputStream out = new BitOutputStream(rawOut);){
            this.write(morphs, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MorphologyLayer read(InputStream rawIn) throws IOException {
        try (BitInputStream in = new BitInputStream(rawIn);){
            MorphologyLayer morphologyLayer = this.read(in);
            return morphologyLayer;
        }
    }

    private static class ClassInfo {
        Class type;
        short id;
        int version;

        public ClassInfo(Class type, short id, int version) {
            this.type = type;
            this.id = id;
            this.version = version;
        }
    }
}

