/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.net.client;

import com.jme3.network.service.AbstractClientService;
import com.jme3.network.service.ClientServiceManager;
import com.jme3.network.service.rmi.RmiClientService;
import com.simsilica.net.ChatSession;
import com.simsilica.net.ChatSessionListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatClientService
extends AbstractClientService
implements ChatSession {
    static Logger log = LoggerFactory.getLogger(ChatClientService.class);
    private RmiClientService rmiService;
    private int channel;
    private ChatSession delegate;
    private String playerName;
    private ChatSessionCallback sessionCallback = new ChatSessionCallback();
    private List<ChatSessionListener> listeners = new CopyOnWriteArrayList<ChatSessionListener>();

    public ChatClientService() {
        this(-2);
    }

    public ChatClientService(int channel) {
        this.channel = channel;
    }

    @Override
    public void sendMessage(String message) {
        this.getDelegate().sendMessage(message);
    }

    @Override
    public List<String> getPlayerNames() {
        return this.getDelegate().getPlayerNames();
    }

    public void addChatSessionListener(ChatSessionListener l) {
        this.listeners.add(l);
    }

    public void removeChatSessionListener(ChatSessionListener l) {
        this.listeners.remove(l);
    }

    protected void onInitialize(ClientServiceManager s) {
        log.debug("onInitialize(" + s + ")");
        this.rmiService = (RmiClientService)this.getService(RmiClientService.class);
        if (this.rmiService == null) {
            throw new RuntimeException("ChatClientService requires RMI service");
        }
        log.debug("Sharing session callback.");
        this.rmiService.share((byte)this.channel, (Object)this.sessionCallback, ChatSessionListener.class);
    }

    public void start() {
        log.debug("start()");
        super.start();
    }

    private ChatSession getDelegate() {
        if (this.delegate == null) {
            this.delegate = (ChatSession)this.rmiService.getRemoteObject(ChatSession.class);
            log.debug("delegate:" + this.delegate);
            if (this.delegate == null) {
                throw new RuntimeException("No chat session found");
            }
        }
        return this.delegate;
    }

    private class ChatSessionCallback
    implements ChatSessionListener {
        private ChatSessionCallback() {
        }

        @Override
        public void playerJoined(int clientId, String playerName) {
            if (log.isTraceEnabled()) {
                log.trace("playerJoined(" + clientId + ", " + playerName + ")");
            }
            for (ChatSessionListener l : ChatClientService.this.listeners) {
                l.playerJoined(clientId, playerName);
            }
        }

        @Override
        public void newMessage(int clientId, String playerName, String message) {
            if (log.isTraceEnabled()) {
                log.trace("newMessage(" + clientId + ", " + playerName + ", " + message + ")");
            }
            for (ChatSessionListener l : ChatClientService.this.listeners) {
                l.newMessage(clientId, playerName, message);
            }
        }

        @Override
        public void playerLeft(int clientId, String playerName) {
            if (log.isTraceEnabled()) {
                log.trace("playerLeft(" + clientId + ", " + playerName + ")");
            }
            for (ChatSessionListener l : ChatClientService.this.listeners) {
                l.playerLeft(clientId, playerName);
            }
        }
    }
}

