/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.simsilica.es.EntityId;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import mythruna.client.GameInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ConfigurationState.class);
    private Preferences root;
    private boolean invalid = false;

    public ConfigurationState() {
        String id = ((Object)((Object)this)).getClass().getPackage().getName() + ".configuration";
        this.root = Preferences.userRoot().node(id);
        log.info("Config root:" + this.root);
    }

    public void set(String key, String value) {
        if (value == null) {
            this.root.remove(key);
        } else {
            this.root.put(key, value);
        }
        this.invalid = true;
    }

    public void set(String key, EntityId value) {
        key = key + ":entityId";
        if (value == null) {
            this.root.remove(key);
        } else {
            this.root.putLong(key, value.getId());
        }
        this.invalid = true;
    }

    public void set(String key, GameInfo game) {
        this.set(key + ".worldDir", game.worldDir);
        this.set(key + ".userId", game.userId);
        this.set(key + ".userEntity", game.userEntity);
        this.set(key + ".character", game.character);
    }

    public GameInfo getGameInfo(String key) {
        String worldDir = this.getString(key + ".worldDir", null);
        if (worldDir == null) {
            return null;
        }
        GameInfo game = new GameInfo();
        game.worldDir = worldDir;
        game.userId = this.getString(key + ".userId", null);
        game.userEntity = this.getEntity(key + ".userEntity");
        game.character = this.getEntity(key + ".character");
        return game;
    }

    public String getString(String key, String def) {
        return this.root.get(key, def);
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public EntityId getEntity(String key) {
        if (this.getString(key = key + ":entityId", null) == null) {
            return null;
        }
        long id = this.root.getLong(key, -1L);
        return id == -1L ? null : new EntityId(id);
    }

    protected void validate() {
        this.invalid = false;
        try {
            this.root.sync();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException("Error synching config", e);
        }
    }

    protected void initialize(Application app) {
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
    }

    protected void onDisable() {
    }

    public void update(float tpf) {
        if (this.invalid) {
            this.validate();
        }
    }
}

