/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net;

import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.CreatedBy;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.Name;
import com.simsilica.fsm.StateMachine;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.value.DefaultValueRenderer;
import com.simsilica.mworld.World;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.ProgressState;
import mythruna.client.net.CharacterEditor;
import mythruna.client.net.ConnectionState;
import mythruna.client.net.WorldPreloader;
import mythruna.client.sound.SoundState;
import mythruna.client.ui.CreditsState;
import mythruna.net.AccountSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LobbyState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(LobbyState.class);
    private boolean singlePlayer;
    private StateMachine<String, String> fsm;
    private Container window;
    private ListBox<Entity> characterList;
    private Label worldName;
    private World world;
    private EntityData ed;
    private EntityId player;
    private CharacterContainer charContainer;
    private VersionedList<Entity> characters = new VersionedList();
    private CharacterEditor charEditor;
    private CreditsState blurbs;

    public LobbyState(boolean singlePlayer, StateMachine<String, String> fsm) {
        this.fsm = fsm;
        this.singlePlayer = singlePlayer;
        this.setEnabled(false);
    }

    protected void play() {
        log.info("play");
        Entity character = (Entity)this.characterList.getSelectedItem();
        if (character == null) {
            log.info("no character selected");
            return;
        }
        this.fsm.trigger((Object)"play", (Object)character.getId());
        SoundState sounds = (SoundState)this.getState(SoundState.class);
        if (!sounds.isPlaying("Loading Music")) {
            sounds.playMusic("Loading Music", 1.0f);
        }
        this.startBlurbs();
        ProgressState.ProgressTracker tracker = ((ProgressState)this.getState(ProgressState.class)).createTracker("enterWorld", "Entering world...");
        WorldPreloader preloader = new WorldPreloader(character.getId(), (ConnectionState)this.getState(ConnectionState.class), tracker);
        preloader.onDone(error -> {
            if (error != null) {
                this.stopBlurbs();
                tracker.close();
                this.fsm.trigger((Object)"failure", error);
                return;
            }
            log.info("Starting real game session...");
            sounds.stopAll(5.0f);
            this.getStateManager().attach((AppState)new GameSessionState(preloader, this.singlePlayer));
            this.getApplication().enqueue(() -> this.closeTracker(3, tracker));
        });
        ((JobState)this.getState(JobState.class)).execute((Job)preloader, 0);
    }

    protected void closeTracker(int left, ProgressState.ProgressTracker tracker) {
        log.info("closeTracker(" + left + ")");
        if (left > 0) {
            this.getApplication().enqueue(() -> this.closeTracker(left - 1, tracker));
            return;
        }
        tracker.close();
        this.stopBlurbs();
    }

    protected void startBlurbs() {
        if (this.getStateManager().hasState((AppState)this.blurbs)) {
            return;
        }
        this.getStateManager().attach((AppState)this.blurbs);
    }

    protected void stopBlurbs() {
        this.getStateManager().detach((AppState)this.blurbs);
    }

    protected void exit() {
        log.info("exit");
        this.fsm.trigger((Object)"exit");
    }

    protected void createCharacter() {
        log.info("createCharacter()");
        this.charEditor.editCharacter(null, this::doCreateCharacter);
    }

    protected void doCreateCharacter() {
        log.info("doCreateCharacter()");
        AccountSession account = ((ConnectionState)this.getState(ConnectionState.class)).getService(AccountSession.class);
        account.createCharacter(this.charEditor.getName(), new EntityComponent[0]);
    }

    public void setPlayer(String userId) {
        this.ed = ((ConnectionState)this.getState(ConnectionState.class)).getEntityData();
        this.world = ((ConnectionState)this.getState(ConnectionState.class, true)).getService(World.class);
        ComponentFilter filter = Filters.fieldEquals(Name.class, (String)"name", (Object)userId);
        this.setPlayer(this.ed.findEntity(filter, new Class[]{Name.class}));
        if (this.player == null) {
            throw new IllegalArgumentException("Player not found:" + userId);
        }
    }

    public void setPlayer(EntityId player) {
        this.ed = ((ConnectionState)this.getState(ConnectionState.class)).getEntityData();
        this.world = ((ConnectionState)this.getState(ConnectionState.class, true)).getService(World.class);
        this.player = player;
        this.updateInfo();
    }

    protected void updateInfo() {
        AccountSession account = ((ConnectionState)this.getState(ConnectionState.class, true)).getService(AccountSession.class);
        final EntityId worldEntity = account.getWorldEntity();
        ((JobState)this.getState(JobState.class)).execute(new Job(){
            private Name name;

            public void runOnWorker() {
                this.name = (Name)LobbyState.this.ed.getComponent(worldEntity, Name.class);
            }

            public double runOnUpdate() {
                LobbyState.this.worldName.setText("World: " + this.name.getName());
                return 0.0;
            }
        });
    }

    protected void initialize(Application app) {
        this.window = new Container((GuiLayout)new BorderLayout(), new ElementId("window"));
        Container charMgr = (Container)this.window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Last, FillMode.Even)), new Object[]{BorderLayout.Position.West});
        charMgr.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "createCharacter")), new Object[0]);
        this.characterList = (ListBox)charMgr.addChild((Node)new ListBox(this.characters), new Object[0]);
        this.characterList.setVisibleItems(10);
        this.characterList.setCellRenderer((ValueRenderer)new CharacterRenderer());
        charMgr.addChild((Node)new Label(""), new Object[0]);
        this.worldName = (Label)this.window.addChild((Node)new Label("World Name", new ElementId("window.title")), new Object[]{BorderLayout.Position.North});
        this.worldName.setTextHAlignment(HAlignment.Center);
        Container buttons = (Container)this.window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[]{BorderLayout.Position.South});
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "play")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "exit")), new Object[0]);
        Vector2f size = ((GuiState)this.getState(GuiState.class)).getGuiSize();
        Vector3f pref = this.window.getPreferredSize().clone();
        pref.x = Math.max(size.x * 0.9f, pref.x);
        pref.y = Math.max(size.y * 0.9f, pref.y);
        this.window.setPreferredSize(pref);
        this.charEditor = new CharacterEditor();
        this.blurbs = new CreditsState();
        String[] messages = new String[]{"When entering a new world for the first time\nloading can take a while.", "Town and village placement is purely random and not finalized.", "The frequency of points of interest is overly chaotic\n...and placement is sometimes just weird.", "For a new world, it may take a while before far generation settles\nand the game may feel sluggish during that time.", "While playing, additional far-generation progress will be shown in the lower right corner.", "Thanks for playing the game!!!", "Thanks for waiting for the world generation to complete."};
        List<String> list = Arrays.asList(messages);
        List<String> sublist = list.subList(1, messages.length - 1);
        Collections.shuffle(sublist);
        double duration = 9.0;
        double nextTime = 1.0;
        for (String s : messages) {
            this.blurbs.addCredit(s, nextTime, nextTime + duration, 0.5, 0.1);
            nextTime += duration;
        }
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        ((GuiState)this.getState(GuiState.class)).center((Panel)this.window);
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.window);
        this.charContainer = new CharacterContainer(this.ed, this.player);
        this.charContainer.start();
    }

    public void update(float tpf) {
        this.charContainer.update();
    }

    protected void onDisable() {
        this.window.removeFromParent();
        this.charContainer.stop();
    }

    private class CharacterRenderer
    extends DefaultValueRenderer<Entity> {
        private CharacterRenderer() {
        }

        protected String valueToString(Entity value) {
            return ((Name)value.get(Name.class)).getName();
        }

        public Panel getView(Entity value, boolean selected, Panel existing) {
            Panel result = super.getView((Object)value, selected, existing);
            return result;
        }
    }

    private class CharacterContainer
    extends EntityContainer<Entity> {
        public CharacterContainer(EntityData ed, EntityId player) {
            super(ed, Filters.fieldEquals(CreatedBy.class, (String)"creatorId", (Object)player), new Class[]{CreatedBy.class, Name.class});
        }

        protected Entity addObject(Entity e) {
            LobbyState.this.characters.add((Object)e);
            return e;
        }

        protected void updateObject(Entity object, Entity e) {
        }

        protected void removeObject(Entity object, Entity e) {
            LobbyState.this.characters.remove((Object)e);
        }
    }
}

