/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.texture.Texture;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.core.GuiMaterial;
import com.simsilica.lemur.dnd.DefaultDraggable;
import com.simsilica.lemur.dnd.DragAndDropControl;
import com.simsilica.lemur.dnd.DragAndDropListener;
import com.simsilica.lemur.dnd.DragEvent;
import com.simsilica.lemur.dnd.DragSession;
import com.simsilica.lemur.dnd.DragStatus;
import com.simsilica.lemur.dnd.Draggable;
import com.simsilica.lemur.event.CursorButtonEvent;
import com.simsilica.lemur.event.CursorEventControl;
import com.simsilica.lemur.event.CursorListener;
import com.simsilica.lemur.event.CursorMotionEvent;
import com.simsilica.lemur.event.DefaultCursorListener;
import com.simsilica.lemur.event.DragHandler;
import com.simsilica.lemur.geom.TbtQuad;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import java.util.Objects;
import mythruna.client.ui.ContainerViewState;
import mythruna.client.ui.Grid;
import mythruna.client.ui.HelpPopup;
import mythruna.client.ui.ItemType;
import mythruna.client.ui.ItemView;
import mythruna.es.ContainedIn;
import mythruna.es.ContainerVolume;
import mythruna.es.ObjectVolume;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerView
extends Container {
    static Logger log = LoggerFactory.getLogger(ContainerView.class);
    private ContainerViewState parent;
    private EntityData ed;
    private Entity container;
    private int containerWidth;
    private int containerHeight;
    private int cellSize = 5;
    private ItemView containerItem;
    private Spatial containerModel;
    private Grid grid;
    private DragAndDropHandler dndHandler = new DragAndDropHandler();
    private DragAndDropControl dndControl = new DragAndDropControl(new DragAndDropListener[]{this.dndHandler});
    private ColorRGBA gridColor = new ColorRGBA(0.2f, 0.2f, 0.1f, 0.7f);
    private ColorRGBA pendingColor = new ColorRGBA(0.2f, 0.2f, 0.1f, 0.7f);
    private ColorRGBA borderColor = new ColorRGBA(0.8156863f, 0.7607843f, 0.60784316f, 0.5f);
    private ColorRGBA activeColor = new ColorRGBA(0.40784314f, 0.38039216f, 0.3019608f, 0.5f);
    private ColorRGBA invalidColor = new ColorRGBA(0.4f, 0.1f, 0.1f, 0.5f);
    private ColorRGBA nullColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
    private ColorRGBA itemColor = new ColorRGBA(0.2f, 0.2f, 0.1f, 0.5f);
    private ContainerInventory items;
    private HelpPopup help;

    public ContainerView(ContainerViewState parent, EntityData ed, Entity container) {
        this.parent = parent;
        this.ed = ed;
        this.container = container;
        this.items = new ContainerInventory(ed, container.getId());
        this.containerItem = parent.getItemView(container);
        this.containerModel = this.containerItem;
        this.containerItem.attachChild((Spatial)this);
        ContainerVolume volume = (ContainerVolume)container.get(ContainerVolume.class);
        Vec3d size = volume.getSize().mult(100.0);
        double totalVolume = size.x * size.y * size.z;
        double area = size.x * size.z;
        double areaScale = Math.sqrt(totalVolume / area);
        int xSlots = (int)Math.ceil(areaScale * size.x / (double)(this.cellSize * 2)) * 2;
        int ySlots = (int)Math.ceil(areaScale * size.z / (double)(this.cellSize * 2)) * 2;
        this.containerWidth = ++xSlots;
        this.containerHeight = ++ySlots;
        log.info("areaScale:" + areaScale + "  w:" + areaScale * size.x + " h:" + areaScale * size.z);
        log.info("size:" + size + "  xSlots:" + xSlots + "  ySlots:" + ySlots);
        this.grid = new Grid(xSlots, ySlots, this.cellSize, 2.0f);
        this.grid.setUserData("oid", container.getId().getId());
        this.grid.setGridColor(this.gridColor);
        this.grid.move(0.0f, 0.0f, 0.1f);
        this.attachChild((Spatial)this.grid);
        int outerWidth = this.containerItem.getItemType().getXSlots() * this.cellSize;
        int outerHeight = this.containerItem.getItemType().getYSlots() * this.cellSize;
        double xOffset = (double)outerWidth * 0.5 - (double)(xSlots * this.cellSize) * 0.5;
        double yOffset = (double)outerHeight * 0.5 - (double)(ySlots * this.cellSize) * 0.5;
        this.move((float)xOffset, (float)(-yOffset), 0.0f);
        this.grid.addControl((Control)this.dndControl);
        this.help = new HelpPopup((Spatial)this.grid, parent::getGuiLocation, "Player Inventory");
        this.help.setText("Click the right mouse button for menu options.\nUse the right or left mouse to drag an item to a different\nslot.\n\nOpen inventory containers can be dragged around the\nscreen as needed.\n\nTips:\nRight Mouse -> 'Look' may provide additional help about\na tool.\nThe 'Build Wand' is used for placing/removing blocks.\nThe 'Object Tool' is used for placing/modifying objects.");
        this.help.attach();
        this.items.start();
        CursorEventControl.addListenersToSpatial((Spatial)this.containerItem, (CursorListener[])new CursorListener[]{new DragHandler()});
        CursorEventControl.addListenersToSpatial((Spatial)this.grid, (CursorListener[])new CursorListener[]{new ClickHandler()});
    }

    public void setPosition(float x, float y) {
        this.containerItem.setLocalTranslation(x, y, 0.0f);
    }

    public Vector2f getItemSize() {
        return this.containerItem.getItemSize();
    }

    public void release() {
        this.help.detach();
        this.items.stop();
        this.removeFromParent();
        this.grid.removeControl((Control)this.dndControl);
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        this.items.update();
    }

    public EntityId getEntityId(Vector3f world) {
        Vec3i slot = this.getCellLocation(world);
        log.info("cell:" + slot);
        for (Item item : this.items.getArray()) {
            if (!item.contains(slot.x, slot.y)) continue;
            return item.entity.getId();
        }
        return null;
    }

    public ItemView getEntityView(Vector3f world) {
        Vec3i slot = this.getCellLocation(world);
        log.info("cell:" + slot);
        for (Item item : this.items.getArray()) {
            if (!item.contains(slot.x, slot.y)) continue;
            return item.view;
        }
        return null;
    }

    private Vec3i getCellLocation(Vector3f world) {
        Vector3f local = this.grid.worldToLocal(world, null);
        int xSlot = (int)(local.x / (float)this.cellSize);
        int ySlot = (int)(-local.y / (float)this.cellSize);
        return new Vec3i(xSlot, ySlot, 0);
    }

    private class ContainerInventory
    extends EntityContainer<Item> {
        public ContainerInventory(EntityData ed, EntityId containerId) {
            super(ed, new Class[]{ContainedIn.class, ObjectVolume.class, ShapeInfo.class});
            this.setFilter(Filters.fieldEquals(ContainedIn.class, (String)"container", (Object)containerId));
        }

        public Item[] getArray() {
            return (Item[])super.getArray();
        }

        protected Item addObject(Entity e) {
            log.info("add item:" + e);
            Item item = new Item(e);
            ContainerView.this.grid.attachChild((Spatial)item.view);
            this.updateObject(item, e);
            return item;
        }

        protected void updateObject(Item object, Entity e) {
            log.info("update item:" + object);
            object.update();
        }

        protected void removeObject(Item object, Entity e) {
            log.info("remove item:" + object);
            ContainerView.this.grid.detachChild((Spatial)object.view);
        }
    }

    private class DragAndDropHandler
    implements DragAndDropListener {
        private ObjectBorder dragBorder;

        public DragAndDropHandler() {
            this.dragBorder = new ObjectBorder(1, 1);
        }

        public Draggable onDragDetected(DragEvent event) {
            log.info("onDragDetected(" + event + ")");
            Vec3i slot = ContainerView.this.getCellLocation(event.getCollision().getContactPoint());
            log.info("hit cell:" + slot);
            Item hit = null;
            for (Item item : ContainerView.this.items.getArray()) {
                if (!item.contains(slot.x, slot.y)) continue;
                hit = item;
                break;
            }
            log.info("   hit:" + hit);
            if (hit == null) {
                return null;
            }
            ContainerView.this.grid.setGridColor(ContainerView.this.activeColor);
            event.getSession().set("item", (Object)hit);
            event.getSession().set("gridLocation", (Object)hit);
            this.dragBorder.setSize(hit.view.getItemType());
            this.dragBorder.attach();
            return new ItemDraggable(event.getViewPort(), hit, this.dragBorder, event.getLocation());
        }

        public void onDragEnter(DragEvent event) {
            log.info("+++++++ onDragEnter(" + event + ")");
            this.dragBorder.attach();
            ContainerView.this.grid.setGridColor(ContainerView.this.activeColor);
        }

        public void onDragExit(DragEvent event) {
            log.info("------- onDragExit(" + event + ")");
            this.dragBorder.detach();
            ContainerView.this.grid.setGridColor(ContainerView.this.gridColor);
        }

        public void onDragOver(DragEvent event) {
            log.info("onDragOver(" + event + ")");
            DragSession session = event.getSession();
            Item item = (Item)session.get("item", (Object)null);
            ItemType type = item.view.getItemType();
            Vec3i hit = ContainerView.this.getCellLocation(event.getCollision().getContactPoint());
            Vector3f loc = item.view.getLocalTranslation();
            int xSlot = Math.round(loc.x / (float)ContainerView.this.cellSize);
            int ySlot = Math.round(-loc.y / (float)ContainerView.this.cellSize);
            boolean valid = true;
            if (xSlot < 0 || ySlot < 0) {
                valid = false;
            } else if (xSlot + type.getXSlots() > ContainerView.this.containerWidth) {
                valid = false;
            } else if (ySlot + type.getYSlots() > ContainerView.this.containerHeight) {
                valid = false;
            }
            if (!valid) {
                event.getSession().setDragStatus(DragStatus.NoTarget);
                return;
            }
            this.dragBorder.setPosition(xSlot, ySlot);
            Item overlap = null;
            for (Item it : ContainerView.this.items.getArray()) {
                if (it == item || !it.intersects(xSlot, ySlot, type.getXSlots(), type.getYSlots())) continue;
                overlap = it;
                break;
            }
            log.info("overlap:" + overlap);
            if (overlap == null) {
                event.getSession().setDragStatus(DragStatus.ValidTarget);
            } else {
                event.getSession().setDragStatus(DragStatus.InvalidTarget);
            }
        }

        public void onDrop(DragEvent event) {
            log.info("onDrop(" + event + ")");
            DragSession session = event.getSession();
            Item item = (Item)session.get("item", (Object)null);
            ItemType type = item.view.getItemType();
            Vec3i hit = ContainerView.this.getCellLocation(event.getCollision().getContactPoint());
            Vector3f loc = item.view.getLocalTranslation();
            int xSlot = Math.round(loc.x / (float)ContainerView.this.cellSize);
            int ySlot = Math.round(-loc.y / (float)ContainerView.this.cellSize);
            boolean valid = true;
            if (valid) {
                ContainerView.this.containerItem.runAction("drop", item.entity.getId(), xSlot, ySlot);
            } else {
                event.getSession().setDragStatus(DragStatus.InvalidTarget);
            }
        }

        public void onDragDone(DragEvent event) {
            log.info("onDragDone(" + event + ")");
            ContainerView.this.grid.setGridColor(ContainerView.this.gridColor);
            DragSession session = event.getSession();
            log.info(" status:" + session.getDragStatus() + "  drop target:" + session.getDropTarget());
            this.dragBorder.detach();
            if (session.getDropTarget() == null) {
                Item item = (Item)session.get("item", (Object)null);
                item.update();
            }
        }
    }

    private class ClickHandler
    extends DefaultCursorListener {
        private int contextButton = 1;
        private float xDown;
        private float yDown;
        private CollisionResult lastCollision;

        private ClickHandler() {
        }

        protected void click(CursorButtonEvent event, Spatial target, Spatial capture) {
            if (event.getButtonIndex() == this.contextButton) {
                log.info("Context popup:" + this.lastCollision);
                if (this.lastCollision == null) {
                    return;
                }
                Vec3i slot = ContainerView.this.getCellLocation(this.lastCollision.getContactPoint());
                log.info("hit cell:" + slot);
                Item hit = null;
                for (Item item : ContainerView.this.items.getArray()) {
                    if (!item.contains(slot.x, slot.y)) continue;
                    hit = item;
                    break;
                }
                log.info("   hit:" + hit);
                if (hit == null) {
                    return;
                }
                ContainerView.this.parent.clearPopups();
                ContainerView.this.containerItem.runAction("itemActions", hit.entity.getId());
            }
        }

        public void cursorMoved(CursorMotionEvent event, Spatial target, Spatial capture) {
            this.lastCollision = event.getCollision();
        }

        public void cursorButtonEvent(CursorButtonEvent event, Spatial target, Spatial capture) {
            if (event.getButtonIndex() == this.contextButton) {
                // empty if block
            }
            if (event.isPressed()) {
                this.xDown = event.getX();
                this.yDown = event.getY();
            } else {
                float x = event.getX();
                float y = event.getY();
                if (Math.abs(x - this.xDown) < 3.0f && Math.abs(y - this.yDown) < 3.0f) {
                    this.click(event, target, capture);
                }
            }
        }
    }

    private class Item {
        ItemView view;
        Entity entity;
        ContainedIn in;
        ObjectBorder border;

        public Item(Entity entity) {
            this.entity = entity;
            this.view = ContainerView.this.parent.getItemView(entity);
            this.border = new ObjectBorder(this.view.getItemType());
            this.border.attach();
        }

        public boolean contains(int xSlot, int ySlot) {
            return this.view.getItemType().contains(xSlot - this.in.getX(), ySlot - this.in.getY());
        }

        public boolean intersects(int xSlot, int ySlot, int width, int height) {
            if (xSlot + width <= this.in.getX()) {
                return false;
            }
            if (ySlot + height <= this.in.getY()) {
                return false;
            }
            if (xSlot >= this.in.getX() + this.view.getItemType().getXSlots()) {
                return false;
            }
            return ySlot < this.in.getY() + this.view.getItemType().getYSlots();
        }

        protected void updatePosition() {
            log.info("updatePosition() in:" + this.in.getContainer() + "  managed by:" + ContainerView.this.container.getId());
            if (!Objects.equals(this.in.getContainer(), ContainerView.this.container.getId())) {
                return;
            }
            float x = this.in.getX() * ContainerView.this.cellSize;
            float y = this.in.getY() * ContainerView.this.cellSize;
            this.view.setLocalTranslation(x, -y, 0.0f);
            log.info("Moved to:" + this.view.getLocalTranslation() + "  world:" + this.view.getWorldTranslation());
            this.border.setPosition(this.in.getX(), this.in.getY());
        }

        protected void update() {
            this.in = (ContainedIn)this.entity.get(ContainedIn.class);
            this.updatePosition();
        }

        public void release() {
            this.border.detach();
        }

        public String toString() {
            return "Item[" + this.entity + "]";
        }
    }

    private class ItemDraggable
    extends DefaultDraggable {
        private Item item;
        private ObjectBorder border;

        public ItemDraggable(ViewPort view, Item item, ObjectBorder border, Vector2f start) {
            super(view, (Spatial)item.view, start);
            if (item.view == null) {
                throw new IllegalArgumentException("Item view is null:" + item);
            }
            this.item = item;
            this.border = border;
        }

        public void updateDragStatus(DragStatus status) {
            log.info("updateDragStatus(" + status + ")");
            switch (status) {
                case InvalidTarget: {
                    this.border.material.setColor(ContainerView.this.invalidColor);
                    ContainerView.this.grid.setGridColor(ContainerView.this.activeColor);
                    break;
                }
                case ValidTarget: {
                    this.border.material.setColor(ContainerView.this.pendingColor);
                    ContainerView.this.grid.setGridColor(ContainerView.this.activeColor);
                    break;
                }
                default: {
                    this.border.material.setColor(ContainerView.this.nullColor);
                    ContainerView.this.grid.setGridColor(ContainerView.this.gridColor);
                }
            }
        }

        public void release() {
        }
    }

    private class ObjectBorder {
        int width;
        int height;
        Geometry border;
        GuiMaterial material;

        public ObjectBorder(ItemType type) {
            this(type.getXSlots(), type.getYSlots());
        }

        public ObjectBorder(int width, int height) {
            this.setSize(width, height);
        }

        public void setSize(ItemType type) {
            this.setSize(type.getXSlots(), type.getYSlots());
        }

        public void setSize(int width, int height) {
            if (this.width == width && this.height == height) {
                return;
            }
            this.width = width;
            this.height = height;
            boolean attached = false;
            if (this.border != null) {
                this.border.removeFromParent();
                attached = true;
            }
            TbtQuad quad = new TbtQuad((float)(width * ContainerView.this.cellSize), (float)(height * ContainerView.this.cellSize), 1, 1, 126, 126, 128, 128, 0.2f);
            this.border = new Geometry("item back", (Mesh)quad){

                public int collideWith(Collidable other, CollisionResults results) {
                    return 0;
                }
            };
            this.border.setQueueBucket(RenderQueue.Bucket.Transparent);
            Texture texture = GuiGlobals.getInstance().loadTexture("Interface/bordered-gradient.png", false, false);
            this.material = GuiGlobals.getInstance().createMaterial(texture, false);
            this.material.setColor(ContainerView.this.itemColor);
            this.material.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            this.material.getMaterial().getAdditionalRenderState().setDepthWrite(false);
            this.border.setMaterial(this.material.getMaterial());
            this.border.setUserData("layer", (Object)2);
            if (attached) {
                this.attach();
            }
        }

        public void setPosition(int xSlot, int ySlot) {
            this.border.setLocalTranslation((float)(xSlot * ContainerView.this.cellSize), (float)(-(ySlot + this.height) * ContainerView.this.cellSize), 0.05f);
        }

        public void attach() {
            ContainerView.this.grid.attachChild((Spatial)this.border);
        }

        public void detach() {
            this.border.removeFromParent();
        }
    }
}

