/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.action.Option;
import com.simsilica.action.PromptType;
import com.simsilica.es.EntityId;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.event.PopupState;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.state.MessageState;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import mythruna.client.GameSessionState;
import mythruna.client.PerspectiveGuiState;
import mythruna.net.DefaultGameSessionListener;
import mythruna.net.GameSession;
import mythruna.net.GameSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPromptState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(UserPromptState.class);
    private PerspectiveGuiState gui;
    private GameSessionState sessionState;
    private GameSession session;
    private SessionObserver sessionObserver = new SessionObserver();
    private Function<EntityId, Vector3f> locationFunction;
    private Map<EntityId, Prompt> activePrompts = new HashMap<EntityId, Prompt>();

    public UserPromptState() {
        this.setEnabled(false);
    }

    public void setLocationFunction(Function<EntityId, Vector3f> locationFunction) {
        this.locationFunction = locationFunction;
    }

    public void clearLocationFunction(Function<EntityId, Vector3f> locationFunction) {
        if (this.locationFunction == locationFunction) {
            this.locationFunction = null;
        }
    }

    public Function<EntityId, Vector3f> getLocationFunction() {
        return this.locationFunction;
    }

    public void clear() {
        for (Prompt prompt : this.activePrompts.values()) {
            prompt.detach();
        }
        this.activePrompts.clear();
    }

    protected void initialize(Application app) {
        this.gui = (PerspectiveGuiState)this.getState(PerspectiveGuiState.class, true);
        this.sessionState = (GameSessionState)this.getState(GameSessionState.class, true);
        this.sessionState.addGameSessionListener((GameSessionListener)this.sessionObserver);
        this.session = this.sessionState.getGameSession();
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        log.info("onEnable()");
        GuiGlobals.getInstance().requestCursorEnabled((Object)this);
        for (Prompt prompt : this.activePrompts.values()) {
            prompt.attach();
        }
    }

    protected void onDisable() {
        log.info("onDisable()");
        GuiGlobals.getInstance().releaseCursorEnabled((Object)this);
        for (Prompt prompt : this.activePrompts.values()) {
            prompt.detach();
        }
        this.activePrompts.clear();
    }

    protected Prompt getPrompt(EntityId target, boolean create) {
        Prompt result = this.activePrompts.get(target);
        if (result == null && create) {
            result = new Prompt(target);
            this.activePrompts.put(target, result);
        }
        return result;
    }

    protected void closePrompt(Prompt prompt) {
        this.activePrompts.values().remove(prompt);
        prompt.detach();
        if (this.activePrompts.isEmpty()) {
            this.sessionState.closePrompt();
        }
    }

    protected void updatePrompt(EntityId target, PromptType type, String promptText) {
        if (type == PromptType.Message) {
            ((MessageState)this.getState(MessageState.class)).addMessage(promptText, ColorRGBA.Pink);
            return;
        }
        Prompt prompt = this.getPrompt(target, true);
        prompt.updatePrompt(type, promptText);
        if (!this.isEnabled()) {
            this.sessionState.openPrompt();
        } else {
            prompt.attach();
        }
    }

    protected void updateOptions(EntityId target, List<Option<EntityId>> options) {
        Prompt prompt = this.getPrompt(target, true);
        prompt.updateOptions(options);
        if (!this.isEnabled()) {
            this.sessionState.openPrompt();
        } else {
            prompt.attach();
        }
    }

    private class SessionObserver
    extends DefaultGameSessionListener {
        private SessionObserver() {
        }

        public void setAvatar(EntityId avatar) {
            log.info("setAvatar(" + avatar + ")");
        }

        public void showPrompt(EntityId target, PromptType type, String prompt) {
            log.info("showPrompt(" + target + ", " + type + ", " + prompt + ")");
            UserPromptState.this.getApplication().enqueue(() -> UserPromptState.this.updatePrompt(target, type, prompt));
        }

        public void showOptions(EntityId target, List<Option<EntityId>> options) {
            log.info("showOptions(" + target + ", " + options + ")");
            UserPromptState.this.getApplication().enqueue(() -> UserPromptState.this.updateOptions(target, options));
        }
    }

    private class Prompt {
        EntityId target;
        PromptType type = PromptType.List;
        String promptText;
        List<Option<EntityId>> options;
        Container window;
        Label firstLineLabel;
        Label promptLabel;
        Container optionContainer;
        float scale = 1.0f;

        public Prompt(EntityId target) {
            this.target = target;
        }

        public boolean isVisible() {
            return this.window != null && this.window.getParent() != null;
        }

        protected String[] split(String s) {
            if (s == null) {
                return new String[]{null, null};
            }
            int split = Math.max(s.indexOf(10), s.indexOf(13));
            if (split < 0 || split >= s.length() - 1) {
                return new String[]{s, null};
            }
            String first = s.substring(0, split);
            String rest = s.substring(split + 1);
            return new String[]{first, rest};
        }

        protected void resetWindow() {
            if (this.window != null) {
                this.window.removeFromParent();
            }
            switch (this.type) {
                case Radial: 
                case List: {
                    this.createContextMenu();
                    break;
                }
                case Dialog: {
                    this.createDialog();
                }
            }
        }

        protected void createContextMenu() {
            ElementId base = new ElementId("contextMenu.window");
            this.window = new Container(base.child("container"));
            this.window.setLocalScale(this.scale);
            this.promptLabel = (Label)this.window.addChild((Node)new Label(this.promptText, base.child("title.label")), new Object[0]);
            if (this.optionContainer != null) {
                this.window.addChild((Node)this.optionContainer, new Object[0]);
            } else {
                this.optionContainer = (Container)this.window.addChild((Node)new Container(base.child("option.container")), new Object[0]);
            }
        }

        protected void createDialog() {
            ElementId base = new ElementId("dialog.window");
            this.window = new Container((GuiLayout)new BorderLayout(), base.child("container"));
            this.window.setInsets(new Insets3f(5.0f, 5.0f, 5.0f, 5.0f));
            this.window.setBorder((GuiComponent)new QuadBackgroundComponent(new ColorRGBA(0.01f, 0.1f, 0.01f, 0.9f)));
            this.window.setLocalScale(this.scale);
            String[] text = this.split(this.promptText);
            this.firstLineLabel = (Label)this.window.addChild((Node)new Label(text[0], base.child("heading.label")), new Object[]{BorderLayout.Position.North});
            this.promptLabel = (Label)this.window.addChild((Node)new Label(text[1], base.child("label")), new Object[]{BorderLayout.Position.Center});
            if (this.optionContainer != null) {
                this.window.addChild((Node)this.optionContainer, new Object[]{BorderLayout.Position.South});
            } else {
                this.optionContainer = (Container)this.window.addChild((Node)new Container(base.child("option.container")), new Object[]{BorderLayout.Position.South});
            }
        }

        protected void attach() {
            if (this.window.getParent() == null) {
                GuiGlobals.getInstance().getPopupState().showPopup((Spatial)this.window, PopupState.ClickMode.ConsumeAndClose, o -> UserPromptState.this.closePrompt(this), new ColorRGBA(1.0f, 0.0f, 0.0f, 0.0f));
            }
        }

        protected void detach() {
            this.window.removeFromParent();
        }

        protected void resetPosition() {
            this.window.setPreferredSize(null);
            Vector3f pref = this.window.getPreferredSize().mult(this.scale);
            Vector2f size = UserPromptState.this.gui.getGuiSize();
            switch (this.type) {
                case Radial: 
                case List: {
                    Vector3f loc = null;
                    if (UserPromptState.this.locationFunction != null) {
                        loc = (Vector3f)UserPromptState.this.locationFunction.apply(this.target);
                        loc.z = this.window.getLocalTranslation().z;
                    } else {
                        loc = new Vector3f(size.x * 0.5f - pref.x * 0.5f, size.y * 0.5f + pref.y * 0.5f, 100.0f);
                    }
                    log.info("Target location:" + loc);
                    this.window.setLocalTranslation(loc);
                    break;
                }
                case Dialog: {
                    this.window.setLocalTranslation(size.x * 0.1f, size.y * 0.9f, 100.0f);
                    float x = Math.max(size.x * 0.4f, pref.x);
                    float y = Math.max(size.y * 0.4f, pref.y);
                    this.window.setPreferredSize(new Vector3f(x / this.scale, y / this.scale, pref.z / this.scale));
                }
            }
        }

        public void updatePrompt(PromptType type, String promptText) {
            if (this.type != type || this.window == null) {
                this.type = type;
                this.resetWindow();
            }
            if (!Objects.equals(this.promptText, promptText)) {
                this.promptText = promptText;
                if (this.firstLineLabel != null) {
                    String[] text = this.split(promptText);
                    this.firstLineLabel.setText(text[0]);
                    this.promptLabel.setText(text[1]);
                } else {
                    this.promptLabel.setText(promptText);
                }
            }
            this.resetPosition();
        }

        public void updateOptions(List<Option<EntityId>> options) {
            if (this.window == null) {
                this.resetWindow();
            }
            this.options = options;
            this.optionContainer.clearChildren();
            for (Option<EntityId> option : options) {
                this.optionContainer.addChild((Node)new ActionButton((Action)new OptionAction(this, option)), new Object[0]);
            }
            if (this.type == PromptType.Dialog) {
                this.optionContainer.addChild((Node)new ActionButton((Action)new CloseAction(this, "Close")), new Object[0]);
            } else {
                this.optionContainer.addChild((Node)new ActionButton((Action)new CloseAction(this, "Cancel")), new Object[0]);
            }
            this.resetPosition();
        }
    }

    private class CloseAction
    extends Action {
        private Prompt prompt;

        public CloseAction(Prompt prompt, String name) {
            super(name);
            this.prompt = prompt;
        }

        public void execute(Button source) {
            UserPromptState.this.closePrompt(this.prompt);
        }
    }

    private class OptionAction
    extends Action {
        Prompt prompt;
        Option<EntityId> option;

        public OptionAction(Prompt prompt, Option<EntityId> option) {
            this.prompt = prompt;
            this.option = option;
            this.setName(option.getDisplay());
        }

        public void execute(Button source) {
            log.info("run:" + this.option);
            EntityId target = (EntityId)this.option.getTarget();
            if (target == null) {
                target = this.prompt.target;
            }
            UserPromptState.this.session.runAction(target, this.option.getActionId(), this.option.getParameters());
            UserPromptState.this.closePrompt(this.prompt);
        }
    }
}

