/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.bp;

import com.jme3.asset.AssetManager;
import com.jme3.bounding.BoundingVolume;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResults;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix4f;
import com.jme3.math.Ray;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.LayerComparator;
import com.simsilica.mathd.Vec3i;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildArea
extends Node {
    static Logger log = LoggerFactory.getLogger(BuildArea.class);

    public BuildArea(AssetManager assets) {
        super("buildArea");
        float size = 10.0f;
        float halfSize = size * 0.5f;
        this.setLocalScale(100.0f / size);
        Quad quad = new Quad(size, size){

            public int collideWith(Collidable other, Matrix4f worldMatrix, BoundingVolume worldBound, CollisionResults results) {
                return 0;
            }
        };
        Quad quad2 = new Quad(size, size){

            public int collideWith(Collidable other, Matrix4f worldMatrix, BoundingVolume worldBound, CollisionResults results) {
                if (!(other instanceof Ray)) {
                    return super.collideWith(other, worldMatrix, worldBound, results);
                }
                Vector3f dir = worldMatrix.multNormal(new Vector3f(0.0f, 0.0f, 1.0f), null);
                dir.normalizeLocal();
                if (dir.z > 0.0f) {
                    return 0;
                }
                return super.collideWith(other, worldMatrix, worldBound, results);
            }
        };
        quad2.scaleTextureCoordinates(new Vector2f(10.0f, 10.0f));
        Texture texture1 = assets.loadTexture("Interface/paper.jpg");
        Texture texture2 = assets.loadTexture("Interface/DrawnGrid64.png");
        texture2.setWrap(Texture.WrapMode.Repeat);
        Texture texture3 = assets.loadTexture("Interface/old-paper-flattened.png");
        Material mat1 = GuiGlobals.getInstance().createMaterial(texture1, true).getMaterial();
        mat1.setColor("Diffuse", new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f));
        mat1.setColor("Ambient", new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f));
        mat1.setBoolean("UseMaterialColors", true);
        Material mat2 = GuiGlobals.getInstance().createMaterial(texture2, true).getMaterial();
        mat2.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        mat2.setColor("Diffuse", new ColorRGBA(1.0f, 0.23529412f, 0.10980392f, 0.5f));
        mat2.setBoolean("UseMaterialColors", true);
        Material mat3 = GuiGlobals.getInstance().createMaterial(texture3, true).getMaterial();
        mat3.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        mat3.setColor("Diffuse", new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f));
        mat3.setColor("Ambient", new ColorRGBA(0.9f, 0.9f, 0.9f, 1.0f));
        mat3.setBoolean("UseMaterialColors", true);
        Geometry geom = new Geometry("platform.paper", (Mesh)quad);
        geom.setMaterial(mat1);
        geom.move(-halfSize, 0.0f, halfSize);
        geom.rotate(-1.5707964f, 0.0f, 0.0f);
        LayerComparator.setLayer((Spatial)geom, (int)2);
        this.attachChild((Spatial)geom);
        geom = geom.clone();
        geom.setMesh((Mesh)quad2);
        geom.setMaterial(mat2);
        geom.setQueueBucket(RenderQueue.Bucket.Transparent);
        LayerComparator.setLayer((Spatial)geom, (int)3);
        this.attachChild((Spatial)geom);
        geom = geom.clone();
        geom.setMesh((Mesh)quad);
        geom.setMaterial(mat3);
        geom.setLocalScale(1.4f);
        geom.setQueueBucket(RenderQueue.Bucket.Transparent);
        geom.move(-0.2f * size, -0.05f, 0.2f * size);
        LayerComparator.setLayer((Spatial)geom, (int)1);
        this.attachChild((Spatial)geom);
        for (int i = 0; i < 4; ++i) {
            geom = new Geometry("platform.back" + (i + 1), (Mesh)quad);
            geom.setMaterial(mat1);
            float angle = 1.5707964f * (float)i;
            geom.rotate(0.0f, 1.5707964f * (float)i, 0.0f);
            float x = (float)Math.sin(angle) * halfSize;
            float z = (float)Math.cos(angle) * halfSize;
            geom.move(-x, 0.0f, -z);
            geom.move(-z, 0.0f, x);
            this.attachChild((Spatial)geom);
            geom = geom.clone();
            geom.setMesh((Mesh)quad2);
            geom.setMaterial(mat2);
            geom.setQueueBucket(RenderQueue.Bucket.Transparent);
            LayerComparator.setLayer((Spatial)geom, (int)2);
            this.attachChild((Spatial)geom);
        }
    }

    public Vector3f toCell(Vector3f world) {
        Vector3f local = this.worldToLocal(world, null);
        local.addLocal(5.0f, 0.0f, 5.0f);
        return local;
    }

    public Vector3f toNormal(Vector3f normal) {
        Vector3f local = this.getWorldRotation().inverse().mult(normal);
        return local;
    }

    public Vec3i getCell(Vector3f world, Vector3f normal) {
        world = world.add(normal.mult(1.0E-4f));
        Vector3f local = this.worldToLocal(world, null);
        local.addLocal(5.0f, 0.0f, 5.0f);
        Vec3i result = new Vec3i((int)Math.floor(local.x), (int)Math.floor(local.y), (int)Math.floor(local.z));
        return result;
    }

    public Vector3f getOriginLocation() {
        Vector3f loc = new Vector3f(0.0f, 0.0f, 0.0f);
        loc.subtractLocal(5.0f, 0.0f, 5.0f);
        return loc;
    }

    public Vector3f getCellLocation(Vec3i cell, Vector3f offset) {
        Vector3f loc = new Vector3f((float)cell.x + offset.x, (float)cell.y + offset.y, (float)cell.z + offset.z);
        loc.subtractLocal(5.0f, 0.0f, 5.0f);
        return loc;
    }
}

