/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.bp;

import java.util.ArrayList;
import java.util.List;
import mythruna.client.ui.bp.Edit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditHistory {
    static Logger log = LoggerFactory.getLogger(EditHistory.class);
    private Entry top;
    private Entry bottom;
    private int size;
    private int maxSize;

    public EditHistory(int maxSize) {
        this.bottom = this.top = new Entry(null);
        this.maxSize = maxSize;
    }

    public void clear() {
        this.bottom = this.top = new Entry(null);
        this.size = 0;
    }

    public void addEdit(Edit edit) {
        log.info("Playing edit:" + edit);
        edit.doEdit();
        if (this.top.edit != null) {
            log.info("Replacing edit:" + this.top.edit);
        }
        Entry oldNext = this.top.next;
        this.top.edit = edit;
        this.top.next = new Entry(this.top);
        ++this.size;
        this.top = this.top.next;
        this.decrementSize(oldNext);
        int test = this.calculateSize();
        if (test != this.size) {
            log.warn("Stack size got out of sync somewhere");
            this.size = test;
        }
        while (this.size > this.maxSize) {
            if (this.bottom.next == null) {
                log.warn("Bottom of stack reached before running out of size");
                break;
            }
            this.bottom = this.bottom.next;
            this.bottom.previous = null;
            log.info("Trimming old edit:" + this.bottom.edit);
            --this.size;
        }
    }

    public int size() {
        return this.size;
    }

    public boolean canUndo() {
        return this.top.previous != null;
    }

    public boolean undo() {
        if (this.top.previous == null) {
            return false;
        }
        this.top = this.top.previous;
        log.info("Undo:" + this.top.edit);
        this.top.edit.undoEdit();
        return true;
    }

    public boolean canRedo() {
        return this.top.edit != null;
    }

    public boolean redo() {
        if (this.top.edit == null) {
            return false;
        }
        log.info("Redo:" + this.top.edit);
        this.top.edit.doEdit();
        if (this.top.next == null) {
            log.warn("Fell off end of redo stack somehow");
            this.top.next = new Entry(this.top);
            ++this.size;
        }
        this.top = this.top.next;
        return true;
    }

    protected int calculateSize() {
        int count = 0;
        Entry e = this.bottom;
        while (e != null) {
            if (e.edit != null) {
                ++count;
            }
            e = e.next;
        }
        return count;
    }

    protected void decrementSize(Entry entry) {
        while (entry != null) {
            --this.size;
            if (entry.edit != null) {
                log.info("Dropping old fork edit:" + entry.edit);
            }
            entry = entry.next;
        }
    }

    public List<Edit> getHistory(int count) {
        ArrayList<Edit> results = new ArrayList<Edit>();
        Entry entry = this.top;
        for (int i = 0; i < count && entry.previous != null; ++i) {
            entry = entry.previous;
            results.add(entry.edit);
        }
        return results;
    }

    public List<Edit> getPlayback(int count) {
        ArrayList<Edit> results = new ArrayList<Edit>();
        Entry entry = this.top;
        for (int i = 0; i < count && entry.edit != null; ++i) {
            results.add(entry.edit);
            if (entry.next == null) {
                log.warn("Edit stack consistency error getting playback buffer");
                continue;
            }
            entry = entry.next;
        }
        return results;
    }

    private class Entry {
        Entry previous;
        Entry next;
        Edit edit;

        public Entry(Entry previous) {
            this.previous = previous;
        }
    }
}

