/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.net.ChatSessionListener;
import com.simsilica.net.client.ChatClientService;
import com.simsilica.state.CommandConsoleState;
import com.simsilica.state.CommandEntry;
import com.simsilica.state.MessageState;
import mythruna.client.MainGameFunctions;
import mythruna.client.net.ConnectionState;
import mythruna.net.DefaultGameSessionListener;
import mythruna.net.GameSession;
import mythruna.net.GameSessionListener;
import mythruna.net.client.GameSessionClientService;
import mythruna.shell.ChatWho;
import mythruna.shell.CommandShell;
import mythruna.shell.Echo;
import mythruna.shell.Help;
import mythruna.shell.PassthroughCommand;
import mythruna.shell.ShellCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ShellState.class);
    private GameSessionClientService session;
    private CommandEntry originalCommandEntry;
    private ChatClientService chatService;
    private ChatObserver chatObserver = new ChatObserver();
    private ShellOutputObserver outputObserver = new ShellOutputObserver();
    private CommandShell clientShell = new CommandShell();

    public CommandShell getClientShell() {
        return this.clientShell;
    }

    protected void initialize(Application app) {
        this.session = ((ConnectionState)this.getState(ConnectionState.class, true)).getService(GameSessionClientService.class);
        this.chatService = ((ConnectionState)this.getState(ConnectionState.class)).getService(ChatClientService.class);
        this.session.addGameSessionListener((GameSessionListener)this.outputObserver);
        this.clientShell.setOutput(line -> ((MessageState)this.getState(MessageState.class)).addMessage(line, ColorRGBA.Cyan));
        this.clientShell.addCommand("help", (ShellCommand)new Help());
        this.clientShell.addCommand("echo", (ShellCommand)new Echo());
        this.clientShell.addCommand("who", (ShellCommand)new ChatWho(this.chatService));
        this.clientShell.addCommand("ping", (ShellCommand)new PassthroughCommand((GameSession)this.session, "ping", new String[]{"- Shows stats about this client connection."}));
        this.clientShell.put("connection", (Object)this.getState(ConnectionState.class));
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        CommandConsoleState console = (CommandConsoleState)this.getState(CommandConsoleState.class, true);
        this.originalCommandEntry = console.getCommandEntry();
        console.setCommandEntry((CommandEntry)new GameCommandEntry());
        this.chatService.addChatSessionListener((ChatSessionListener)this.chatObserver);
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.addDelegate(MainGameFunctions.F_CHAT_CONSOLE, (Object)console, "toggleConsole");
    }

    protected void onDisable() {
        CommandConsoleState console = (CommandConsoleState)this.getState(CommandConsoleState.class, true);
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.removeDelegate(MainGameFunctions.F_CHAT_CONSOLE, (Object)console, "toggleConsole");
        this.chatService.removeChatSessionListener((ChatSessionListener)this.chatObserver);
        console.setCommandEntry(this.originalCommandEntry);
    }

    private class ChatObserver
    implements ChatSessionListener {
        private ChatObserver() {
        }

        public void playerJoined(int clientId, String playerName) {
            log.info("playerJoined(" + clientId + ", " + playerName + ")");
            ((MessageState)ShellState.this.getState(MessageState.class)).addMessage(playerName + " has joined.", ColorRGBA.Yellow);
        }

        public void newMessage(int clientId, String playerName, String message) {
            log.info("newMessage(" + clientId + ", " + playerName + ", " + message + ")");
            ((MessageState)ShellState.this.getState(MessageState.class)).addMessage(playerName + ">" + message, ColorRGBA.White);
        }

        public void playerLeft(int clientId, String playerName) {
            log.info("playerLeft(" + clientId + ", " + playerName + ")");
            ((MessageState)ShellState.this.getState(MessageState.class)).addMessage(playerName + " has left.", ColorRGBA.Yellow);
        }
    }

    private class ShellOutputObserver
    extends DefaultGameSessionListener {
        private ShellOutputObserver() {
        }

        public void newConsoleMessage(String msg) {
            ((MessageState)ShellState.this.getState(MessageState.class)).addMessage(msg, ColorRGBA.Green);
        }
    }

    private class GameCommandEntry
    implements CommandEntry {
        private GameCommandEntry() {
        }

        public boolean runCommand(String cmd) {
            if (cmd.length() == 0) {
                return false;
            }
            switch (cmd.charAt(0)) {
                case '/': {
                    log.info("local cmd:" + cmd.substring(1));
                    try {
                        ShellState.this.clientShell.execute(cmd.substring(1));
                    }
                    catch (Exception e) {
                        log.error("Error running command:" + cmd, (Throwable)e);
                        ((MessageState)ShellState.this.getState(MessageState.class)).addMessage(e.getMessage(), ColorRGBA.Red);
                    }
                    return true;
                }
                case '~': {
                    log.info("remote cmd:" + cmd.substring(1));
                    ShellState.this.session.executeShell(cmd.substring(1));
                    return true;
                }
            }
            ShellState.this.chatService.sendMessage(cmd);
            return false;
        }
    }
}

