/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.font;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.util.IntMap;
import java.io.IOException;

public class BitmapCharacter
implements Savable,
Cloneable {
    private char c;
    private int x;
    private int y;
    private int width;
    private int height;
    private int xOffset;
    private int yOffset;
    private int xAdvance;
    private IntMap<Integer> kerning = new IntMap();
    private int page;

    public BitmapCharacter() {
    }

    public BitmapCharacter(char c) {
        this.c = c;
    }

    public BitmapCharacter clone() {
        try {
            BitmapCharacter result = (BitmapCharacter)super.clone();
            result.kerning = this.kerning.clone();
            return result;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(int offset) {
        this.xOffset = offset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(int offset) {
        this.yOffset = offset;
    }

    public int getXAdvance() {
        return this.xAdvance;
    }

    public void setXAdvance(int advance) {
        this.xAdvance = advance;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getPage() {
        return this.page;
    }

    public char getChar() {
        return this.c;
    }

    public void setChar(char c) {
        this.c = c;
    }

    public void addKerning(int second, int amount) {
        this.kerning.put(second, amount);
    }

    public int getKerning(int second) {
        Integer i = this.kerning.get(second);
        if (i == null) {
            return 0;
        }
        return i;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.c, "c", 0);
        oc.write(this.x, "x", 0);
        oc.write(this.y, "y", 0);
        oc.write(this.width, "width", 0);
        oc.write(this.height, "height", 0);
        oc.write(this.xOffset, "xOffset", 0);
        oc.write(this.yOffset, "yOffset", 0);
        oc.write(this.xAdvance, "xAdvance", 0);
        int[] seconds = new int[this.kerning.size()];
        int[] amounts = new int[seconds.length];
        int i = 0;
        for (IntMap.Entry<Integer> entry : this.kerning) {
            seconds[i] = entry.getKey();
            amounts[i] = entry.getValue();
            ++i;
        }
        oc.write(seconds, "seconds", (int[])null);
        oc.write(amounts, "amounts", (int[])null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.c = (char)ic.readInt("c", 0);
        this.x = ic.readInt("x", 0);
        this.y = ic.readInt("y", 0);
        this.width = ic.readInt("width", 0);
        this.height = ic.readInt("height", 0);
        this.xOffset = ic.readInt("xOffset", 0);
        this.yOffset = ic.readInt("yOffset", 0);
        this.xAdvance = ic.readInt("xAdvance", 0);
        int[] seconds = ic.readIntArray("seconds", null);
        int[] amounts = ic.readIntArray("amounts", null);
        for (int i = 0; i < seconds.length; ++i) {
            this.kerning.put(seconds[i], amounts[i]);
        }
    }
}

