/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.google.common.base.Function;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.Command;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.core.AbstractGuiControlListener;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiControlListener;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.event.CursorButtonEvent;
import com.simsilica.lemur.event.CursorEventControl;
import com.simsilica.lemur.event.CursorListener;
import com.simsilica.lemur.event.DefaultCursorListener;
import com.simsilica.lemur.event.PopupState;
import com.simsilica.lemur.list.SelectionModel;
import com.simsilica.lemur.style.Attributes;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.style.StyleAttribute;
import com.simsilica.lemur.style.StyleDefaults;
import com.simsilica.lemur.style.Styles;
import com.simsilica.lemur.value.DefaultValueRenderer;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Selector<T>
extends Panel {
    static Logger log = LoggerFactory.getLogger(Selector.class);
    public static final String ELEMENT_ID = "selector";
    public static final String CONTAINER_ID = "container";
    public static final String EXPANDER_ID = "down.button";
    private BorderLayout layout;
    private ValueRenderer<T> valueRenderer;
    private ListBox<T> listBox;
    private Panel view;
    private Button expander;
    private Container popup;
    private ClickListener clickListener = new ClickListener();
    private SelectListener selectListener = new SelectListener();
    private ReshapeListener reshapeListener = new ReshapeListener();
    private boolean expanded;
    private int maximumVisibleItems;
    private VersionedReference<Integer> selectionRef;
    private VersionedHolder<T> selectedItem = new VersionedHolder();
    private VersionedReference<List<T>> modelRef;

    public Selector() {
        this(true, new VersionedList(), null, new SelectionModel(), new ElementId(ELEMENT_ID), null);
    }

    public Selector(VersionedList<T> model) {
        this(true, model, null, new SelectionModel(), new ElementId(ELEMENT_ID), null);
    }

    public Selector(VersionedList<T> model, Function<? super T, String> stringTransform) {
        this(true, model, new DefaultValueRenderer<T>(new ElementId(ELEMENT_ID).child("item"), null, stringTransform), new SelectionModel(), new ElementId(ELEMENT_ID), null);
    }

    public Selector(VersionedList<T> model, ValueRenderer<T> renderer) {
        this(true, model, renderer, new SelectionModel(), new ElementId(ELEMENT_ID), null);
    }

    public Selector(VersionedList<T> model, ValueRenderer<T> renderer, String style) {
        this(true, model, renderer, new SelectionModel(), new ElementId(ELEMENT_ID), style);
    }

    public Selector(VersionedList<T> model, String style) {
        this(true, model, null, new SelectionModel(), new ElementId(ELEMENT_ID), style);
    }

    public Selector(VersionedList<T> model, ElementId elementId) {
        this(true, model, null, new SelectionModel(), elementId, null);
    }

    public Selector(VersionedList<T> model, ElementId elementId, String style) {
        this(true, model, null, new SelectionModel(), elementId, style);
    }

    public Selector(VersionedList<T> model, ValueRenderer<T> renderer, ElementId elementId, String style) {
        this(true, model, renderer, new SelectionModel(), elementId, style);
    }

    protected Selector(boolean applyStyles, VersionedList<T> model, ValueRenderer<T> valueRenderer, SelectionModel selection, ElementId elementId, String style) {
        super(false, elementId.child(CONTAINER_ID), style);
        if (valueRenderer == null) {
            valueRenderer = new DefaultValueRenderer(elementId.child("item"), style);
        } else {
            valueRenderer.configureStyle(elementId.child("item"), style);
        }
        this.valueRenderer = valueRenderer;
        this.listBox = new ListBox<T>(model, valueRenderer, elementId.child("list"), style);
        this.listBox.setSelectionModel(selection);
        this.listBox.addClickCommands(this.selectListener);
        this.modelRef = this.listBox.getModel().createReference();
        this.selectionRef = this.listBox.getSelectionModel().createSelectionReference();
        this.boundSelection();
        this.selectedItem.setObject(this.getSelectedListValue());
        this.layout = new BorderLayout();
        ((GuiControl)this.getControl(GuiControl.class)).setLayout((GuiLayout)this.layout);
        if (applyStyles) {
            Styles styles = GuiGlobals.getInstance().getStyles();
            styles.applyStyles((Object)this, this.getElementId(), style);
        }
        this.popup = new Container((GuiLayout)new BorderLayout(), elementId.child("popup"), style);
        this.popup.addChild(this.listBox, new Object[]{BorderLayout.Position.Center});
        this.expander = new Button(null, true, elementId.child(EXPANDER_ID), style);
        this.expander.addClickCommands((Command)this.clickListener);
        this.layout.addChild(BorderLayout.Position.East, (Node)this.expander);
        this.resetView();
    }

    @StyleDefaults(value="selector")
    public static void initializeDefaultStyles(Styles styles, Attributes attrs) {
        ElementId parent = new ElementId(ELEMENT_ID);
        styles.getSelector(parent.child(EXPANDER_ID), null).set("text", (Object)"v", false);
    }

    public VersionedList<T> getModel() {
        return this.listBox.getModel();
    }

    public void setModel(VersionedList<T> model) {
        this.listBox.setModel(model);
        this.modelRef = model.createReference();
        this.boundSelection();
    }

    public void setSelectionModel(SelectionModel selectionModel) {
        this.listBox.setSelectionModel(selectionModel);
        this.selectionRef = this.listBox.getSelectionModel().createSelectionReference();
        this.boundSelection();
    }

    public SelectionModel getSelectionModel() {
        return this.listBox.getSelectionModel();
    }

    public void setValueRenderer(ValueRenderer<T> valueRenderer) {
        if (this.valueRenderer == valueRenderer) {
            return;
        }
        this.valueRenderer = valueRenderer;
        this.listBox.setCellRenderer(valueRenderer);
        this.resetView();
    }

    public ValueRenderer<T> getValueRenderer() {
        return this.valueRenderer;
    }

    public ListBox getListBox() {
        return this.listBox;
    }

    public Button getExpanderButton() {
        return this.expander;
    }

    public Container getPopupContainer() {
        return this.popup;
    }

    @StyleAttribute(value="maximumVisibleItems", lookupDefault=false)
    public void setMaximumVisibleItems(int count) {
        if (this.maximumVisibleItems == count) {
            return;
        }
        this.maximumVisibleItems = count;
    }

    public int getMaximumVisibleItems() {
        return this.maximumVisibleItems;
    }

    public void setSelectedItem(T item) {
        int i = this.listBox.getModel().indexOf(item);
        if (i < 0) {
            log.warn("No item in list:" + item);
            this.listBox.getSelectionModel().clear();
        } else {
            this.listBox.getSelectionModel().setSelection(i);
            this.updateSelection();
        }
    }

    public T getSelectedItem() {
        this.updateSelection();
        return (T)this.selectedItem.getObject();
    }

    public VersionedReference<T> createSelectedItemReference() {
        return this.selectedItem.createReference();
    }

    protected void boundSelection() {
        Integer i = this.listBox.getSelectionModel().getSelection();
        if (i == null) {
            if (!this.listBox.getModel().isEmpty()) {
                this.listBox.getSelectionModel().setSelection(0);
            }
        } else if (i >= this.listBox.getModel().size()) {
            this.listBox.getSelectionModel().setSelection(this.listBox.getModel().size() - 1);
        }
    }

    protected void updateSelection() {
        if (this.selectionRef.update() || this.modelRef.needsUpdate()) {
            Integer i = (Integer)this.selectionRef.get();
            if (i == null) {
                this.selectedItem.setObject(null);
            } else {
                i = Math.min(i, this.listBox.getModel().size() - 1);
                i = Math.max(i, 0);
                this.selectedItem.setObject(this.listBox.getModel().get(i));
            }
            this.resetView();
        }
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.modelRef.update()) {
            this.boundSelection();
            if (!this.selectionRef.needsUpdate()) {
                Object item = null;
                Integer i = (Integer)this.selectionRef.get();
                if (i != null) {
                    item = this.listBox.getModel().get(i);
                }
                if (!Objects.equals(item, this.selectedItem.getObject())) {
                    int newIndex = this.listBox.getModel().indexOf(this.selectedItem.getObject());
                    if (newIndex < 0) {
                        this.listBox.getSelectionModel().clear();
                        this.listBox.getSelectionModel().setSelection(i);
                    } else {
                        this.listBox.getSelectionModel().setSelection(newIndex);
                    }
                }
            }
        }
        this.updateSelection();
    }

    public void setExpanded(boolean b) {
        if (this.expanded == b) {
            return;
        }
        if (b) {
            this.expand();
        } else {
            this.collapse();
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    protected void resetView() {
        Panel newView = this.valueRenderer.getView(this.getSelectedListValue(), false, this.view);
        if (newView != this.view) {
            CursorEventControl.addListenersToSpatial((Spatial)newView, (CursorListener[])new CursorListener[]{this.clickListener});
            CursorEventControl.removeListenersFromSpatial((Spatial)this.view, (CursorListener[])new CursorListener[]{this.clickListener});
            this.view = newView;
            this.layout.addChild((Node)this.view, new Object[]{BorderLayout.Position.Center});
        }
    }

    protected T getSelectedListValue() {
        Integer i = this.listBox.getSelectionModel().getSelection();
        if (i == null) {
            return null;
        }
        if (i >= this.listBox.getModel().size()) {
            i = 0;
        }
        return this.listBox.getModel().get(i);
    }

    protected int calculateListSize() {
        int size = this.listBox.getModel().size();
        if (this.maximumVisibleItems != 0) {
            size = Math.min(this.maximumVisibleItems, size);
        }
        Vector2f guiSize = GuiGlobals.getInstance().getPopupState().getGuiSize();
        int maxSize = (int)(guiSize.y / this.view.getSize().y);
        maxSize = Math.max(maxSize, 3);
        size = Math.min(size, maxSize);
        return size;
    }

    protected Vector3f calculatePopupLocation(Vector3f loc) {
        Vector3f pref = this.popup.getPreferredSize();
        Vector2f guiSize = GuiGlobals.getInstance().getPopupState().getGuiSize();
        loc.x = Math.min(loc.x, guiSize.x - pref.x);
        loc.y = Math.max(loc.y, pref.y);
        return loc;
    }

    protected void expand() {
        this.listBox.setVisibleItems(this.calculateListSize());
        this.popup.setLocalTranslation(this.calculatePopupLocation(this.getWorldTranslation().clone()));
        ((GuiControl)this.popup.getControl(GuiControl.class)).addListener((GuiControlListener)this.reshapeListener);
        GuiGlobals.getInstance().getPopupState().showPopup((Spatial)this.popup, (Command)new Command<PopupState>(){

            public void execute(PopupState state) {
                Selector.this.collapse();
            }
        });
        this.expanded = true;
    }

    protected void collapse() {
        PopupState state = GuiGlobals.getInstance().getPopupState();
        if (state.isPopup((Spatial)this.popup)) {
            state.closePopup((Spatial)this.popup);
        }
        ((GuiControl)this.popup.getControl(GuiControl.class)).removeListener((GuiControlListener)this.reshapeListener);
        this.expanded = false;
    }

    private class ReshapeListener
    extends AbstractGuiControlListener {
        private ReshapeListener() {
        }

        public void reshape(GuiControl source, Vector3f pos, Vector3f size) {
            Vector3f world = Selector.this.popup.getLocalTranslation();
            Vector3f loc = Selector.this.calculatePopupLocation(world);
            Selector.this.popup.setLocalTranslation(loc);
        }
    }

    private class SelectListener
    implements Command<ListBox> {
        private SelectListener() {
        }

        public void execute(ListBox list) {
            Selector.this.collapse();
        }
    }

    private class ClickListener
    extends DefaultCursorListener
    implements Command<Button> {
        private ClickListener() {
        }

        protected void click(CursorButtonEvent event, Spatial target, Spatial capture) {
            Selector.this.expand();
        }

        public void execute(Button button) {
            Selector.this.expand();
        }
    }
}

