/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.phys;

import com.simsilica.mathd.Rayd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.phys.Collider;
import com.simsilica.mblock.phys.RayHit;
import com.simsilica.mworld.BlockIterator;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockColliderIterator
implements Iterator<BlockIterator.Intersection> {
    static Logger log = LoggerFactory.getLogger(BlockColliderIterator.class);
    private BlockIterator delegate;
    private Collider[] colliders;
    private BlockIterator.Intersection next;

    public BlockColliderIterator(BlockIterator delegate, Collider[] colliders) {
        this.delegate = delegate;
        this.colliders = colliders;
    }

    private Collider getCollider(int type) {
        if (type < 0) {
            return null;
        }
        return this.colliders[type];
    }

    protected void fetch() {
        if (this.next != null) {
            return;
        }
        while (this.delegate.hasNext()) {
            this.next = this.delegate.next();
            Collider collider = this.getCollider(this.next.getType());
            if (collider == null) {
                log.info("no collider for:" + this.next);
                continue;
            }
            Rayd ray = this.delegate.getRay();
            Vec3d origin = ray.getOrigin();
            Vec3i blockIntersect = this.next.getBlock();
            Vec3d rayOrigin = new Vec3d(origin.x - (double)blockIntersect.x, origin.y - (double)blockIntersect.y, origin.z - (double)blockIntersect.z);
            RayHit hit = collider.getHit(rayOrigin, ray.getDirection(), 255, null);
            if (hit == null) continue;
            Vec3d hitWorld = hit.point.add(blockIntersect);
            this.next = new BlockIterator.Intersection(hitWorld, this.next.getBlock(), this.next.getType(), this.next.getCellValue(), hit.normal);
            break;
        }
    }

    @Override
    public boolean hasNext() {
        this.fetch();
        return this.next != null;
    }

    @Override
    public BlockIterator.Intersection next() {
        this.fetch();
        BlockIterator.Intersection result = this.next;
        this.next = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported on intersectors.");
    }
}

