/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.filter;

import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import java.util.Arrays;

public class OrFilter<T extends EntityComponent>
implements ComponentFilter<T> {
    private Class<T> type;
    private ComponentFilter<? super T>[] operands;

    public OrFilter() {
    }

    public OrFilter(Class<T> type, ComponentFilter<? super T> ... operands) {
        this.type = type;
        this.operands = operands;
    }

    public static <T extends EntityComponent> OrFilter<T> create(Class<T> type, ComponentFilter<? super T> ... operands) {
        return new OrFilter<T>(type, operands);
    }

    public ComponentFilter<? super T>[] getOperands() {
        return this.operands;
    }

    @Override
    public Class<T> getComponentType() {
        return this.type;
    }

    @Override
    public boolean evaluate(EntityComponent c) {
        if (!this.type.isInstance(c)) {
            return false;
        }
        if (this.operands == null) {
            return true;
        }
        for (ComponentFilter<T> componentFilter : this.operands) {
            if (!componentFilter.evaluate(c)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "OrFilter[" + Arrays.asList(this.operands) + "]";
    }
}

