/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock;

import com.google.common.base.MoreObjects;
import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.ColliderType;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.geom.BlockFactory;
import com.simsilica.mblock.geom.BoundaryShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockType
implements Serializable {
    static final long serialVersionUID = 42L;
    public static final ColliderType DEFAULT_COLLIDER = new ColliderType("cube", -1);
    static Logger log = LoggerFactory.getLogger(BlockType.class);
    private BlockName name;
    private BlockFactory factory;
    private ColliderType colliderType;
    private int group;
    private short light;
    private transient BoundaryShape[] shapes;
    private transient double[] transparency;
    private transient boolean anyTransparent;
    private transient boolean[] solid;
    private transient boolean allSolid;

    public BlockType(BlockName name, BlockFactory factory) {
        this(name, 0, 0, factory, DEFAULT_COLLIDER);
    }

    public BlockType(BlockName name, BlockFactory factory, ColliderType colliderType) {
        this(name, 0, 0, factory, colliderType);
    }

    public BlockType(BlockName name, int group, BlockFactory factory) {
        this(name, group, 0, factory, DEFAULT_COLLIDER);
    }

    public BlockType(BlockName name, int group, BlockFactory factory, ColliderType colliderType) {
        this(name, group, 0, factory, colliderType);
    }

    public BlockType(BlockName name, int group, short light, BlockFactory factory) {
        this(name, group, light, factory, DEFAULT_COLLIDER);
    }

    public BlockType(BlockName name, int group, short light, BlockFactory factory, ColliderType colliderType) {
        this.name = name;
        this.group = group;
        this.light = light;
        this.factory = factory;
        this.colliderType = colliderType;
        this.cacheSideData();
    }

    public void cacheSideData() {
        this.anyTransparent = this.factory.isTransparent();
        this.allSolid = this.factory.isSolid();
        int size = Direction.values().length;
        this.shapes = new BoundaryShape[size];
        this.transparency = new double[size];
        this.solid = new boolean[size];
        for (Direction dir : Direction.values()) {
            int index = dir.ordinal();
            this.shapes[index] = this.factory.getShape(dir);
            this.transparency[index] = this.factory.getTransparency(dir);
            this.solid[index] = this.factory.isSolid(dir);
        }
    }

    public void setName(BlockName name) {
        this.name = name;
    }

    public final BlockName getName() {
        return this.name;
    }

    public void setFactory(BlockFactory factory) {
        this.factory = factory;
        this.cacheSideData();
    }

    public final BlockFactory getFactory() {
        return this.factory;
    }

    public void setColliderType(ColliderType colliderType) {
        this.colliderType = colliderType;
    }

    public final ColliderType getColliderType() {
        return this.colliderType;
    }

    public final BoundaryShape getShape(Direction dir) {
        return this.shapes[dir.ordinal()];
    }

    public final boolean isSolid(Direction dir) {
        return this.solid[dir.ordinal()];
    }

    public final boolean isSolid() {
        return this.allSolid;
    }

    public final double getTransparency(Direction dir) {
        return this.transparency[dir.ordinal()];
    }

    public final boolean isTransparent() {
        return this.anyTransparent;
    }

    public void setTransparencyGroup(int group) {
        this.group = group;
    }

    public final int getTransparencyGroup() {
        return this.group;
    }

    public void setLight(short light) {
        this.light = light;
    }

    public final short getLight() {
        return this.light;
    }

    public BlockType createRotation(int dirDelta) {
        BlockType result = new BlockType(this.name.rotate(dirDelta), this.group, this.light, this.factory.rotate(dirDelta));
        if (this.colliderType != null) {
            result.colliderType = this.colliderType.rotate(dirDelta);
        }
        result.cacheSideData();
        return result;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.cacheSideData();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        BlockType other = (BlockType)o;
        if (other.group != this.group) {
            return false;
        }
        if (other.light != this.light) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.factory, other.factory)) {
            return false;
        }
        return Objects.equals(this.colliderType, other.colliderType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.factory, this.colliderType, this.group, this.light);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("name", (Object)this.name).add("factory", (Object)this.factory).add("colliderType", (Object)this.colliderType).add("transparencyGroup", this.group).add("light", (Object)Integer.toHexString(this.light)).toString();
    }
}

