/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.geom;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.geom.BlockFactory;
import com.simsilica.mblock.geom.BoundaryShape;
import com.simsilica.mblock.geom.BoundaryShapes;
import com.simsilica.mblock.geom.DefaultPartFactory;
import com.simsilica.mblock.geom.GeomPartBuffer;
import com.simsilica.mblock.geom.GeomUtils;
import com.simsilica.mblock.geom.MaterialType;
import com.simsilica.mblock.geom.PartFactory;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBlockFactory
implements BlockFactory {
    static final long serialVersionUID = 42L;
    static Logger log = LoggerFactory.getLogger(DefaultBlockFactory.class);
    public static boolean debug = false;
    private final PartFactory[] dirParts;
    private PartFactory internalParts;
    private final boolean allSolid;
    private final boolean[] solid;
    private final double[] transparency;
    private final boolean isTransparent;
    private final double volume;
    private final Vec3d min;
    private final Vec3d max;

    public DefaultBlockFactory(PartFactory[] dirParts, PartFactory internalParts, boolean[] solid, double[] transparency, double volume, Vec3d min, Vec3d max) {
        if (transparency != null && transparency.length != 6) {
            throw new IllegalArgumentException("Transparency array should be 6 elements");
        }
        if (solid != null && solid.length != 6) {
            throw new IllegalArgumentException("Solid array should be 6 elements");
        }
        this.dirParts = dirParts;
        this.internalParts = internalParts;
        this.solid = solid;
        this.transparency = transparency;
        this.volume = volume;
        this.min = min;
        this.max = max;
        boolean all = true;
        if (solid != null) {
            for (boolean b : solid) {
                if (b) continue;
                all = false;
            }
        }
        this.allSolid = all;
        this.isTransparent = transparency == null ? false : transparency[0] + transparency[1] + transparency[2] + transparency[3] + transparency[4] + transparency[5] != 0.0;
    }

    public static DefaultBlockFactory createCube(double transparency, PartFactory ... dirParts) {
        if (dirParts.length != Direction.values().length) {
            throw new IllegalArgumentException("Incorrect number of part factories:" + dirParts.length + ", requires:" + Direction.values().length);
        }
        double[] trans = null;
        if (transparency != 0.0) {
            trans = new double[]{transparency, transparency, transparency, transparency, transparency, transparency};
        }
        return new DefaultBlockFactory(dirParts, null, null, trans, 1.0, new Vec3d(0.0, 0.0, 0.0), new Vec3d(1.0, 1.0, 1.0));
    }

    public static DefaultBlockFactory createCube(double transparency, MaterialType materialType) {
        return DefaultBlockFactory.createCube(transparency, DefaultPartFactory.createCubeFace(materialType, Direction.North), DefaultPartFactory.createCubeFace(materialType, Direction.South), DefaultPartFactory.createCubeFace(materialType, Direction.East), DefaultPartFactory.createCubeFace(materialType, Direction.West), DefaultPartFactory.createCubeFace(materialType, Direction.Up), DefaultPartFactory.createCubeFace(materialType, Direction.Down));
    }

    public static DefaultBlockFactory createCube(double transparency, MaterialType ... materialTypes) {
        return DefaultBlockFactory.createCube(transparency, DefaultPartFactory.createCubeFace(materialTypes[Direction.North.ordinal()], Direction.North), DefaultPartFactory.createCubeFace(materialTypes[Direction.South.ordinal()], Direction.South), DefaultPartFactory.createCubeFace(materialTypes[Direction.East.ordinal()], Direction.East), DefaultPartFactory.createCubeFace(materialTypes[Direction.West.ordinal()], Direction.West), DefaultPartFactory.createCubeFace(materialTypes[Direction.Up.ordinal()], Direction.Up), DefaultPartFactory.createCubeFace(materialTypes[Direction.Down.ordinal()], Direction.Down));
    }

    public static DefaultBlockFactory create(PartFactory[] dirParts, PartFactory internalParts) {
        return DefaultBlockFactory.create(dirParts, internalParts, null);
    }

    public static DefaultBlockFactory create(PartFactory[] dirParts, PartFactory internalParts, double[] transparency) {
        double[] dArray;
        if (dirParts == null && internalParts == null) {
            throw new IllegalArgumentException("dirParts and internalParts cannot both be null");
        }
        boolean[] solid = new boolean[Direction.values().length];
        if (transparency == null) {
            double[] dArray2 = new double[6];
            dArray2[0] = 1.0;
            dArray2[1] = 1.0;
            dArray2[2] = 1.0;
            dArray2[3] = 1.0;
            dArray2[4] = 1.0;
            dArray = dArray2;
            dArray2[5] = 1.0;
        } else {
            dArray = null;
        }
        double[] newTrans = dArray;
        Vec3d min = new Vec3d(100.0, 100.0, 100.0);
        Vec3d max = new Vec3d(-100.0, -100.0, -100.0);
        if (dirParts != null) {
            for (Direction dir : Direction.values()) {
                PartFactory face = dirParts[dir.ordinal()];
                if (face == null) continue;
                min.minLocal(face.getMin());
                max.maxLocal(face.getMax());
                BoundaryShape shape = face.getBoundaryShape();
                double area = shape.getArea();
                if (area >= 1.0) {
                    solid[dir.ordinal()] = true;
                }
                if (newTrans == null) continue;
                double t = Math.max(0.0, 1.0 - area);
                int d = dir.ordinal();
                newTrans[d] = Math.min(newTrans[d], t);
            }
            int count = 0;
            for (double d : newTrans) {
                if (!(d > 0.0)) continue;
                ++count;
            }
            if (count == 0) {
                newTrans = null;
            }
        }
        if (internalParts != null) {
            min.minLocal(internalParts.getMin());
            max.maxLocal(internalParts.getMax());
        }
        double x = max.x - min.x;
        double y = max.y - min.y;
        double z = max.z - min.z;
        double volume = x * y * z;
        return new DefaultBlockFactory(dirParts, internalParts, solid, newTrans != null ? newTrans : transparency, volume, min, max);
    }

    public PartFactory[] getDirParts() {
        return this.dirParts;
    }

    public void setInternalParts(PartFactory internalParts) {
        this.internalParts = internalParts;
    }

    public PartFactory getInternalParts() {
        return this.internalParts;
    }

    @Override
    public int addGeometryToBuffer(GeomPartBuffer buffer, int i, int j, int k, int xWorld, int yWorld, int zWorld, int sideMask, CellData cells, BlockType type) {
        int count = 0;
        if (this.dirParts != null) {
            for (Direction dir : Direction.values()) {
                PartFactory part = this.dirParts[dir.ordinal()];
                if (part == null || (sideMask & dir.getBitMask()) == 0) continue;
                if (debug) {
                    log.info("add part for:" + (Object)((Object)dir));
                }
                count += part.addParts(buffer, i, j, k, xWorld, yWorld, zWorld, type, dir);
            }
        }
        if (this.internalParts != null) {
            count += this.internalParts.addParts(buffer, i, j, k, xWorld, yWorld, zWorld, type, null);
        }
        return count;
    }

    @Override
    public final BoundaryShape getShape(Direction dir) {
        PartFactory factory;
        PartFactory partFactory = factory = this.dirParts == null ? null : this.dirParts[dir.ordinal()];
        if (factory == null) {
            return BoundaryShapes.NULL_SHAPE;
        }
        return factory.getBoundaryShape();
    }

    @Override
    public final boolean isSolid(Direction dir) {
        return this.solid == null ? true : this.solid[dir.ordinal()];
    }

    @Override
    public final boolean isSolid() {
        return this.allSolid;
    }

    @Override
    public final double getTransparency(Direction dir) {
        return this.transparency == null ? 0.0 : this.transparency[dir.ordinal()];
    }

    @Override
    public final boolean isTransparent() {
        return this.isTransparent;
    }

    @Override
    public final double getVolume() {
        return this.volume;
    }

    @Override
    public final Vec3d getMin() {
        return this.min;
    }

    @Override
    public final Vec3d getMax() {
        return this.max;
    }

    @Override
    public BlockFactory rotate(int dirDelta) {
        if (dirDelta < 0 || dirDelta > 3) {
            throw new IllegalArgumentException("dirDelta is out of bounds:" + dirDelta);
        }
        PartFactory[] newDirParts = null;
        if (this.dirParts != null) {
            newDirParts = new PartFactory[this.dirParts.length];
            for (int i = 0; i < newDirParts.length; ++i) {
                if (this.dirParts[i] == null) continue;
                Direction dir = Direction.values()[i];
                if (i < 4) {
                    newDirParts[GeomUtils.rotateIndex((int)i, (int)dirDelta)] = this.dirParts[i].rotate(dir, dirDelta);
                    continue;
                }
                newDirParts[i] = this.dirParts[i].rotate(dir, dirDelta);
            }
        }
        PartFactory newInternalParts = null;
        if (this.internalParts != null) {
            newInternalParts = this.internalParts.rotate(null, dirDelta);
        }
        boolean[] newSolid = null;
        if (this.solid != null) {
            newSolid = new boolean[6];
            for (int i = 0; i < 6; ++i) {
                if (i < 4) {
                    newSolid[GeomUtils.rotateIndex((int)i, (int)dirDelta)] = this.solid[i];
                    continue;
                }
                newSolid[i] = this.solid[i];
            }
        }
        double[] newTransparency = null;
        if (this.transparency != null) {
            newTransparency = new double[6];
            for (int i = 0; i < 6; ++i) {
                if (i < 4) {
                    newTransparency[GeomUtils.rotateIndex((int)i, (int)dirDelta)] = this.transparency[i];
                    continue;
                }
                newTransparency[i] = this.transparency[i];
            }
        }
        Vec3d v1 = GeomUtils.rotatePos(this.min, dirDelta);
        Vec3d v2 = GeomUtils.rotatePos(this.max, dirDelta);
        Vec3d newMin = new Vec3d(v1).minLocal(v2);
        Vec3d newMax = new Vec3d(v1).maxLocal(v2);
        return new DefaultBlockFactory(newDirParts, newInternalParts, newSolid, newTransparency, this.volume, newMin, newMax);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        DefaultBlockFactory other = (DefaultBlockFactory)o;
        if (other.allSolid != this.allSolid) {
            return false;
        }
        if (other.isTransparent != this.isTransparent) {
            return false;
        }
        if (other.volume != this.volume) {
            return false;
        }
        if (!Objects.equals(this.internalParts, other.internalParts)) {
            return false;
        }
        if (!Objects.equals(this.min, other.min)) {
            return false;
        }
        if (!Objects.equals(this.max, other.max)) {
            return false;
        }
        if (!Arrays.equals(this.dirParts, other.dirParts)) {
            return false;
        }
        if (!Arrays.equals(this.solid, other.solid)) {
            return false;
        }
        return Arrays.equals(this.transparency, other.transparency);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allSolid, this.isTransparent, this.volume, this.internalParts, this.min, this.max, Arrays.hashCode(this.dirParts), Arrays.hashCode(this.solid), Arrays.hashCode(this.transparency));
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("dirParts", this.dirParts != null ? Arrays.asList(this.dirParts) : null).add("internalParts", (Object)this.internalParts).add("min", (Object)this.min).add("max", (Object)this.max).toString();
    }
}

