/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.crig.es;

import com.simsilica.crig.es.LayerConfig;
import com.simsilica.crig.es.MixConfig;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityId;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnimationConfig
implements EntityComponent {
    static Logger log = LoggerFactory.getLogger(AnimationConfig.class);
    private EntityId target;
    private LayerConfig[] layers;
    private MixConfig[] mixes;

    protected AnimationConfig() {
    }

    public AnimationConfig(EntityId target, Object ... config) {
        this.target = target;
        int layerCount = 0;
        int mixCount = 0;
        for (Object o : config) {
            if (o instanceof LayerConfig) {
                ++layerCount;
                continue;
            }
            if (!(o instanceof MixConfig)) continue;
            ++mixCount;
        }
        this.layers = new LayerConfig[layerCount];
        this.mixes = new MixConfig[mixCount];
        layerCount = 0;
        mixCount = 0;
        for (Object o : config) {
            if (o instanceof LayerConfig) {
                this.layers[layerCount++] = (LayerConfig)o;
                continue;
            }
            if (!(o instanceof MixConfig)) continue;
            this.mixes[mixCount++] = (MixConfig)o;
        }
    }

    public EntityId getTarget() {
        return this.target;
    }

    public LayerConfig[] getLayers() {
        return this.layers;
    }

    public MixConfig[] getMixes() {
        return this.mixes;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[layers:" + Arrays.asList(this.layers) + ", mixes:" + Arrays.asList(this.mixes) + "]";
    }
}

