/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.net;

import com.jme3.network.Message;
import com.jme3.network.MessageConnection;
import com.jme3.network.MessageListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageDelegator<S extends MessageConnection>
implements MessageListener<S> {
    static Logger log = LoggerFactory.getLogger(AbstractMessageDelegator.class);
    private Class delegateType;
    private Map<Class, Method> methods = new HashMap<Class, Method>();
    private Class[] messageTypes;

    protected AbstractMessageDelegator(Class delegateType, boolean automap) {
        this.delegateType = delegateType;
        if (automap) {
            this.automap();
        }
    }

    public Class[] getMessageTypes() {
        if (this.messageTypes == null) {
            this.messageTypes = this.methods.keySet().toArray(new Class[this.methods.size()]);
        }
        return this.messageTypes;
    }

    protected boolean isValidMethod(Method m, Class messageType) {
        int messageIndex;
        Class<?>[] parms;
        if (log.isTraceEnabled()) {
            log.trace("isValidMethod(" + m + ", " + messageType + ")");
        }
        if ((parms = m.getParameterTypes()).length != 2 && parms.length != 1) {
            log.trace("Parameter count is not 1 or 2");
            return false;
        }
        int connectionIndex = parms.length > 1 ? 0 : -1;
        int n = messageIndex = parms.length > 1 ? 1 : 0;
        if (connectionIndex > 0 && !MessageConnection.class.isAssignableFrom(parms[connectionIndex])) {
            log.trace("First paramter is not a MessageConnection or subclass.");
            return false;
        }
        if (messageType == null && !Message.class.isAssignableFrom(parms[messageIndex])) {
            log.trace("Second paramter is not a Message or subclass.");
            return false;
        }
        if (messageType != null && !parms[messageIndex].isAssignableFrom(messageType)) {
            log.trace("Second paramter is not a " + messageType);
            return false;
        }
        return true;
    }

    protected Class getMessageType(Method m) {
        Class<?>[] parms = m.getParameterTypes();
        return parms[parms.length - 1];
    }

    protected Method findDelegate(String name, Class messageType) {
        for (Method m : this.delegateType.getDeclaredMethods()) {
            if (!m.getName().equals(name) || !this.isValidMethod(m, messageType)) continue;
            return m;
        }
        return null;
    }

    protected boolean allowName(String name) {
        return true;
    }

    public final AbstractMessageDelegator<S> automap() {
        this.map((Set<String>)null);
        if (this.methods.isEmpty()) {
            throw new RuntimeException("No message handling methods found for class:" + this.delegateType);
        }
        return this;
    }

    public AbstractMessageDelegator<S> map(String ... methodNames) {
        HashSet<String> names = new HashSet<String>(Arrays.asList(methodNames));
        this.map(names);
        return this;
    }

    protected void map(Set<String> constraints) {
        if (log.isTraceEnabled()) {
            log.trace("map(" + constraints);
        }
        for (Method m : this.delegateType.getDeclaredMethods()) {
            if (log.isTraceEnabled()) {
                log.trace("Checking method:" + m);
            }
            if (constraints == null && !this.allowName(m.getName())) {
                log.trace("Name is not allowed.");
                continue;
            }
            if (constraints != null && !constraints.contains(m.getName())) {
                log.trace("Name is not in constraints set.");
                continue;
            }
            if (!this.isValidMethod(m, null)) continue;
            if (log.isTraceEnabled()) {
                log.trace("Adding method mapping:" + this.getMessageType(m) + " = " + m);
            }
            m.setAccessible(true);
            this.methods.put(this.getMessageType(m), m);
        }
        this.messageTypes = null;
    }

    public AbstractMessageDelegator<S> map(Class messageType, String methodName) {
        Method m = this.findDelegate(methodName, messageType);
        if (m == null) {
            throw new RuntimeException("Method:" + methodName + " not found matching signature (MessageConnection, " + messageType.getName() + ")");
        }
        if (log.isTraceEnabled()) {
            log.trace("Adding method mapping:" + messageType + " = " + m);
        }
        this.methods.put(messageType, m);
        this.messageTypes = null;
        return this;
    }

    protected Method getMethod(Class c) {
        Method m = this.methods.get(c);
        return m;
    }

    protected abstract Object getSourceDelegate(S var1);

    public void messageReceived(S source, Message msg) {
        if (msg == null) {
            return;
        }
        Object delegate = this.getSourceDelegate(source);
        if (delegate == null) {
            return;
        }
        Method m = this.getMethod(msg.getClass());
        if (m == null) {
            throw new RuntimeException("Delegate method not found for message class:" + msg.getClass());
        }
        try {
            if (m.getParameterTypes().length > 1) {
                m.invoke(delegate, source, msg);
            } else {
                m.invoke(delegate, msg);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error executing:" + m, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error executing:" + m, e.getCause());
        }
    }
}

