/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.server;

import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityId;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ComponentUsageTracker {
    private final Map<Class<? extends EntityComponent>, Map<EntityId, Long>> map = new HashMap<Class<? extends EntityComponent>, Map<EntityId, Long>>();

    protected Map<EntityId, Long> getFrameMap(Class<? extends EntityComponent> type, boolean create) {
        Map<EntityId, Long> result = this.map.get(type);
        if (result == null && create) {
            result = new HashMap<EntityId, Long>();
            this.map.put(type, result);
        }
        return result;
    }

    public Long set(EntityId id, Class<? extends EntityComponent> type, Long frame) {
        return this.getFrameMap(type, true).put(id, frame);
    }

    public void set(Collection<EntityId> ids, Class<? extends EntityComponent> type, Long frame) {
        Map<EntityId, Long> frames = this.getFrameMap(type, true);
        for (EntityId id : ids) {
            frames.put(id, frame);
        }
    }

    public Long getAndExpire(EntityId id, Class<? extends EntityComponent> type, Long current) {
        Map<EntityId, Long> frames = this.getFrameMap(type, false);
        if (frames == null) {
            return null;
        }
        Long last = frames.get(id);
        if (last == null) {
            return null;
        }
        if (last.longValue() == current.longValue()) {
            return current;
        }
        frames.remove(id);
        if (frames.isEmpty()) {
            this.map.remove(type);
        }
        return last;
    }

    public Long get(EntityId id, Class<? extends EntityComponent> type) {
        Map<EntityId, Long> frames = this.getFrameMap(type, false);
        if (frames == null) {
            return null;
        }
        return frames.get(id);
    }
}

