/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.PersistentComponent;
import java.util.Objects;

public class AgentType
implements EntityComponent,
PersistentComponent {
    public static final int LEVEL_HIGH = 0;
    public static final int LEVEL_LOW = 1;
    public static final int LEVEL_PASSIVE = 2;
    private int typeId;
    private byte level;

    private AgentType() {
    }

    public AgentType(int typeId, int level) {
        this.typeId = typeId;
        this.level = (byte)level;
    }

    public static AgentType create(String typeName, int level, EntityData ed) {
        int id = ed.getStrings().getStringId(typeName, false);
        if (id < 0) {
            id = ed.getStrings().getStringId(typeName, true);
        }
        return new AgentType(id, level);
    }

    public AgentType changeLevel(int level) {
        return new AgentType(this.typeId, level);
    }

    public int getTypeId() {
        return this.typeId;
    }

    public String getTypeName(EntityData ed) {
        if (this.typeId == -1) {
            return null;
        }
        return ed.getStrings().getString(this.typeId);
    }

    public int getLevel() {
        return this.level;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        AgentType other = (AgentType)o;
        if (other.typeId != this.typeId) {
            return false;
        }
        return other.level == this.level;
    }

    public int hashCode() {
        return Objects.hash(this.typeId, this.level);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(EntityData ed) {
        String s = ed == null ? String.valueOf(this.typeId) : this.getTypeName(ed);
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("typeId", (Object)s).add("level", (int)this.level).toString();
    }
}

