/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.PersistentComponent;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityLink
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(EntityLink.class);
    private EntityId source;
    private EntityId target;
    private int typeId;

    public EntityLink() {
    }

    public EntityLink(EntityId source, EntityId target, int typeId) {
        this.source = source;
        this.target = target;
        this.typeId = typeId;
    }

    public static EntityLink create(EntityId source, EntityId target, String typeName, EntityData ed) {
        int id = ed.getStrings().getStringId(typeName, false);
        if (id < 0) {
            id = ed.getStrings().getStringId(typeName, true);
        }
        return new EntityLink(source, target, id);
    }

    public EntityId getSource() {
        return this.source;
    }

    public EntityId getTarget() {
        return this.target;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public String getTypeName(EntityData ed) {
        if (this.typeId == -1) {
            return null;
        }
        return ed.getStrings().getString(this.typeId);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        EntityLink other = (EntityLink)o;
        if (other.typeId != this.typeId) {
            return false;
        }
        if (!Objects.equals(this.source, other.source)) {
            return false;
        }
        return Objects.equals(this.target, other.target);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.target, this.typeId);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(EntityData ed) {
        String s = ed == null ? String.valueOf(this.typeId) : this.getTypeName(ed);
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("source", (Object)this.source).add("target", (Object)this.target).add("typeId", (Object)s).toString();
    }
}

