/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.tile;

import com.simsilica.mworld.db.SpoolingObjectDb;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import mythruna.world.tile.Feature;
import mythruna.world.tile.FeatureId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureRegistry {
    static Logger log = LoggerFactory.getLogger(FeatureRegistry.class);
    private FeatureDb featureDb;

    public FeatureRegistry(File root) {
        this.featureDb = new FeatureDb(root);
    }

    public void initialize() {
        this.featureDb.initialize();
    }

    public void terminate() {
        this.featureDb.terminate();
    }

    public <T extends Feature> T getFeature(FeatureId<T> id, Class<T> type) {
        Feature feature = (Feature)this.featureDb.get(id);
        return (T)((Feature)type.cast(feature));
    }

    public void updateFeature(Feature feature) {
        this.featureDb.update(feature.getFeatureId(), feature);
    }

    private class FeatureDb
    extends SpoolingObjectDb<FeatureId, Feature> {
        private byte zipMarker;
        private int version;
        private File root;

        public FeatureDb(File root) {
            super("Features");
            this.zipMarker = (byte)66;
            this.version = 0;
            this.root = root;
        }

        protected File getFile(FeatureId key) {
            String id = String.format("%08x", key.getId());
            String p1 = id.substring(0, 3);
            String p2 = id.substring(3, 6);
            String type = key.getType().getSimpleName();
            File result = new File(this.root, "features/" + p1 + "/" + p2 + "/" + id + "." + type);
            if (!result.getParentFile().exists()) {
                result.getParentFile().mkdirs();
            }
            return result;
        }

        protected ObjectOutputStream createOutputStream(File f) throws IOException {
            FileOutputStream fOut = new FileOutputStream(f);
            fOut.write(this.zipMarker);
            BufferedOutputStream bos = new BufferedOutputStream(new GZIPOutputStream(fOut));
            return new ObjectOutputStream(bos);
        }

        protected ObjectInputStream createInputStream(File f) throws IOException {
            FileInputStream fIn = new FileInputStream(f);
            int marker = fIn.read();
            if (marker != this.zipMarker) {
                throw new RuntimeException("Marker mismatch in:" + f + " Expected:" + this.zipMarker + " Found:" + marker);
            }
            BufferedInputStream bin = new BufferedInputStream(new GZIPInputStream(fIn));
            return new ObjectInputStream(bin);
        }

        protected void storeObject(FeatureId key, Feature value) {
            try {
                File f = this.getFile(key);
                log.info("Writing:" + f);
                try (ObjectOutputStream out = this.createOutputStream(f);){
                    out.writeInt(this.version);
                    out.writeObject(value);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error storing value for:" + key, e);
            }
        }

        protected Feature loadObject(FeatureId key) {
            Feature feature;
            block10: {
                File f = this.getFile(key);
                log.info("loading:" + f + "  exists?" + f.exists());
                if (!f.exists()) {
                    return null;
                }
                ObjectInputStream in = this.createInputStream(f);
                try {
                    int fileVersion = in.readInt();
                    if (fileVersion != this.version) {
                        throw new RuntimeException("Version mismatch for:" + key + " read:" + fileVersion + " expected:" + this.version);
                    }
                    feature = (Feature)in.readObject();
                    if (in == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | ClassNotFoundException e) {
                        throw new RuntimeException("Error reading value for:" + key + " from:" + f);
                    }
                }
                in.close();
            }
            return feature;
        }
    }
}

