/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.town;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.SedectileId;
import com.simsilica.mworld.TileId;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mythruna.world.tile.Feature;
import mythruna.world.tile.FeatureId;
import mythruna.world.town.InsertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointOfInterest
implements Feature<PointOfInterest>,
Serializable {
    static Logger log = LoggerFactory.getLogger(PointOfInterest.class);
    private static final long serialVersionUID = 42L;
    private FeatureId<PointOfInterest> id;
    private String type;
    private Vec3i location;
    private int radius;
    private InsertInfo[] children;
    private Set<TileId> affectedTiles = new HashSet<TileId>();

    public PointOfInterest(long id, String type, InsertInfo ... children) {
        this.id = FeatureId.create(PointOfInterest.class, id);
        this.type = type;
        this.children = children;
        if (children == null) {
            throw new IllegalArgumentException("Must have at least one child.");
        }
        Vec3i min = new Vec3i();
        Vec3i max = new Vec3i();
        this.location = PointOfInterest.calculateRange(children, min, max);
        if (max.x - min.x > 512 || max.z - min.z > 512) {
            throw new UnsupportedOperationException("Points of interest cannot be more than half a tile size, min:" + min + " max:" + max);
        }
        this.radius = Math.max(max.x - min.x, max.z - min.z) / 2;
        this.affectedTiles.add(TileId.fromWorld((int)min.x, (int)this.location.y, (int)min.z));
        this.affectedTiles.add(TileId.fromWorld((int)max.x, (int)this.location.y, (int)min.z));
        this.affectedTiles.add(TileId.fromWorld((int)min.x, (int)this.location.y, (int)max.z));
        this.affectedTiles.add(TileId.fromWorld((int)max.x, (int)this.location.y, (int)max.z));
        log.info("poi:" + this + " affectedTile:" + this.affectedTiles);
    }

    public static Vec3i calculateRange(InsertInfo[] children, Vec3i min, Vec3i max) {
        min.set(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        max.set(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        for (InsertInfo child : children) {
            min.minLocal(child.getLocation());
            max.maxLocal(child.getLocation().add(child.getSize()));
        }
        Vec3i size = max.subtract(min);
        return new Vec3i(min).add(size.x / 2, size.y / 2, size.z / 2);
    }

    public String getType() {
        return this.type;
    }

    public Vec3i getLocation() {
        return this.location;
    }

    public int getRadius() {
        return this.radius;
    }

    public InsertInfo[] getChildren() {
        return this.children;
    }

    public boolean intersects(SedectileId sedectileId) {
        for (TileId id : this.getAffectedTiles()) {
            if (id.getSedectileId().getId() != sedectileId.getId()) continue;
            return true;
        }
        return false;
    }

    @Override
    public FeatureId<PointOfInterest> getFeatureId() {
        return this.id;
    }

    @Override
    public Collection<TileId> getAffectedTiles() {
        return this.affectedTiles;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id:" + this.id + ", type:" + this.type + ", location:" + this.location + ", radius:" + this.radius + "]@" + System.identityHashCode(this);
    }
}

