/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ext.mphys.debug;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.shape.Box;
import com.simsilica.es.EntityId;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.Contact;
import com.simsilica.mphys.ContactListener;
import com.simsilica.mphys.FilteredContactListener;
import com.simsilica.mphys.PhysicsSpace;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactDebugState<S extends AbstractShape>
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ContactDebugState.class);
    private PhysicsSpace<EntityId, S> space;
    private Grid grid;
    private Node contactRoot;
    private Camera camera;
    private double visibleRadius = 128.0;
    private Vec3d viewOrigin = new Vec3d();
    private Vec3d cameraWorld = new Vec3d();
    private Vec3i lastCenter = new Vec3i(Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
    private Vec3i lastCenterWorld = new Vec3i();
    private ContactListener<EntityId, S> contactListener;
    private ContactListener<EntityId, S> originalContactListener;
    private ConcurrentLinkedQueue<Contact<EntityId, S>> newContacts = new ConcurrentLinkedQueue();
    private int maxVisibleContacts;
    private Contact<EntityId, S>[] buffer;
    private Vec3d testLoc = new Vec3d(0.5, 65.5, 0.5);
    private Spatial testGeom;
    private ColorRGBA cpColor = new ColorRGBA(1.0f, 0.0f, 0.0f, 0.5f);
    private ColorRGBA cnColor = new ColorRGBA(0.0f, 1.0f, 1.0f, 0.5f);
    private ColorRGBA penColor = new ColorRGBA(0.0f, 1.0f, 0.0f, 0.5f);
    private Mesh arrowMesh;
    private Geometry arrowGeom;
    private Mesh penMesh;
    private Geometry penGeom;
    private Mesh cpMesh;
    private Geometry cpGeom;

    public ContactDebugState(PhysicsSpace<EntityId, S> space) {
        this(space, 128.0, 1000);
    }

    public ContactDebugState(PhysicsSpace<EntityId, S> space, double visibleRadius) {
        this(space, visibleRadius, 1000);
    }

    public ContactDebugState(PhysicsSpace<EntityId, S> space, double visibleRadius, int maxVisibleContacts) {
        this.space = space;
        this.grid = space.getGrid();
        this.visibleRadius = visibleRadius;
        this.maxVisibleContacts = maxVisibleContacts;
        this.buffer = new Contact[maxVisibleContacts];
        this.setEnabled(false);
    }

    public void toggleEnabled() {
        this.setEnabled(!this.isEnabled());
    }

    public void setViewOrigin(double x, double y, double z) {
        this.viewOrigin.set(x, y, z);
    }

    public void setViewOrigin(Vec3d origin) {
        this.setViewOrigin(origin.x, origin.y, origin.z);
    }

    public Vec3d getViewOrigin() {
        return this.viewOrigin;
    }

    protected Node getRoot() {
        return ((SimpleApplication)this.getApplication()).getRootNode();
    }

    protected Camera getCamera() {
        if (this.camera == null) {
            this.camera = this.getApplication().getCamera();
        }
        return this.camera;
    }

    protected void initialize(Application app) {
        this.contactRoot = new Node("contactRoot");
        this.arrowMesh = new Mesh();
        this.arrowMesh.setMode(Mesh.Mode.Lines);
        this.arrowGeom = new Geometry("arrows", this.arrowMesh);
        this.arrowGeom.setMaterial(GuiGlobals.getInstance().createMaterial(this.cnColor, false).getMaterial());
        this.arrowGeom.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.arrowGeom.setQueueBucket(RenderQueue.Bucket.Translucent);
        this.contactRoot.attachChild((Spatial)this.arrowGeom);
        this.penMesh = new Mesh();
        this.penMesh.setMode(Mesh.Mode.Lines);
        this.penGeom = new Geometry("pentrations", this.penMesh);
        this.penGeom.setMaterial(GuiGlobals.getInstance().createMaterial(this.penColor, false).getMaterial());
        this.penGeom.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.penGeom.setQueueBucket(RenderQueue.Bucket.Translucent);
        this.contactRoot.attachChild((Spatial)this.penGeom);
        this.cpMesh = new Mesh();
        this.cpMesh.setMode(Mesh.Mode.Lines);
        this.cpGeom = new Geometry("contactPoints", this.cpMesh);
        this.cpGeom.setMaterial(GuiGlobals.getInstance().createMaterial(this.cpColor, false).getMaterial());
        this.cpGeom.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.cpGeom.setQueueBucket(RenderQueue.Bucket.Translucent);
        this.contactRoot.attachChild((Spatial)this.cpGeom);
        Box b = new Box(0.5f, 0.5f, 0.5f);
        this.testGeom = new Geometry("test", (Mesh)b);
        this.testGeom.setMaterial(GuiGlobals.getInstance().createMaterial(ColorRGBA.Yellow, true).getMaterial());
        this.contactRoot.attachChild(this.testGeom);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.getRoot().attachChild((Spatial)this.contactRoot);
        this.originalContactListener = this.space.getContactDispatcher();
        this.contactListener = this.originalContactListener != null ? new FilteredContactListener(this.originalContactListener, (ContactListener)new ContactObserver()) : new ContactObserver();
        this.space.setContactDispatcher(this.contactListener);
    }

    protected void onDisable() {
        this.contactRoot.removeFromParent();
        if (this.space.getContactDispatcher() == this.contactListener) {
            this.space.setContactDispatcher(this.originalContactListener);
        } else {
            log.warn("Could not remove the contact listener");
        }
    }

    public void update(float tpf) {
        Contact<EntityId, S> contact;
        this.updateCenter();
        double threshold = this.visibleRadius * this.visibleRadius;
        int count = 0;
        int index = 0;
        while ((contact = this.newContacts.poll()) != null) {
            double dSq = contact.contactPoint.distanceSq(this.cameraWorld);
            if (dSq > threshold) continue;
            this.buffer[index] = contact;
            index = (index + 1) % this.maxVisibleContacts;
            ++count;
        }
        if (log.isTraceEnabled()) {
            log.trace("Frame visible contact count:" + count);
        }
        this.rebuildGeometry(Math.min(count, this.maxVisibleContacts));
    }

    protected void updateCenter() {
        Vector3f cameraPos = this.getCamera().getLocation();
        this.cameraWorld.set(this.viewOrigin).addLocal(new Vec3d(cameraPos));
        Vec3i center = this.grid.worldToCell(this.cameraWorld.x, 0.0, this.cameraWorld.z);
        if (!center.equals((Object)this.lastCenter)) {
            this.lastCenter.set(center);
            this.grid.cellToWorld(center, this.lastCenterWorld);
            this.updatePositions();
        }
    }

    protected void updatePositions() {
        Vec3d rel = this.testLoc.subtract(this.lastCenterWorld.toVec3d());
        this.testGeom.setLocalTranslation(rel.toVector3f());
    }

    protected void rebuildGeometry(int count) {
        Vec3d origin = this.lastCenterWorld.toVec3d();
        int linesPerContact = 5;
        int linesPerCp = 3;
        double arrowHeadBase = 0.9;
        double arrowHeadSize = 0.05;
        double axisSize = 0.01;
        float[] pos = new float[count * linesPerContact * 3 * 2];
        float[] penPos = new float[count * linesPerContact * 3 * 2];
        float[] cpPos = new float[count * linesPerCp * 3 * 2];
        int index = 0;
        int penIndex = 0;
        int cpIndex = 0;
        Vec3d p = new Vec3d();
        Vec3d tip = new Vec3d();
        Vec3d arrowBase = new Vec3d();
        Vec3d axis1 = new Vec3d();
        Vec3d axis2 = new Vec3d();
        for (int i = 0; i < count; ++i) {
            Contact<EntityId, S> c = this.buffer[i];
            p.set(c.contactPoint).subtractLocal(origin);
            tip.set(p).addLocal(c.contactNormal);
            pos[index++] = (float)p.x;
            pos[index++] = (float)p.y;
            pos[index++] = (float)p.z;
            pos[index++] = (float)tip.x;
            pos[index++] = (float)tip.y;
            pos[index++] = (float)tip.z;
            arrowBase.set(c.contactNormal).multLocal(arrowHeadBase).addLocal(p);
            if (Math.abs(c.contactNormal.dot(0.0, 1.0, 0.0)) > 0.9999) {
                axis1.set(1.0, 0.0, 0.0);
                axis2.set(0.0, 0.0, 1.0);
            } else {
                axis1.set(0.0, 0.0, 1.0).crossLocal(c.contactNormal);
                axis2.set(axis1).crossLocal(c.contactNormal);
            }
            axis1.multLocal(arrowHeadSize);
            axis2.multLocal(arrowHeadSize);
            pos[index++] = (float)tip.x;
            pos[index++] = (float)tip.y;
            pos[index++] = (float)tip.z;
            pos[index++] = (float)(arrowBase.x + axis1.x);
            pos[index++] = (float)(arrowBase.y + axis1.y);
            pos[index++] = (float)(arrowBase.z + axis1.z);
            pos[index++] = (float)tip.x;
            pos[index++] = (float)tip.y;
            pos[index++] = (float)tip.z;
            pos[index++] = (float)(arrowBase.x + axis2.x);
            pos[index++] = (float)(arrowBase.y + axis2.y);
            pos[index++] = (float)(arrowBase.z + axis2.z);
            pos[index++] = (float)tip.x;
            pos[index++] = (float)tip.y;
            pos[index++] = (float)tip.z;
            pos[index++] = (float)(arrowBase.x - axis1.x);
            pos[index++] = (float)(arrowBase.y - axis1.y);
            pos[index++] = (float)(arrowBase.z - axis1.z);
            pos[index++] = (float)tip.x;
            pos[index++] = (float)tip.y;
            pos[index++] = (float)tip.z;
            pos[index++] = (float)(arrowBase.x - axis2.x);
            pos[index++] = (float)(arrowBase.y - axis2.y);
            pos[index++] = (float)(arrowBase.z - axis2.z);
            tip.set(c.contactNormal).multLocal(-c.penetration).addLocal(p);
            arrowBase.set(c.contactNormal).multLocal(-c.penetration * arrowHeadBase).addLocal(p);
            axis1.multLocal(c.penetration);
            axis2.multLocal(c.penetration);
            penPos[penIndex++] = (float)p.x;
            penPos[penIndex++] = (float)p.y;
            penPos[penIndex++] = (float)p.z;
            penPos[penIndex++] = (float)tip.x;
            penPos[penIndex++] = (float)tip.y;
            penPos[penIndex++] = (float)tip.z;
            penPos[penIndex++] = (float)tip.x;
            penPos[penIndex++] = (float)tip.y;
            penPos[penIndex++] = (float)tip.z;
            penPos[penIndex++] = (float)(arrowBase.x + axis1.x);
            penPos[penIndex++] = (float)(arrowBase.y + axis1.y);
            penPos[penIndex++] = (float)(arrowBase.z + axis1.z);
            penPos[penIndex++] = (float)tip.x;
            penPos[penIndex++] = (float)tip.y;
            penPos[penIndex++] = (float)tip.z;
            penPos[penIndex++] = (float)(arrowBase.x + axis2.x);
            penPos[penIndex++] = (float)(arrowBase.y + axis2.y);
            penPos[penIndex++] = (float)(arrowBase.z + axis2.z);
            penPos[penIndex++] = (float)tip.x;
            penPos[penIndex++] = (float)tip.y;
            penPos[penIndex++] = (float)tip.z;
            penPos[penIndex++] = (float)(arrowBase.x - axis1.x);
            penPos[penIndex++] = (float)(arrowBase.y - axis1.y);
            penPos[penIndex++] = (float)(arrowBase.z - axis1.z);
            penPos[penIndex++] = (float)tip.x;
            penPos[penIndex++] = (float)tip.y;
            penPos[penIndex++] = (float)tip.z;
            penPos[penIndex++] = (float)(arrowBase.x - axis2.x);
            penPos[penIndex++] = (float)(arrowBase.y - axis2.y);
            penPos[penIndex++] = (float)(arrowBase.z - axis2.z);
            cpPos[cpIndex++] = (float)(p.x + axisSize);
            cpPos[cpIndex++] = (float)p.y;
            cpPos[cpIndex++] = (float)p.z;
            cpPos[cpIndex++] = (float)(p.x - axisSize);
            cpPos[cpIndex++] = (float)p.y;
            cpPos[cpIndex++] = (float)p.z;
            cpPos[cpIndex++] = (float)p.x;
            cpPos[cpIndex++] = (float)(p.y + axisSize);
            cpPos[cpIndex++] = (float)p.z;
            cpPos[cpIndex++] = (float)p.x;
            cpPos[cpIndex++] = (float)(p.y - axisSize);
            cpPos[cpIndex++] = (float)p.z;
            cpPos[cpIndex++] = (float)p.x;
            cpPos[cpIndex++] = (float)p.y;
            cpPos[cpIndex++] = (float)(p.z + axisSize);
            cpPos[cpIndex++] = (float)p.x;
            cpPos[cpIndex++] = (float)p.y;
            cpPos[cpIndex++] = (float)(p.z - axisSize);
        }
        this.arrowMesh.setBuffer(VertexBuffer.Type.Position, 3, pos);
        this.arrowGeom.updateModelBound();
        this.penMesh.setBuffer(VertexBuffer.Type.Position, 3, penPos);
        this.penGeom.updateModelBound();
        this.cpMesh.setBuffer(VertexBuffer.Type.Position, 3, cpPos);
        this.cpGeom.updateModelBound();
    }

    private class ContactObserver
    implements ContactListener<EntityId, S> {
        private ContactObserver() {
        }

        public void newContact(Contact<EntityId, S> contact) {
            ContactDebugState.this.newContacts.add(contact);
        }
    }
}

