/*
 * Decompiled with CFR 0.152.
 */
package mythruna.net;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LagSimulator {
    static Logger log = LoggerFactory.getLogger(LagSimulator.class);
    private String name;
    private long delay;
    private Map<Thread, DelayedDispatcher> dispatchers = new HashMap<Thread, DelayedDispatcher>();

    public LagSimulator(String name, long delay) {
        this.name = name;
        this.delay = delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DelayedDispatcher getDispatcher() {
        Thread thread = Thread.currentThread();
        Map<Thread, DelayedDispatcher> map = this.dispatchers;
        synchronized (map) {
            DelayedDispatcher result = this.dispatchers.get(thread);
            if (result == null) {
                result = new DelayedDispatcher(this.name + ":" + thread.getName());
                result.start();
                this.dispatchers.put(thread, result);
                log.info("New dispatcher:" + result);
            }
            return result;
        }
    }

    public void run(Runnable run) {
        this.getDispatcher().add(run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<Thread, DelayedDispatcher> map = this.dispatchers;
        synchronized (map) {
            for (DelayedDispatcher d : this.dispatchers.values()) {
                log.info("Closing dispatcher:" + d);
                d.close();
            }
        }
    }

    private class DelayedDispatcher
    extends Thread {
        private AtomicBoolean go;
        private ConcurrentLinkedQueue<DelayedCall> queue;

        public DelayedDispatcher(String name) {
            super("DelayedDispatcher[" + name + "]");
            this.go = new AtomicBoolean(true);
            this.queue = new ConcurrentLinkedQueue();
            this.setDaemon(true);
        }

        public void add(Runnable run) {
            long time = System.currentTimeMillis();
            this.queue.add(new DelayedCall(run, time + LagSimulator.this.delay));
        }

        public void close() {
            this.go.set(false);
            this.interrupt();
        }

        @Override
        public void run() {
            while (this.go.get()) {
                long time = System.currentTimeMillis();
                try {
                    DelayedCall next = null;
                    while ((next = this.queue.peek()) != null && time >= next.runAt) {
                        this.queue.poll();
                        next.call.run();
                        next = null;
                    }
                    if (next != null) {
                        long perfectSleep = Math.max(0L, next.runAt - time);
                        Thread.sleep(perfectSleep);
                        continue;
                    }
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    if (!this.go.get()) continue;
                    log.error("Interrupted during lag sim", (Throwable)e);
                }
            }
        }
    }

    private class DelayedCall {
        Runnable call;
        long runAt;

        public DelayedCall(Runnable call, long runAt) {
            this.call = call;
            this.runAt = runAt;
        }
    }
}

