/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur;

import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.SequenceModel;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import java.util.List;
import java.util.Objects;

public class SequenceModels {
    public static SequenceModel<Double> doubleSequence(double initialValue, double step) {
        return SequenceModels.doubleSequence(initialValue, step, step);
    }

    public static SequenceModel<Double> doubleSequence(double initialValue, double step, double resolution) {
        return new DoubleSequence(initialValue, step, resolution);
    }

    public static SequenceModel<Double> rangedSequence(RangedValueModel model, double step, double resolution) {
        return new RangedSequence(model, step, resolution);
    }

    public static <T> SequenceModel<T> listSequence(List<T> list) {
        return SequenceModels.listSequence(list, null);
    }

    public static <T> SequenceModel<T> listSequence(List<T> list, T initialItem) {
        return new ListSequence<T>(list, initialItem);
    }

    public static class ListSequence<T>
    extends AbstractSequence<T> {
        private Object currentValue;
        private int index;
        private List<T> list;

        public ListSequence(List<T> list, T initialItem) {
            this.list = list;
            this.index = list.indexOf(initialItem);
            this.currentValue = initialItem;
            if (this.index < 0) {
                this.index = 0;
            }
        }

        protected int nextIndex(int i) {
            return (i + 1) % this.list.size();
        }

        protected int previousIndex(int i) {
            return (i + this.list.size() - 1) % this.list.size();
        }

        @Override
        public T getObject() {
            if (this.list.isEmpty()) {
                return null;
            }
            return this.list.get(this.index);
        }

        @Override
        public void setObject(T object) {
            if (Objects.equals(this.currentValue, object) && Objects.equals(this.currentValue, this.getObject())) {
                return;
            }
            if (Objects.equals(this.getNextObject(), object)) {
                this.index = this.nextIndex(this.index);
            } else if (Objects.equals(this.getPreviousObject(), object)) {
                this.index = this.previousIndex(this.index);
            } else {
                this.index = this.list.indexOf(object);
                if (this.index < 0) {
                    throw new IllegalArgumentException("Item is not in sequence:" + object);
                }
            }
            this.currentValue = object;
            this.incrementVersion();
        }

        @Override
        public T getNextObject() {
            return this.list.get(this.nextIndex(this.index));
        }

        @Override
        public T getPreviousObject() {
            return this.list.get(this.previousIndex(this.index));
        }
    }

    public static class RangedSequence
    extends AbstractSequence<Double> {
        private RangedValueModel model;
        private double step;
        private double resolution;
        private double scale;

        public RangedSequence(RangedValueModel model, double step, double resolution) {
            this.model = model;
            this.step = step;
            this.resolution = resolution;
            this.scale = 1.0 / resolution;
        }

        protected double normalize(double value) {
            return DoubleSequence.normalize(value, this.resolution);
        }

        @Override
        public Double getObject() {
            return this.normalize(this.model.getValue());
        }

        @Override
        public void setObject(Double object) {
            if (object == null) {
                throw new IllegalArgumentException("Value cannot be null");
            }
            double val = this.normalize(object);
            if (this.model.getValue() == val) {
                return;
            }
            this.model.setValue(val);
        }

        @Override
        public Double getNextObject() {
            return this.normalize(this.model.getValue() + this.step);
        }

        @Override
        public Double getPreviousObject() {
            return this.normalize(this.model.getValue() - this.step);
        }

        @Override
        public long getVersion() {
            return this.model.getVersion();
        }
    }

    public static class DoubleSequence
    extends AbstractSequence<Double> {
        private double current;
        private double step;
        private double resolution;
        private double scale;

        public DoubleSequence(double current, double step, double resolution) {
            this.current = current;
            this.step = step;
            this.resolution = resolution;
            this.scale = 1.0 / resolution;
        }

        public static double normalize(double value, double resolution) {
            double scaled = value / resolution;
            double clamped = Math.rint(scaled);
            return clamped * resolution;
        }

        protected double normalize(double value) {
            return DoubleSequence.normalize(value, this.resolution);
        }

        @Override
        public Double getObject() {
            return this.current;
        }

        @Override
        public void setObject(Double object) {
            if (object == null) {
                throw new IllegalArgumentException("Value cannot be null");
            }
            double val = this.normalize(object);
            if (this.current == val) {
                return;
            }
            this.current = val;
            this.incrementVersion();
        }

        @Override
        public Double getNextObject() {
            return this.normalize(this.current + this.step);
        }

        @Override
        public Double getPreviousObject() {
            return this.normalize(this.current - this.step);
        }
    }

    public static abstract class AbstractSequence<T>
    implements SequenceModel<T> {
        private long version;

        protected void incrementVersion() {
            ++this.version;
        }

        public long getVersion() {
            return this.version;
        }

        public VersionedReference<T> createReference() {
            return new VersionedReference((VersionedObject)this);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.getObject() + "]";
        }
    }
}

