/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.fractal;

import com.google.common.base.MoreObjects;
import com.simsilica.fractal.AbstractSampler;
import com.simsilica.fractal.CellularNoise;
import com.simsilica.fractal.SamplerRange;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCellularSampler
extends AbstractSampler {
    static Logger log = LoggerFactory.getLogger(CellularNoise.class);
    private long seed = 0L;
    private static final long DOUBLE_MASK = 0x1FFFFFFFFFFFFFL;
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    private static final int TABLE_SIZE = 65536;
    private static final int TABLE_MASK = 65535;
    private final long[] randomTable = new long[65536];

    protected AbstractCellularSampler(long seed, double min, double max) {
        super(min, max);
        this.seed = seed;
        this.initTable(seed);
    }

    protected AbstractCellularSampler(long seed, SamplerRange range) {
        super(range);
        this.seed = seed;
        this.initTable(seed);
    }

    public long getSeed() {
        return this.seed;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("seed", this.seed).toString();
    }

    protected final double getOriginalRandomX(double x, double z) {
        double dot1 = (x * 127.1 + z * 311.7 + (double)this.seed * 783.089) % Math.PI;
        return Math.abs(Math.sin(dot1) * 43758.5453 % 1.0);
    }

    protected final double getSimplifiedRandomX(double x, double z) {
        double dot1 = x * 127.1 + z * 311.7 + (double)this.seed * 783.089;
        double value = Math.sin(dot1) * 43758.5453;
        return value - (double)((int)value);
    }

    protected final double getOriginalRandomZ(double x, double z) {
        double dot2 = (x * 269.5 + z * 183.3) % Math.PI;
        return Math.abs(Math.sin(dot2) * 43758.5453 % 1.0);
    }

    protected final double getSimplifiedRandomZ(double x, double z) {
        double dot2 = x * 269.5 + z * 183.3;
        double value = Math.sin(dot2) * 43758.5453;
        return value - (double)((int)value);
    }

    private void initTable(long seed) {
        log.info("initTable(" + seed + ")");
        Random rand = new Random(seed);
        for (int i = 0; i < 65536; ++i) {
            this.randomTable[i] = rand.nextLong();
        }
    }

    protected final double getRandomX(double x, double z) {
        int index = (int)(x * 127.7 + z * 311.7);
        long val = this.randomTable[index & 0xFFFF];
        val = Long.rotateRight(val, (int)x & 0xFF);
        return (double)(val & 0x1FFFFFFFFFFFFFL) * (double)1.110223E-16f;
    }

    protected final double getRandomZ(double x, double z) {
        int index = (int)(x * 269.5 + z * 183.3);
        long val = this.randomTable[index & 0xFFFF];
        val = Long.rotateRight(val, (int)z & 0xFF);
        return (double)(val & 0x1FFFFFFFFFFFFFL) * (double)1.110223E-16f;
    }
}

