/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net;

import com.jme3.network.Client;
import com.jme3.network.Message;
import com.jme3.network.Network;
import com.jme3.network.base.ConnectorFactory;
import com.jme3.network.base.DefaultClient;
import com.jme3.network.base.TcpConnectorFactory;
import com.jme3.network.kernel.Connector;
import com.jme3.network.kernel.tcp.SocketConnector;
import com.jme3.network.kernel.udp.UdpConnector;
import com.jme3.network.service.ClientService;
import com.jme3.network.service.rmi.RmiClientService;
import com.jme3.network.service.rpc.RpcClientService;
import com.simsilica.bpos.net.SharedObjectUpdater;
import com.simsilica.es.EntityData;
import com.simsilica.es.client.EntityDataClientService;
import com.simsilica.ethereal.EtherealClient;
import com.simsilica.ethereal.TimeSource;
import com.simsilica.mworld.net.client.WorldClientService;
import com.simsilica.net.client.ChatClientService;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import mythruna.GameConstants;
import mythruna.client.MythrunaConfig;
import mythruna.net.LagSimulator;
import mythruna.net.client.AccountClientService;
import mythruna.net.client.GameSessionClientService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameClient {
    static Logger log = LoggerFactory.getLogger(GameClient.class);
    private Client client;
    private EntityData ed;
    private final List<ClientService> services = new CopyOnWriteArrayList<ClientService>();

    public GameClient() {
        this.services.add((ClientService)new AccountClientService());
        this.services.add((ClientService)new ChatClientService(0));
        this.services.add((ClientService)new EntityDataClientService(1));
        this.services.add((ClientService)new GameSessionClientService());
        this.services.add((ClientService)new WorldClientService(2));
        this.services.add((ClientService)new EtherealClient(GameConstants.OBJECT_PROTOCOL, GameConstants.ZONE_GRID, GameConstants.ZONE_RADIUS));
        this.services.add((ClientService)new SharedObjectUpdater());
    }

    public void connect(String host, int port) throws IOException {
        log.info("Connecting to:" + host + " " + port);
        Number tcpLag = MythrunaConfig.getInstance().getStartupSetting("SimulatedClientLag.TCP", null);
        if (tcpLag == null || tcpLag.longValue() == 0L) {
            this.client = Network.connectToServer((String)"Mythruna", (int)20230907, (String)host, (int)port);
        } else {
            log.info("Simulating TCP lag:" + tcpLag.longValue());
            final LagSimulator lagSim = new LagSimulator("client", tcpLag.longValue());
            InetAddress remoteAddress = InetAddress.getByName(host);
            UdpConnector fast = new UdpConnector(remoteAddress, port);
            SocketConnector reliable = new SocketConnector(remoteAddress, port);
            this.client = new DefaultClient("Mythruna", 20230907, (Connector)reliable, (Connector)fast, (ConnectorFactory)new TcpConnectorFactory(remoteAddress)){

                public void close() {
                    lagSim.close();
                    super.close();
                }

                protected void dispatch(Message m) {
                    if (m.isReliable()) {
                        lagSim.run(() -> super.dispatch(m));
                    } else {
                        super.dispatch(m);
                    }
                }
            };
        }
        log.info("Adding services...");
        this.client.getServices().addServices(new ClientService[]{new RpcClientService(), new RmiClientService()});
        for (ClientService service : this.services) {
            this.client.getServices().addService(service);
        }
        this.ed = ((EntityDataClientService)this.client.getServices().getService(EntityDataClientService.class)).getEntityData();
    }

    public TimeSource getTimeSource() {
        return ((EtherealClient)this.client.getServices().getService(EtherealClient.class)).getTimeSource();
    }

    public Client getClient() {
        return this.client;
    }

    public EntityData getEntityData() {
        return this.ed;
    }

    public void start() {
        log.info("start()");
        this.client.start();
    }

    public void addService(ClientService service) {
        this.client.getServices().addService(service);
    }

    public void removeService(ClientService service) {
        this.client.getServices().removeService(service);
    }

    public <T> T getService(Class<T> type) {
        return this.getService(type, false);
    }

    public <T> T getService(Class<T> type, boolean failOnMiss) {
        for (ClientService service : this.services) {
            if (!type.isInstance(service)) continue;
            return type.cast(service);
        }
        if (failOnMiss) {
            throw new IllegalArgumentException("Service not found of type:" + type);
        }
        return null;
    }

    public <T extends ClientService> T getClientService(Class<T> type) {
        return (T)((ClientService)this.getService(type, false));
    }

    public <T extends ClientService> T getClientService(Class<T> type, boolean failOnMiss) {
        for (ClientService service : this.services) {
            if (!type.isInstance(service)) continue;
            return (T)((ClientService)type.cast(service));
        }
        ClientService result = (ClientService)this.client.getServices().getService(type);
        if (result == null && failOnMiss) {
            throw new IllegalArgumentException("Service not found of type:" + type);
        }
        return null;
    }

    public void close() {
        log.info("close()");
        if (this.client != null && this.client.isStarted()) {
            this.client.close();
        }
    }
}

