/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.character;

import com.google.common.collect.Ordering;
import com.jme3.app.Application;
import com.jme3.app.state.AppState;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.input.AnalogFunctionListener;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.input.InputState;
import com.simsilica.lemur.input.StateFunctionListener;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.ConstantCellData;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mblock.geom.GeometryFactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import mythruna.client.GameSessionState;
import mythruna.client.GuiState;
import mythruna.client.PerspectiveGuiState;
import mythruna.client.ui.PlayerMenuState;
import mythruna.client.ui.character.CharacterFunctions;
import mythruna.client.ui.clothing.ClothingItem;
import mythruna.client.view.ModelViewState;
import mythruna.es.ClothingInfo;
import mythruna.es.ObjectName;
import mythruna.es.WornBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterMenuState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(CharacterMenuState.class);
    private GameSessionState sessionState;
    private EntityData ed;
    private EntityId player;
    private Node rootNode = new Node("character");
    private Spatial background;
    private Node platform = new Node("platform");
    private Vector2f screenSize = new Vector2f();
    private Vector2f center = new Vector2f();
    private Node avatar = new Node("character");
    private InputHandler inputHandler = new InputHandler();
    private float yaw = 0.7853982f;
    private float pitch = 0.39f;
    private float minPitch = 0.0f;
    private float maxPitch = 1.4137167f;
    private float yOffset = -200.0f;
    private GeometryFactory geomFactory;
    private CellArray groundCells = new CellArray(1, 1, 1);
    private Container sidebar;
    private AvailableClothingContainer availableClothes;
    private Container selectionWindow;
    private VersionedList<ClothingItem> designList = new VersionedList();
    private ListBox<ClothingItem> designs;
    private ActionButton doWear;
    private WornClothingContainer wornClothes;
    private Container wearingWindow;
    private VersionedList<ClothingItem> wearingList = new VersionedList();
    private ListBox<ClothingItem> wearing;
    private ActionButton doRemove;
    private boolean resortWearing = false;
    private int updateFrames = -1;

    public CharacterMenuState() {
        this(false);
    }

    public CharacterMenuState(boolean enabled) {
        this.setEnabled(enabled);
    }

    protected void wear() {
        ClothingItem item = (ClothingItem)this.designs.getSelectedItem();
        log.info("wear():" + item);
        if (item == null) {
            return;
        }
        this.sessionState.getGameSession().runAction(item.getId(), "Wear", new Object[0]);
    }

    protected void unwear() {
        log.info("unwear()");
        ClothingItem item = (ClothingItem)this.wearing.getSelectedItem();
        log.info("unwear():" + item);
        if (item == null) {
            return;
        }
        this.sessionState.getGameSession().runAction(item.getId(), "Remove", new Object[0]);
    }

    protected void initialize(Application app) {
        if (this.getState(PlayerMenuState.class) != null) {
            ((PlayerMenuState)this.getState(PlayerMenuState.class, true)).addSubmenu("Character", (AppState)this);
        }
        this.sessionState = (GameSessionState)this.getState(GameSessionState.class, true);
        this.ed = this.sessionState.getEntityData();
        this.player = this.sessionState.getGameSession().getAvatar();
        this.geomFactory = ((GameSessionState)this.getState(GameSessionState.class, true)).getGeometryFactory();
        this.availableClothes = new AvailableClothingContainer(this.player, this.ed);
        this.wornClothes = new WornClothingContainer(this.player, this.ed);
        this.screenSize.set(((PerspectiveGuiState)this.getState(PerspectiveGuiState.class, true)).getGuiSize());
        this.center.set(this.screenSize).multLocal(0.5f);
        log.info("center:" + this.center);
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        CharacterFunctions.initializeDefaultMappings(inputMapper);
        inputMapper.addAnalogListener((AnalogFunctionListener)this.inputHandler, new FunctionId[]{CharacterFunctions.F_PAN, CharacterFunctions.F_CRANE, CharacterFunctions.F_ZOOM});
        this.sidebar = new Container();
        float minWidth = 300.0f;
        this.selectionWindow = (Container)this.sidebar.addChild((Node)new Container(new ElementId("window")), new Object[0]);
        this.selectionWindow.setInsets(new Insets3f(0.0f, 0.0f, 20.0f, 0.0f));
        Label label = (Label)this.selectionWindow.addChild((Node)new Label("Clothing Selector", new ElementId("window.title")), new Object[0]);
        Vector3f pref = label.getPreferredSize();
        pref.x = Math.max(minWidth, pref.x);
        label.setPreferredSize(pref);
        this.designs = (ListBox)this.selectionWindow.addChild((Node)new ListBox(this.designList), new Object[0]);
        Container buttons = (Container)this.selectionWindow.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        this.doWear = (ActionButton)buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Wear", (Object)this, "wear")), new Object[0]);
        this.wearingWindow = (Container)this.sidebar.addChild((Node)new Container(new ElementId("window")), new Object[0]);
        this.wearingWindow.addChild((Node)new Label("Wearing", new ElementId("window.title")), new Object[0]);
        this.wearing = (ListBox)this.wearingWindow.addChild((Node)new ListBox(this.wearingList), new Object[0]);
        buttons = (Container)this.wearingWindow.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        this.doRemove = (ActionButton)buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Remove", (Object)this, "unwear")), new Object[0]);
        this.background = ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class)).createVignette();
        this.rootNode.attachChild(this.background);
        this.rootNode.attachChild((Spatial)this.platform);
        float percent = 0.8f;
        float scale = this.screenSize.y * percent * 0.5f;
        this.platform.setLocalScale(scale);
        this.yOffset = -0.9f;
        this.avatar.move(0.0f, this.yOffset, 0.0f);
        this.platform.attachChild((Spatial)this.avatar);
        int grass = BlockTypeIndex.findType((BlockName)new BlockName("grass", "cube"));
        int topsOnly = MaskUtils.setSideMask((int)grass, (int)16);
        this.groundCells.clear(topsOnly);
        Node ground = new Node("ground");
        ground.move((float)(-this.groundCells.getSizeX()) * 0.5f, (float)(-this.groundCells.getSizeY()), (float)(-this.groundCells.getSizeZ()) * 0.5f);
        ground.move(0.0f, this.yOffset, 0.0f);
        this.geomFactory.generateBlocks(ground, this.groundCells, (CellData)new ConstantCellData(LightUtils.DIRECT_SUN), true);
        this.platform.attachChild((Spatial)ground);
    }

    protected void cleanup(Application app) {
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.removeAnalogListener((AnalogFunctionListener)this.inputHandler, new FunctionId[]{CharacterFunctions.F_PAN, CharacterFunctions.F_CRANE, CharacterFunctions.F_ZOOM});
    }

    protected void onEnable() {
        this.availableClothes.start();
        this.wornClothes.start();
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.activateGroup("Character");
        ((PerspectiveGuiState)this.getState(PerspectiveGuiState.class, true)).getRoot().attachChild((Spatial)this.rootNode);
        log.info("world bound:" + this.avatar.getWorldBound());
        ((GuiState)this.getState(GuiState.class, true)).getGuiRoot().attachChild((Spatial)this.sidebar);
        this.updateLayout();
        this.resetModel();
    }

    protected void resetModel() {
        log.info("resetModel()");
        Spatial model = ((ModelViewState)this.getState(ModelViewState.class)).getModel(this.player).clone(false);
        model.setLocalTranslation(0.0f, 0.0f, 0.0f);
        model.setLocalRotation(new Quaternion());
        this.avatar.detachAllChildren();
        this.avatar.attachChild(model);
        this.updateRotation();
    }

    protected void updateLayout() {
        float x = this.screenSize.x * 0.95f;
        float y = this.screenSize.y * 0.95f;
        Vector3f pref = this.sidebar.getPreferredSize();
        this.sidebar.setLocalTranslation(x - pref.x, y, 0.0f);
    }

    public void update(float tpf) {
        if (this.availableClothes.update()) {
            this.updateLayout();
        }
        if (this.wornClothes.update()) {
            this.updateLayout();
        }
        if (this.resortWearing) {
            this.resortWearing();
        }
    }

    protected void onDisable() {
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.deactivateGroup("Character");
        this.rootNode.removeFromParent();
        this.sidebar.removeFromParent();
        this.availableClothes.stop();
        this.wornClothes.stop();
    }

    protected void updateRotation() {
        Quaternion rot = new Quaternion().fromAngles(this.pitch, 0.0f, 0.0f);
        rot.multLocal(new Quaternion().fromAngles(0.0f, this.yaw, 0.0f));
        this.platform.setLocalRotation(rot);
        this.platform.setLocalTranslation(this.center.x, this.center.y, 0.0f);
    }

    protected void resortWearing() {
        this.resortWearing = false;
        Collections.sort(this.wearingList, this.wornClothes.comparator);
    }

    private class InputHandler
    implements AnalogFunctionListener,
    StateFunctionListener {
        private InputHandler() {
        }

        public void valueChanged(FunctionId func, InputState value, double tpf) {
        }

        public void valueActive(FunctionId func, double value, double tpf) {
            if (func == CharacterFunctions.F_PAN) {
                CharacterMenuState.this.yaw = (float)((double)CharacterMenuState.this.yaw + -value * tpf);
                if (CharacterMenuState.this.yaw < 0.0f) {
                    CharacterMenuState.this.yaw += (float)Math.PI * 2;
                } else if (CharacterMenuState.this.yaw >= (float)Math.PI * 2) {
                    CharacterMenuState.this.yaw -= (float)Math.PI * 2;
                }
                CharacterMenuState.this.updateRotation();
            } else if (func == CharacterFunctions.F_CRANE) {
                CharacterMenuState.this.pitch = (float)((double)CharacterMenuState.this.pitch + value * tpf);
                if (CharacterMenuState.this.pitch < CharacterMenuState.this.minPitch) {
                    CharacterMenuState.this.pitch = CharacterMenuState.this.minPitch;
                } else if (CharacterMenuState.this.pitch > CharacterMenuState.this.maxPitch) {
                    CharacterMenuState.this.pitch = CharacterMenuState.this.maxPitch;
                }
                CharacterMenuState.this.updateRotation();
            } else {
                log.info("unhandled id:" + func);
            }
        }
    }

    private class AvailableClothingContainer
    extends EntityContainer<ClothingItem> {
        private Comparator<? super ClothingItem> comparator;

        public AvailableClothingContainer(EntityId player, EntityData ed) {
            super(ed, new Class[]{ClothingInfo.class, ShapeInfo.class, ObjectName.class});
            this.comparator = Ordering.usingToString();
            ComponentFilter filter = Filters.fieldEquals(ClothingInfo.class, (String)"parent", (Object)player);
            this.setFilter(filter);
        }

        protected ClothingItem addObject(Entity e) {
            log.info("addObject(" + e + ")");
            ClothingItem object = new ClothingItem(e);
            this.updateObject(object, e);
            if (this.comparator != null) {
                int index = Collections.binarySearch(CharacterMenuState.this.designList, object, this.comparator);
                if (index < 0) {
                    index = -(index + 1);
                }
                CharacterMenuState.this.designList.add(index, (Object)object);
            } else {
                CharacterMenuState.this.designList.add((Object)object);
            }
            return object;
        }

        protected void updateObject(ClothingItem object, Entity e) {
            object.update(CharacterMenuState.this.ed);
        }

        protected void removeObject(ClothingItem object, Entity e) {
            CharacterMenuState.this.designList.remove((Object)object);
        }
    }

    private class WornClothingContainer
    extends EntityContainer<ClothingItem> {
        private Comparator<? super ClothingItem> comparator;

        public WornClothingContainer(EntityId player, EntityData ed) {
            super(ed, new Class[]{WornBy.class, ClothingInfo.class, ShapeInfo.class, ObjectName.class});
            this.comparator = new LayerSorter();
            ComponentFilter filter = Filters.fieldEquals(WornBy.class, (String)"target", (Object)player);
            this.setFilter(filter);
        }

        protected ClothingItem addObject(Entity e) {
            log.info("addObject(" + e + ")");
            ClothingItem object = new ClothingItem(e);
            this.updateObject(object, e);
            CharacterMenuState.this.wearingList.add((Object)object);
            CharacterMenuState.this.resortWearing = true;
            return object;
        }

        protected void updateObject(ClothingItem object, Entity e) {
            WornBy original = object.getWornBy();
            object.update(CharacterMenuState.this.ed);
            if (!Objects.equals(original, object.getWornBy())) {
                CharacterMenuState.this.resortWearing = true;
            }
        }

        protected void removeObject(ClothingItem object, Entity e) {
            CharacterMenuState.this.resortWearing = true;
            CharacterMenuState.this.wearingList.remove((Object)object);
        }
    }

    private class LayerSorter
    implements Comparator<ClothingItem> {
        private LayerSorter() {
        }

        @Override
        public int compare(ClothingItem item1, ClothingItem item2) {
            int layer2;
            if (item1 == item2) {
                return 0;
            }
            int layer1 = item1.getLayer();
            int result = Integer.compare(layer1, layer2 = item2.getLayer());
            if (result != 0) {
                return result;
            }
            return Long.compare(item1.getId().getId(), item2.getId().getId());
        }
    }
}

