/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.material.MatParamTexture;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Geometry;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.SceneGraphVisitorAdapter;
import com.jme3.scene.Spatial;
import com.jme3.texture.Texture;
import com.simsilica.es.EntityId;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.db.CellArrayId;
import com.simsilica.thread.Job;
import com.simsilica.thread.JobState;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import mythruna.client.GameSessionState;
import mythruna.fabric.ClothingPainter;
import mythruna.fabric.FabricTexture;
import mythruna.fabric.FabricType;
import mythruna.net.GameSession;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClothingViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ClothingViewState.class);
    private GameSession session;
    private Thread renderThread;
    private JobState workers;
    private ConcurrentHashMap<EntityId, ClothingView> viewIndex = new ConcurrentHashMap();
    private FabricType clearBase = new FabricType("clear", "clear").diffuse(new FabricTexture("human/female/BaseSkin.png")).specular(new FabricTexture(new ColorRGBA(0.05f, 0.05f, 0.05f, 0.05f)));

    public void updateClothing(EntityId id, Spatial spatial, ShapeName shapeName) {
        log.info("updateClothing(" + id + ", " + shapeName + ")");
        ShapeName clothing = this.getClothing(shapeName);
        ClothingView view = this.viewIndex.get(id);
        if (view == null && clothing == null) {
            return;
        }
        if (view == null) {
            view = new ClothingView(id, spatial, shapeName, clothing);
            this.viewIndex.put(id, view);
        } else if (view != null) {
            view.update(spatial, shapeName, clothing);
        }
        view.validate();
    }

    public void releaseClothing(EntityId id, Spatial spatial) {
        log.info("releaseClothing(" + id + ")");
        ClothingView view = this.viewIndex.remove(id);
        if (view != null) {
            view.release();
        }
    }

    protected ShapeName getClothing(ShapeName shapeName) {
        for (ShapeName addOn : shapeName.getAddOns()) {
            if (!"fab".equals(addOn.getType())) continue;
            return addOn;
        }
        return null;
    }

    protected boolean isRenderThread() {
        return Thread.currentThread() == this.renderThread;
    }

    protected void initialize(Application app) {
        this.renderThread = Thread.currentThread();
        this.session = ((GameSessionState)this.getState(GameSessionState.class, true)).getGameSession();
        this.workers = (JobState)this.getState(JobState.class, true);
        this.clearBase.initialize(this.getApplication().getAssetManager());
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
    }

    protected void onDisable() {
    }

    protected void setupMaterials(Spatial spatial, final ClothingPainter painter) {
        final String matDefCheck = "MatDefs/LocalLighting.j3md";
        final String textureCheck = "human/female/test-base.png";
        ColorRGBA localLighting = new ColorRGBA(0.1f, 0.1f, 0.1f, 1.0f);
        spatial.depthFirstTraversal((SceneGraphVisitor)new SceneGraphVisitorAdapter(){

            public void visit(Geometry geom) {
                Material mat = geom.getMaterial();
                log.info("geom:" + geom + "  material:" + mat);
                String matName = mat.getMaterialDef().getAssetName();
                if (!matDefCheck.equals(matName)) {
                    return;
                }
                MatParamTexture parm = (MatParamTexture)mat.getParam("DiffuseMap");
                log.info("parm:" + parm);
                Texture existing = parm.getTextureValue();
                log.info("  texture name:" + existing.getName());
                log.info("  asset key:" + existing.getKey());
                if (existing.getKey() == null || !textureCheck.equals(existing.getKey().toString())) {
                    return;
                }
                mat.setTexture("DiffuseMap", painter.getDiffuseTexture());
                mat.setTexture("NormalMap", painter.getNormalTexture());
                mat.setTexture("SpecularMap", painter.getSpecularTexture());
                mat.setBoolean("UseMaterialColors", true);
                mat.setColor("Diffuse", ColorRGBA.White);
                mat.setColor("Ambient", ColorRGBA.White);
                mat.setColor("Specular", ColorRGBA.White);
                mat.setFloat("Shininess", 512.0f);
            }
        });
    }

    private class ClothingView
    implements Job {
        private EntityId entityId;
        private Spatial spatial;
        private ShapeName shapeName;
        private ShapeName clothing;
        private ClothingPainter painter;
        private CellArray cells;
        private boolean repaint;
        private boolean updateTextures;
        private boolean queued;

        public ClothingView(EntityId entityId, Spatial spatial, ShapeName shapeName, ShapeName clothing) {
            log.info("ClothingView(" + spatial + ", " + shapeName + ", " + clothing + ")");
            this.entityId = entityId;
            this.spatial = spatial;
            this.shapeName = shapeName;
            this.clothing = clothing;
            this.painter = new ClothingPainter();
            this.repaint = true;
            this.updateTextures = true;
        }

        public boolean isInvalid() {
            return this.repaint || this.updateTextures;
        }

        public void validate() {
            log.info("validate():" + this.entityId);
            if (!this.isInvalid()) {
                return;
            }
            if (!ClothingViewState.this.isRenderThread()) {
                log.info("Already on a background thread:" + this.entityId);
                this.runOnWorker();
                if (this.spatial.getParent() == null) {
                    log.info("Not attached yet:" + this.entityId);
                    this.runOnUpdate();
                    return;
                }
            }
            ClothingViewState.this.workers.execute((Job)this, -1);
        }

        public void update(Spatial spatial, ShapeName shapeName, ShapeName clothing) {
            log.info("update(" + spatial + ", " + shapeName + ", " + clothing + ")");
            if (this.spatial != spatial) {
                log.info("*** spatial has changed");
                this.updateTextures = true;
                this.spatial = spatial;
            }
            if (!Objects.equals(clothing, this.clothing)) {
                log.info("*** clothing has changed");
                this.repaint = true;
                this.clothing = clothing;
                this.cells = null;
            }
        }

        public void release() {
        }

        public void runOnWorker() {
            if (this.repaint) {
                log.info("Reloading clothing cell array:" + this.entityId);
                CellArrayId id = CellArrayId.fromString((String)this.clothing.getName());
                this.cells = ClothingViewState.this.session.getCellArray(id);
                if (this.spatial.getParent() == null) {
                    log.info("Repainting clothes:" + this.entityId);
                    this.painter.repaint((CellData)this.cells, ClothingViewState.this.clearBase);
                    this.repaint = false;
                }
            }
            if (this.updateTextures && this.spatial.getParent() == null) {
                log.info("Updating textures:" + this.entityId);
                ClothingViewState.this.setupMaterials(this.spatial, this.painter);
                this.updateTextures = false;
            }
        }

        public double runOnUpdate() {
            double work = 0.0;
            if (this.repaint) {
                log.info("Repainting clothes:" + this.entityId);
                this.painter.repaint((CellData)this.cells, ClothingViewState.this.clearBase);
                this.repaint = false;
                work += 0.1;
            }
            if (this.updateTextures) {
                log.info("Updating textures:" + this.entityId);
                ClothingViewState.this.setupMaterials(this.spatial, this.painter);
                this.updateTextures = false;
                work += 0.1;
            }
            return work;
        }
    }
}

