/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.tile;

import java.util.function.Function;
import mythruna.world.tile.SedectileData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionIndexType {
    static Logger log = LoggerFactory.getLogger(RegionIndexType.class);
    public static final RegionIndexType LAND = new RegionIndexType(0, "land/sea", RegionIndexType.landMasses());
    private int typeId;
    private String name;
    private Function<SedectileData, int[][]> typesFunction;

    public RegionIndexType(int typeId, String name, Function<SedectileData, int[][]> typesFunction) {
        this.typeId = typeId;
        this.name = name;
        this.typesFunction = typesFunction;
    }

    public int[][] createTypes(SedectileData data) {
        return this.typesFunction.apply(data);
    }

    public static Function<SedectileData, int[][]> landMasses() {
        return new Function<SedectileData, int[][]>(){

            @Override
            public int[][] apply(SedectileData tile) {
                int count = tile.getSize();
                int[][] types = new int[count][count];
                for (int x = 0; x < count; ++x) {
                    for (int z = 0; z < count; ++z) {
                        short e = tile.getElevation(x, z);
                        types[x][z] = e < 124 ? 0 : 1;
                    }
                }
                return types;
            }
        };
    }
}

