/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.clothing;

import com.jme3.scene.Node;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Selector;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import java.util.Collection;
import java.util.Objects;
import mythruna.fabric.FabricType;
import mythruna.fabric.FabricTypeIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricTypeSelector
extends Container {
    static Logger log = LoggerFactory.getLogger(FabricTypeSelector.class);
    private VersionedList<String> names = new VersionedList();
    private VersionedList<String> variations = new VersionedList();
    private Selector<String> name;
    private VersionedReference<String> nameRef;
    private Selector<String> variant;
    private VersionedReference<String> variantRef;
    private int selectedType = -1;
    private VersionedHolder<FabricType> selectedFabricType = new VersionedHolder();

    public FabricTypeSelector() {
        if (this.selectedType == -1) {
            this.selectedType = FabricTypeIndex.findType((String)"linen", (String)"natural");
        }
        this.selectedFabricType.updateObject((Object)FabricTypeIndex.get((int)this.selectedType));
        ElementId parentId = new ElementId("block.popup");
        Container selectors = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Last, FillMode.Last)), new Object[0]);
        selectors.addChild((Node)new Label("Fabric:", parentId.child("label")), new Object[0]);
        this.name = (Selector)selectors.addChild((Node)new Selector(this.names, parentId.child("selector")), new Object[]{1});
        this.nameRef = this.name.createSelectedItemReference();
        selectors.addChild((Node)new Label("Style", parentId.child("label")), new Object[0]);
        this.variant = (Selector)selectors.addChild((Node)new Selector(this.variations, parentId.child("selector")), new Object[]{1});
        this.variantRef = this.variant.createSelectedItemReference();
        this.names.addAll(FabricTypeIndex.getNames());
        this.resetFields();
        this.resetSelectedType();
    }

    public void setSelectedType(int selectedType) {
        if (this.selectedType == selectedType) {
            return;
        }
        this.selectedType = selectedType;
        this.resetFields();
    }

    public int getSelectedType() {
        return this.selectedType;
    }

    public VersionedReference<FabricType> createSelectedTypeRef() {
        return this.selectedFabricType.createReference();
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        boolean changed = false;
        if (this.nameRef.update()) {
            this.resetVariations((String)this.nameRef.get());
            changed = true;
        }
        if (this.variantRef.update()) {
            changed = true;
        }
        if (changed) {
            this.resetSelectedType();
        }
    }

    protected void resetVariations(String baseName) {
        String original = (String)this.variant.getSelectedItem();
        this.variations.clear();
        Collection vars = FabricTypeIndex.getVariations((String)baseName);
        for (FabricType type : vars) {
            this.variations.add((Object)type.getVariation());
        }
        if (this.variations.contains((Object)original)) {
            this.variant.setSelectedItem((Object)original);
        } else if (this.variations.contains((Object)"natural")) {
            this.variant.setSelectedItem((Object)"natural");
        } else if (!this.variations.isEmpty()) {
            this.variant.setSelectedItem((Object)((String)this.variations.get(0)));
        }
    }

    protected void resetFields() {
        FabricType selected = FabricTypeIndex.get((int)this.selectedType);
        if (selected == null) {
            return;
        }
        this.name.setSelectedItem((Object)selected.getName());
        this.nameRef.update();
        this.resetVariations(selected.getName());
        this.variant.setSelectedItem((Object)selected.getVariation());
    }

    protected void resetSelectedType() {
        String n = (String)this.name.getSelectedItem();
        String v = (String)this.variant.getSelectedItem();
        for (int i = 0; i < FabricTypeIndex.getTypeCount(); ++i) {
            FabricType type = FabricTypeIndex.get((int)i);
            if (type == null || !Objects.equals(n, type.getName()) || !Objects.equals(v, type.getVariation())) continue;
            this.selectedType = i;
            this.selectedFabricType.updateObject((Object)type);
            break;
        }
    }
}

